/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.base;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.xyou.xcommon.map.XMap;
import org.xyou.xcommon.seq.XSeq;

public abstract class XBaseType
implements Serializable {
    String nameDefault;
    transient List<Integer> lsId;
    transient List<String> lsName;
    transient Set<Integer> setId;
    transient Set<String> setName;
    transient Map<Integer, String> mapIdName;
    transient Map<String, Integer> mapNameId;

    protected XBaseType() {
        this.init();
    }

    protected XBaseType(@NonNull String nameDefault) {
        if (nameDefault == null) {
            throw new NullPointerException("nameDefault is marked non-null but is null");
        }
        this.nameDefault = nameDefault;
        this.init();
    }

    void init() {
        this.mapIdName = new HashMap<Integer, String>();
        this.mapNameId = new HashMap<String, Integer>();
        this.lsId = new ArrayList<Integer>();
        this.lsName = new ArrayList<String>();
        XSeq.forEach(this.getClass().getDeclaredFields(), field -> {
            try {
                if (field.isSynthetic()) {
                    return;
                }
                int typeModifier = field.getModifiers();
                if (!Modifier.isStatic(typeModifier)) {
                    return;
                }
                if (!Modifier.isPublic(typeModifier)) {
                    return;
                }
                field.setAccessible(true);
                String name = field.getName();
                name = name.toUpperCase();
                Integer id = field.getInt(null);
                this.mapIdName.put(id, name);
                this.mapNameId.put(name, id);
                this.lsId.add(id);
                this.lsName.add(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.lsName = XMap.getLsValueByLsKey(this.mapIdName, this.lsId);
        this.setId = new HashSet<Integer>(this.lsId);
        this.setName = new HashSet<String>(this.lsName);
        this.mapNameId = XMap.reverse(this.mapIdName);
        this.lsId = Collections.unmodifiableList(this.lsId);
        this.lsName = Collections.unmodifiableList(this.lsName);
        this.setId = Collections.unmodifiableSet(this.setId);
        this.setName = Collections.unmodifiableSet(this.setName);
        this.mapIdName = Collections.unmodifiableMap(this.mapIdName);
        this.mapNameId = Collections.unmodifiableMap(this.mapNameId);
    }

    public Integer getId(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String nameUpperCase = name.toUpperCase();
        return this.mapNameId.get(nameUpperCase);
    }

    public String getName(@NonNull Integer id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        return this.mapIdName.getOrDefault(id, this.nameDefault);
    }

    public String getNameDefault() {
        return this.nameDefault;
    }

    public List<Integer> getLsId() {
        return this.lsId;
    }

    public List<String> getLsName() {
        return this.lsName;
    }

    public Set<Integer> getSetId() {
        return this.setId;
    }

    public Set<String> getSetName() {
        return this.setName;
    }

    public Map<Integer, String> getMapIdName() {
        return this.mapIdName;
    }

    public Map<String, Integer> getMapNameId() {
        return this.mapNameId;
    }
}

