/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.conf.XConf;
import org.xyou.xcommon.cvt.XCvt;
import org.xyou.xcommon.function.XSupplier;
import org.xyou.xcommon.lock.XLock;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerObj;
import org.xyou.xcommon.time.XTime;

public final class XCache<K, V>
extends XBaseObject {
    String name;
    Integer sizeMax;
    Integer setExpire;
    Integer sizeMaxNull;
    Integer secExpireNull;
    Boolean isProfiler;
    transient XLock poolLock;
    transient Cache<K, V> cache;
    transient Cache<K, Integer> cacheNull;
    transient XProfilerObj objProfiler;

    public XCache(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.init(new XConf(name));
    }

    public XCache(@NonNull XConf conf) {
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        this.init(conf);
    }

    void init(@NonNull XConf conf) {
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        this.name = conf.getName();
        this.sizeMax = conf.getInt("sizeMax");
        this.setExpire = conf.getInt("secExpire");
        this.sizeMaxNull = conf.getInt("sizeMaxNull", null);
        this.secExpireNull = conf.getInt("secExpireNull", null);
        this.isProfiler = conf.getBool("isProfiler", false);
        this.poolLock = new XLock();
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.sizeMax.intValue()).expireAfterWrite((long)this.setExpire.intValue(), TimeUnit.SECONDS).build();
        if (this.sizeMaxNull != null && this.secExpireNull != null) {
            this.cacheNull = CacheBuilder.newBuilder().maximumSize((long)this.sizeMaxNull.intValue()).expireAfterWrite((long)this.secExpireNull.intValue(), TimeUnit.SECONDS).build();
        }
        if (this.isProfiler.booleanValue()) {
            this.objProfiler = XProfiler.createObj(conf);
            this.objProfiler.scheduleGauge("size", this::size);
            this.objProfiler.scheduleGauge("sizeNull", this::sizeNull);
        }
    }

    public V get(@NonNull K key, @NonNull XSupplier<V> func) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return this.get(key, func, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(@NonNull K key, @NonNull XSupplier<V> func, @NonNull Boolean isForceLoad) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        if (isForceLoad == null) {
            throw new NullPointerException("isForceLoad is marked non-null but is null");
        }
        if (this.objProfiler != null) {
            this.objProfiler.incCounter("count_request");
        }
        Object value = null;
        if (!isForceLoad.booleanValue()) {
            value = this.cache.getIfPresent(key);
            if (value != null) {
                if (this.objProfiler != null) {
                    this.objProfiler.incCounter("count_hit");
                }
                return (V)value;
            }
            if (this.cacheNull != null && this.cacheNull.getIfPresent(key) != null) {
                if (this.objProfiler != null) {
                    this.objProfiler.incCounter("count_hit_null");
                }
                return (V)value;
            }
        }
        Object object = this.poolLock.get(key);
        synchronized (object) {
            if (!isForceLoad.booleanValue() && (value = this.cache.getIfPresent(key)) != null) {
                if (this.objProfiler != null) {
                    this.objProfiler.incCounter("count_hit");
                }
                return (V)value;
            }
            if (this.objProfiler != null) {
                this.objProfiler.incCounter("count_load");
            }
            if ((value = func.get()) != null) {
                if (this.objProfiler != null) {
                    this.objProfiler.incCounter("count_load_success");
                }
                this.put(key, value);
                return (V)value;
            }
            if (this.cacheNull != null) {
                this.cacheNull.put(key, (Object)XCvt.toInt(XTime.getCurSec()));
            }
        }
        return (V)value;
    }

    public void put(@NonNull K key, @NonNull V value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.cache.put(key, value);
    }

    public Long size() {
        return this.cache.size();
    }

    public Long sizeNull() {
        return this.cacheNull.size();
    }

    public String getName() {
        return this.name;
    }

    public Integer getSizeMax() {
        return this.sizeMax;
    }

    public Integer getSetExpire() {
        return this.setExpire;
    }

    public Integer getSizeMaxNull() {
        return this.sizeMaxNull;
    }

    public Integer getSecExpireNull() {
        return this.secExpireNull;
    }

    public Boolean getIsProfiler() {
        return this.isProfiler;
    }

    XProfilerObj getObjProfiler() {
        return this.objProfiler;
    }
}

