/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.cls;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.xyou.xcommon.cls.TraverseParam;
import org.xyou.xcommon.cls.Util;
import org.xyou.xcommon.entity.XObj;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.function.XFunction2;
import org.xyou.xcommon.log.XLog;
import org.xyou.xcommon.map.XMap;
import org.xyou.xcommon.seq.XSeq;

public final class XCls {
    static final transient XLog logger = new XLog();
    static final String puncSplit = ".";

    public static Class<?> getClassByTrace(@NonNull Integer idxTrace) {
        if (idxTrace == null) {
            throw new NullPointerException("idxTrace is marked non-null but is null");
        }
        return XCls.getClassByNameClass(new Exception().getStackTrace()[idxTrace + 1].getClassName());
    }

    public static Class<?> getClassEle(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (XCls.isArr(obj).booleanValue()) {
            return obj.getClass().getComponentType();
        }
        if (obj instanceof Iterable) {
            Iterable seq = (Iterable)obj;
            List<Class> lsCls = XSeq.map(seq, Object::getClass);
            return XSeq.reduce(lsCls, (c1, c2) -> c1 == c2 ? c1 : Object.class);
        }
        if (obj instanceof Field) {
            Field field = (Field)obj;
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            return (Class)type.getActualTypeArguments()[0];
        }
        throw XEx.createClassInvalid(obj);
    }

    public static Class<?> getClassByNameClass(@NonNull String nameClass) {
        if (nameClass == null) {
            throw new NullPointerException("nameClass is marked non-null but is null");
        }
        try {
            return Class.forName(nameClass);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getClassIfNot(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (obj instanceof Class) {
            return (Class)obj;
        }
        return obj.getClass();
    }

    public static Boolean is(@NonNull Object obj, @NonNull Class<?> cls) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return cls.isAssignableFrom(XCls.getClassIfNot(obj));
    }

    public static Boolean isPrimitive(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        return XCls.getClassIfNot(obj).isPrimitive();
    }

    public static Boolean isSimple(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (XCls.isStr(obj).booleanValue()) {
            return true;
        }
        if (XCls.isChar(obj).booleanValue()) {
            return true;
        }
        if (XCls.isByte(obj).booleanValue()) {
            return true;
        }
        if (XCls.isShort(obj).booleanValue()) {
            return true;
        }
        if (XCls.isInt(obj).booleanValue()) {
            return true;
        }
        if (XCls.isLong(obj).booleanValue()) {
            return true;
        }
        if (XCls.isFloat(obj).booleanValue()) {
            return true;
        }
        if (XCls.isDouble(obj).booleanValue()) {
            return true;
        }
        if (XCls.isBool(obj).booleanValue()) {
            return true;
        }
        return false;
    }

    public static Boolean isSeq(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        return XCls.isColl(obj) != false || XCls.isArr(obj) != false;
    }

    public static Boolean isColl(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        return XCls.is(obj, Collection.class);
    }

    public static Boolean isArr(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        return XCls.getClassIfNot(obj).isArray();
    }

    public static Boolean isStr(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, String.class);
    }

    public static Boolean isChar(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Character.class) != false || XCls.is(cls, Character.TYPE) != false;
    }

    public static Boolean isByte(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Byte.class) != false || XCls.is(cls, Byte.TYPE) != false;
    }

    public static Boolean isShort(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Short.class) != false || XCls.is(cls, Short.TYPE) != false;
    }

    public static Boolean isInt(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Integer.class) != false || XCls.is(cls, Integer.TYPE) != false;
    }

    public static Boolean isLong(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Long.class) != false || XCls.is(cls, Long.TYPE) != false;
    }

    public static Boolean isFloat(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Float.class) != false || XCls.is(cls, Float.TYPE) != false;
    }

    public static Boolean isDouble(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Double.class) != false || XCls.is(cls, Double.TYPE) != false;
    }

    public static Boolean isBool(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> cls = XCls.getClassIfNot(obj);
        return XCls.is(cls, Boolean.class) != false || XCls.is(cls, Boolean.TYPE) != false;
    }

    public static boolean equal(Object obj1, Object obj2) {
        try {
            if (obj1 == obj2) {
                return true;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            if (obj1 instanceof Collection && obj2 instanceof Collection) {
                Collection coll1 = (Collection)obj1;
                Collection coll2 = (Collection)obj2;
                int size = coll1.size();
                if (size != coll2.size()) {
                    return false;
                }
                Iterator iter1 = coll1.iterator();
                Iterator iter2 = coll2.iterator();
                for (int idx = 0; idx < size; ++idx) {
                    if (XCls.equal(iter1.next(), iter2.next())) continue;
                    return false;
                }
                return true;
            }
            if (XCls.isArr(obj1).booleanValue() && XCls.isArr(obj2).booleanValue()) {
                int size = Array.getLength(obj1);
                if (size != Array.getLength(obj2)) {
                    return false;
                }
                for (int idx = 0; idx < size; ++idx) {
                    if (XCls.equal(Array.get(obj1, idx), Array.get(obj2, idx))) continue;
                    return false;
                }
                return true;
            }
            if (obj1 instanceof Map && obj2 instanceof Map) {
                Map map1 = (Map)obj1;
                Map map2 = (Map)obj2;
                Set setKey1 = map1.keySet();
                Set setKey2 = map2.keySet();
                if (setKey1.size() != setKey2.size()) {
                    return false;
                }
                for (Object key : setKey1) {
                    if (setKey2.contains(key)) continue;
                    return false;
                }
                for (Object key : setKey2) {
                    if (!map1.containsKey(key)) {
                        return false;
                    }
                    if (XCls.equal(map1.get(key), map2.get(key))) continue;
                    return false;
                }
                return true;
            }
            return obj1.equals(obj2);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean set(@NonNull Object obj, @NonNull Object key, Object value) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            if (key instanceof String) {
                Field field = obj.getClass().getDeclaredField((String)key);
                return XCls.set(obj, field, value);
            }
            if (key instanceof Field) {
                Field field = (Field)key;
                field.setAccessible(true);
                field.set(obj, value);
                return true;
            }
            throw XEx.createClassInvalid(key);
        }
        catch (Throwable e) {
            logger.error(e);
            return false;
        }
    }

    public static Object call(@NonNull Object obj, @NonNull Object method, Object ... param) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (method == null) {
            throw new NullPointerException("method is marked non-null but is null");
        }
        try {
            if (method instanceof String) {
                return XCls.call(obj, XCls.getMethod(obj, (String)method), param);
            }
            if (method instanceof Method) {
                return ((Method)method).invoke(obj, param);
            }
            throw XEx.createClassInvalid(method);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(@NonNull Object obj, @NonNull String key) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            Method method = obj.getClass().getDeclaredMethod(key, Object.class);
            method.setAccessible(true);
            return method;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V get(@NonNull Object obj, @NonNull Object key) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        try {
            if (key instanceof String) {
                return XCls.get(obj, obj.getClass().getDeclaredField((String)key));
            }
            if (key instanceof Field) {
                Field field = (Field)key;
                field.setAccessible(true);
                Object value = XCls.cast(field.get(obj));
                return (V)value;
            }
            throw XEx.createClassInvalid(key);
        }
        catch (Throwable e) {
            logger.error(e);
            return null;
        }
    }

    public static List<Field> getLsField(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        ArrayList<Field> lsField = new ArrayList<Field>();
        Field[] arrField = cls.getDeclaredFields();
        XSeq.forEach(arrField, field -> {
            if (field.isSynthetic()) {
                return;
            }
            int typeModifier = field.getModifiers();
            if (Modifier.isStatic(typeModifier)) {
                return;
            }
            if (Modifier.isTransient(typeModifier)) {
                return;
            }
            field.setAccessible(true);
            lsField.add((Field)field);
        });
        return lsField;
    }

    public static Map<String, Field> getMapField(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        HashMap<String, Field> map = new HashMap<String, Field>();
        XCls.getLsField(cls).forEach(f -> map.put(f.getName(), (Field)f));
        return map;
    }

    public static List<String> getLsKey(@NonNull Class<?> obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        ArrayList<String> ls = new ArrayList<String>();
        XCls.getLsField(obj).forEach(field -> {
            String ele = field.getName();
            ls.add(ele);
        });
        return ls;
    }

    public static List<Object> getLsValue(@NonNull Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        ArrayList<Object> ls = new ArrayList<Object>();
        XCls.getLsField(obj.getClass()).forEach(field -> {
            try {
                Object ele = XCls.get(obj, field);
                ls.add(ele);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
        return ls;
    }

    public static <V> V initArr(@NonNull Class<?> clsEle, @NonNull Integer size) {
        if (clsEle == null) {
            throw new NullPointerException("clsEle is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        return (V)XCls.cast(Array.newInstance(clsEle, (int)size));
    }

    public static <T> T init(@NonNull Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        try {
            Constructor<T> constructor = cls.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T initLike(T obj) {
        if (obj == null) {
            return null;
        }
        Class cls = (Class)XCls.cast(obj.getClass());
        if (XCls.isArr(cls).booleanValue()) {
            int size = XSeq.size(obj);
            Class<?> clsEle = XCls.getClassEle(obj);
            return XCls.cast(XCls.initArr(clsEle, size));
        }
        return XCls.init(cls);
    }

    public static <T> T cast(Object obj) {
        Object objCast = obj;
        return (T)objCast;
    }

    static <T> T traverse(@NonNull TraverseParam<T> param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        Object obj = param.getObj();
        if (obj == null) {
            return null;
        }
        Class cls = (Class)XCls.cast(obj.getClass());
        if (XCls.isSimple(cls).booleanValue()) {
            return obj;
        }
        XFunction2<Object, Object, Boolean> select = param.getSelect();
        XFunction2<Object, Object, Object> map = param.getMap();
        XFunction2<Object, Integer, Boolean> filter = param.getFilter();
        if (XCls.isColl(cls).booleanValue()) {
            Iterable coll = (Iterable)obj;
            Iterable collNew = XCls.initLike(coll);
            Method method = XCls.getMethod(obj, "add");
            XSeq.forEach(XSeq.filter(coll, (V v, Integer i) -> Util.filter(v, i, filter)), e -> XCls.call(collNew, method, Util.map(null, e, map)));
            return XCls.cast(collNew);
        }
        if (XCls.is(cls, Object[].class).booleanValue()) {
            Object[] arr = (Object[])obj;
            List<Object> ls = XSeq.filter(arr, (V v, Integer i) -> Util.filter(v, i, filter));
            Class<?> clsEle = XCls.getClassEle(obj);
            Object[] arrNew = (Object[])XCls.initArr(clsEle, ls.size());
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = Util.map(null, e, map);
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, byte[].class).booleanValue()) {
            byte[] arr = (byte[])obj;
            List<Byte> ls = XSeq.filter(arr, (Byte v, Integer i) -> Util.filter(v, i, filter));
            byte[] arrNew = new byte[ls.size()];
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = (Byte)Util.map(null, e, map);
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, short[].class).booleanValue()) {
            short[] arr = (short[])obj;
            List<Short> ls = XSeq.filter(arr, (Short v, Integer i) -> Util.filter(v, i, filter));
            short[] arrNew = new short[ls.size()];
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = (Short)Util.map(null, e, map);
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, int[].class).booleanValue()) {
            int[] arr = (int[])obj;
            List<Integer> ls = XSeq.filter(arr, (Integer v, Integer i) -> Util.filter(v, i, filter));
            int[] arrNew = new int[ls.size()];
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = (Integer)Util.map(null, e, map);
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, long[].class).booleanValue()) {
            long[] arr = (long[])obj;
            List<Long> ls = XSeq.filter(arr, (Long v, Integer i) -> Util.filter(v, i, filter));
            long[] arrNew = new long[ls.size()];
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = (Long)Util.map(null, e, map);
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, float[].class).booleanValue()) {
            float[] arr = (float[])obj;
            List<Float> ls = XSeq.filter(arr, (Float v, Integer i) -> Util.filter(v, i, filter));
            float[] arrNew = new float[ls.size()];
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = ((Float)Util.map(null, e, map)).floatValue();
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, double[].class).booleanValue()) {
            double[] arr = (double[])obj;
            List<Double> ls = XSeq.filter(arr, (Double v, Integer i) -> Util.filter(v, i, filter));
            double[] arrNew = new double[ls.size()];
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = (Double)Util.map(null, e, map);
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, boolean[].class).booleanValue()) {
            boolean[] arr = (boolean[])obj;
            List<Boolean> ls = XSeq.filter(arr, (Boolean v, Integer i) -> Util.filter(v, i, filter));
            boolean[] arrNew = new boolean[ls.size()];
            XSeq.forEach(ls, (e, i) -> {
                arrNew[i.intValue()] = (Boolean)Util.map(null, e, map);
            });
            return XCls.cast(arrNew);
        }
        if (XCls.is(cls, XObj.class).booleanValue()) {
            XObj objX = (XObj)obj;
            XObj objXNew = new XObj();
            objXNew.setMap(XCls.traverse(TraverseParam.builder().obj(objX.getMap()).select(select).map(map).filter(filter).build()));
            return XCls.cast(objXNew);
        }
        if (XCls.is(cls, Map.class).booleanValue()) {
            Map m = (Map)XCls.cast(obj);
            HashMap mNew = new HashMap();
            XMap.forEach(m, (k, v) -> {
                if (!Util.select(k, v, select).booleanValue()) {
                    return;
                }
                mNew.put(k, Util.map(k, v, map));
            });
            return XCls.cast(mNew);
        }
        Object objNew = XCls.initLike(obj);
        XCls.getLsField(cls).forEach(field -> {
            Object v;
            String k = field.getName();
            if (!Util.select(k, v = XCls.get(obj, field), select).booleanValue()) {
                return;
            }
            XCls.set(objNew, field, Util.map(k, v, map));
        });
        return XCls.cast(objNew);
    }

    public static <T> T clone(T obj) {
        return XCls.traverse(TraverseParam.builder().obj(obj).map((k, v) -> XCls.clone(v)).build());
    }

    public static <T> T filter(T obj, XObj map) {
        return XCls.filter(obj, map.getMap());
    }

    public static <T> T filter(T obj, Map<?, ?> mapQuery) {
        if (obj == null) {
            return null;
        }
        if (XMap.isEmpty(mapQuery)) {
            return obj;
        }
        HashMap mapQueryParent = new HashMap();
        HashMap mapMapQueryChild = new HashMap();
        XMap.forEach(mapQuery, (k, v) -> {
            if (!(k instanceof String)) {
                mapQueryParent.put(k, v);
                return;
            }
            String key = (String)k;
            int idxSplit = key.indexOf(puncSplit);
            if (idxSplit <= 0) {
                mapQueryParent.put(key, v);
                return;
            }
            String keyParent = key.substring(0, idxSplit);
            HashMap<String, Object> mapChild = (HashMap<String, Object>)mapMapQueryChild.get(keyParent);
            if (mapChild == null) {
                mapChild = new HashMap<String, Object>();
                mapMapQueryChild.put(keyParent, mapChild);
            }
            String keyChild = key.substring(idxSplit + 1);
            mapChild.put(keyChild, v);
        });
        if (mapQueryParent.isEmpty() && mapMapQueryChild.isEmpty()) {
            return obj;
        }
        Class cls = (Class)XCls.cast(obj.getClass());
        if (XCls.isSeq(cls).booleanValue()) {
            return XCls.traverse(TraverseParam.builder().obj(obj).filter((v, i) -> {
                if (v == null) {
                    return true;
                }
                Class<?> clsEle = v.getClass();
                if (XCls.isSeq(clsEle).booleanValue()) {
                    return true;
                }
                if (XCls.is(clsEle, XObj.class).booleanValue()) {
                    XObj objX = (XObj)v;
                    return Util.isMatchAll(objX.getMap(), mapQueryParent);
                }
                if (XCls.is(clsEle, Map.class).booleanValue()) {
                    return Util.isMatchAll((Map)v, mapQueryParent);
                }
                Map<String, Field> mapField = XCls.getMapField(clsEle);
                for (Map.Entry entry : mapQueryParent.entrySet()) {
                    Object key = entry.getKey();
                    Object valueQuery = entry.getValue();
                    if (!mapField.containsKey(key)) {
                        return false;
                    }
                    Field field = mapField.get(key);
                    Object value = XCls.get(v, field);
                    if (Util.isMatch(value, valueQuery)) continue;
                    return false;
                }
                return true;
            }).map((k, v) -> XCls.filter(v, mapQuery)).build());
        }
        return XCls.traverse(TraverseParam.builder().obj(obj).map((k, v) -> XCls.filter(v, (Map)mapMapQueryChild.get(k))).build());
    }

    @SafeVarargs
    public static <T, K> T select(T obj, K ... seqKey) {
        return XCls.select(obj, XSeq.newHashSet(seqKey));
    }

    public static <T> T select(T obj, Iterable<?> seqKey) {
        if (obj == null) {
            return null;
        }
        if (seqKey == null) {
            return obj;
        }
        Set<?> setKey = XSeq.toSetIfNot(seqKey);
        if (setKey.isEmpty()) {
            return obj;
        }
        Class cls = (Class)XCls.cast(obj.getClass());
        if (XCls.isSeq(cls).booleanValue()) {
            return XCls.traverse(TraverseParam.builder().obj(obj).map((k, v) -> XCls.select(v, setKey)).build());
        }
        HashSet<Object> setKeyParent = new HashSet<Object>();
        setKeyParent.addAll(setKey);
        HashMap mapSetKeyChild = new HashMap();
        seqKey.forEach(k -> {
            if (!(k instanceof String)) {
                return;
            }
            String key = (String)k;
            int idxSplit = key.indexOf(puncSplit);
            if (idxSplit <= 0) {
                return;
            }
            String keyParent = key.substring(0, idxSplit);
            HashSet<String> setKeyChild = (HashSet<String>)mapSetKeyChild.get(keyParent);
            if (setKeyChild == null) {
                setKeyChild = new HashSet<String>();
                mapSetKeyChild.put(keyParent, setKeyChild);
            }
            String keyChild = key.substring(idxSplit + 1);
            setKeyChild.add(keyChild);
        });
        setKeyParent.addAll(mapSetKeyChild.keySet());
        return XCls.traverse(TraverseParam.builder().obj(obj).select((k, v) -> setKeyParent.contains(k)).map((k, v) -> XCls.select(v, (Iterable)mapSetKeyChild.get(k))).build());
    }

    @SafeVarargs
    public static <T, K> T filterSelect(T obj, XObj mapQuery, K ... seqKey) {
        return XCls.select(XCls.filter(obj, mapQuery), seqKey);
    }

    @SafeVarargs
    public static <T, K> T filterSelect(T obj, Map<?, ?> mapQuery, K ... seqKey) {
        return XCls.select(XCls.filter(obj, mapQuery), seqKey);
    }

    public static <T, K> T filterSelect(T obj, XObj mapQuery, Iterable<K> seqKey) {
        return XCls.select(XCls.filter(obj, mapQuery), seqKey);
    }

    public static <T, K> T filterSelect(T obj, Map<?, ?> mapQuery, Iterable<K> seqKey) {
        return XCls.select(XCls.filter(obj, mapQuery), seqKey);
    }
}

