/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.destruct;

import lombok.NonNull;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.log.XLog;
import org.xyou.xcommon.schedule.XSchedule;
import org.xyou.xcommon.schedule.XScheduleParam;

public final class XDestructor
extends XBaseObject {
    static final transient XLog logger = new XLog();
    Boolean isCancel;
    static transient XSchedule schedule;

    public XDestructor(@NonNull Long msMax) {
        if (msMax == null) {
            throw new NullPointerException("msMax is marked non-null but is null");
        }
        this.isCancel = false;
        long timeStart = System.currentTimeMillis();
        schedule = new XSchedule();
        schedule.scheduleAtFixedRate(XScheduleParam.builder().msPeriod(1000L).func(() -> {
            long timeCur = System.currentTimeMillis();
            long msPassed = timeCur - timeStart;
            if (msPassed > msMax) {
                logger.info("Process self-destructed");
                System.exit(-1);
            }
        }).build());
        logger.info("Destructor started");
    }

    public void cancel() {
        if (!this.isCancel.booleanValue()) {
            schedule.shutdown();
            this.isCancel = true;
            logger.info("Destructor cancel");
        } else {
            logger.info("Destructor has been cancelled");
        }
    }

    public Boolean getIsCancel() {
        return this.isCancel;
    }
}

