/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.math;

import lombok.NonNull;
import org.xyou.xcommon.app.XApp;
import org.xyou.xcommon.function.XFunction;
import org.xyou.xcommon.function.XFunction2;

public final class XMath {
    public static double computeLengthManhattan(@NonNull double[] vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        double sum = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            sum += vec[i];
        }
        return sum;
    }

    public static double computeLengthEuclid(@NonNull double[] vec) {
        if (vec == null) {
            throw new NullPointerException("vec is marked non-null but is null");
        }
        double sum = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            double value = vec[i];
            sum += value * value;
        }
        return Math.sqrt(sum);
    }

    public static double[] normalize(@NonNull double[] arrInput, @NonNull double[] arrOutput, @NonNull XFunction<double[], Double> computeLength) {
        if (arrInput == null) {
            throw new NullPointerException("arrInput is marked non-null but is null");
        }
        if (arrOutput == null) {
            throw new NullPointerException("arrOutput is marked non-null but is null");
        }
        if (computeLength == null) {
            throw new NullPointerException("computeLength is marked non-null but is null");
        }
        double normValue = computeLength.apply(arrInput);
        XApp.repeat((Integer)arrInput.length, i -> {
            arrOutput[i.intValue()] = arrInput[i] / normValue;
        });
        return arrOutput;
    }

    public static double[] normalizeL1(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XMath.normalize(arr, new double[arr.length], ele -> XMath.computeLengthManhattan(ele));
    }

    public static double[] normalizeL1InPlace(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XMath.normalize(arr, arr, XMath::computeLengthManhattan);
    }

    public static double[] normalizeL2(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XMath.normalize(arr, new double[arr.length], XMath::computeLengthEuclid);
    }

    public static double[] normalizeL2InPlace(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XMath.normalize(arr, arr, XMath::computeLengthEuclid);
    }

    public static double sigmoid(@NonNull Double inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return 1.0 / (1.0 + Math.exp(-inpt.doubleValue()));
    }

    public static double tanh(@NonNull Double inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return 2.0 / (1.0 + Math.exp(-2.0 * inpt)) - 1.0;
    }

    public static int argMax(@NonNull double[] arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        double valMax = -4.9E-324;
        int idxMax = 0;
        for (int idx = 0; idx < arr.length; ++idx) {
            double val = arr[idx];
            if (!(val > valMax)) continue;
            idxMax = idx;
            valMax = val;
        }
        return idxMax;
    }

    public static double dot(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        double product = 0.0;
        int length = arr1.length;
        for (int i = 0; i < length; ++i) {
            product += arr1[i] * arr2[i];
        }
        return product;
    }

    static double[] computeVector(@NonNull double[] arrRes, @NonNull double[] arr1, @NonNull double[] arr2, @NonNull XFunction2<Double, Double, Double> op) {
        if (arrRes == null) {
            throw new NullPointerException("arrRes is marked non-null but is null");
        }
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        if (op == null) {
            throw new NullPointerException("op is marked non-null but is null");
        }
        XApp.repeat((Integer)arr1.length, i -> {
            arrRes[i.intValue()] = (Double)op.apply(arr1[i], arr2[i]);
        });
        return arrRes;
    }

    public static double[] add(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        double[] arrRes = new double[arr1.length];
        return XMath.computeVector(arrRes, arr1, arr2, (e1, e2) -> e1 + e2);
    }

    public static double[] addInPlace(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        return XMath.computeVector(arr1, arr1, arr2, (e1, e2) -> e1 + e2);
    }

    public static double[] mul(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        double[] arrRes = new double[arr1.length];
        return XMath.computeVector(arrRes, arr1, arr2, (e1, e2) -> e1 * e2);
    }

    public static double[] mulInPlace(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        return XMath.computeVector(arr1, arr1, arr2, (e1, e2) -> e1 * e2);
    }

    public static double[] sub(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        double[] arrRes = new double[arr1.length];
        return XMath.computeVector(arrRes, arr1, arr2, (e1, e2) -> e1 - e2);
    }

    public static double[] subInPlace(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        return XMath.computeVector(arr1, arr1, arr2, (e1, e2) -> e1 - e2);
    }

    public static double[] div(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        double[] arrRes = new double[arr1.length];
        return XMath.computeVector(arrRes, arr1, arr2, (e1, e2) -> e1 / e2);
    }

    public static double[] divInPlace(@NonNull double[] arr1, @NonNull double[] arr2) {
        if (arr1 == null) {
            throw new NullPointerException("arr1 is marked non-null but is null");
        }
        if (arr2 == null) {
            throw new NullPointerException("arr2 is marked non-null but is null");
        }
        return XMath.computeVector(arr1, arr1, arr2, (e1, e2) -> e1 / e2);
    }
}

