/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.mem;

import lombok.NonNull;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.cvt.XCvt;
import org.xyou.xcommon.entity.XObj;

public class XMem {
    public static final Integer B_KB;
    public static final Integer KB_MB;
    public static final Integer KB_GB;
    public static final Integer KB_TB;
    static final XObj mapFormatType;

    static double fromKb(@NonNull Double kb, @NonNull Integer type) {
        if (kb == null) {
            throw new NullPointerException("kb is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        switch (type) {
            case 1: {
                return kb;
            }
            case 2: {
                return kb / (double)KB_MB.intValue();
            }
            case 3: {
                return kb / (double)KB_GB.intValue();
            }
            case 4: {
                return kb / (double)KB_TB.intValue();
            }
        }
        throw new RuntimeException("Invalid");
    }

    static double toKb(@NonNull Double value, @NonNull Integer type) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        switch (type) {
            case 1: {
                return value;
            }
            case 2: {
                return value * (double)KB_MB.intValue();
            }
            case 3: {
                return value * (double)KB_GB.intValue();
            }
            case 4: {
                return value * (double)KB_TB.intValue();
            }
        }
        throw new RuntimeException("Invalid");
    }

    public static String toStr(@NonNull Number kb, @NonNull String format) {
        if (kb == null) {
            throw new NullPointerException("kb is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        format = format.toUpperCase();
        int type = (Integer)XCls.cast(mapFormatType.get(format));
        double kbLong = XCvt.toDouble(kb);
        double value = XMem.fromKb(kbLong, type);
        return Math.round(value) + format;
    }

    public static Long fromStr(@NonNull String mem) {
        if (mem == null) {
            throw new NullPointerException("mem is marked non-null but is null");
        }
        String valueStr = mem.replaceAll("[^\\d.]+|\\.(?!\\d)", "");
        double value = XCvt.toDouble(valueStr);
        String format = mem.substring(valueStr.length());
        int type = (Integer)XCls.cast(mapFormatType.get(format));
        double kb = XMem.toKb(value, type);
        return Math.round(kb);
    }

    static {
        KB_MB = B_KB = Integer.valueOf(1024);
        KB_GB = B_KB * KB_MB;
        KB_TB = B_KB * KB_GB;
        mapFormatType = new XObj().put("KB", 1).put("MB", 2).put("GB", 3).put("TB", 4).put("K", 1).put("M", 2).put("G", 3).put("T", 4);
    }
}

