/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.queue;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import lombok.NonNull;
import org.xyou.xcommon.app.XApp;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.conf.XConf;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerObj;

public final class XQueue<V>
extends XBaseObject {
    String name;
    Integer sizeMax;
    Boolean isProfiler;
    transient BlockingQueue<V> queue;
    transient XProfilerObj objProfiler;

    public XQueue(@NonNull Integer sizeMax) {
        if (sizeMax == null) {
            throw new NullPointerException("sizeMax is marked non-null but is null");
        }
        this.sizeMax = sizeMax;
        this.queue = this.initQueue(sizeMax);
    }

    public XQueue(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.init(new XConf(name));
    }

    public XQueue(@NonNull XConf conf) {
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        this.init(conf);
    }

    void init(@NonNull XConf conf) {
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        this.name = conf.getName();
        this.sizeMax = conf.getInt("sizeMax");
        this.isProfiler = conf.getBool("isProfiler", false);
        this.queue = this.initQueue(this.sizeMax);
        if (this.isProfiler.booleanValue()) {
            this.objProfiler = XProfiler.createObj(conf);
            this.objProfiler.scheduleGauge("size", this::size);
        }
    }

    BlockingQueue<V> initQueue(@NonNull Integer sizeMax) {
        if (sizeMax == null) {
            throw new NullPointerException("sizeMax is marked non-null but is null");
        }
        return new ArrayBlockingQueue(sizeMax);
    }

    public boolean isFull() {
        return this.queue.size() == this.sizeMax.intValue();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public List<V> take(@NonNull Integer numData) {
        if (numData == null) {
            throw new NullPointerException("numData is marked non-null but is null");
        }
        ArrayList lsData = new ArrayList();
        XApp.repeat(numData, () -> {
            try {
                V data = this.queue.take();
                lsData.add(data);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        return lsData;
    }

    public V take() {
        try {
            return this.queue.take();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public V poll() {
        return (V)this.queue.poll();
    }

    public void put(@NonNull V data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        try {
            this.queue.put(data);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean offer(@NonNull V data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.queue.offer(data);
    }

    public boolean remove(@NonNull V data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return this.queue.remove(data);
    }

    public String getName() {
        return this.name;
    }

    public Integer getSizeMax() {
        return this.sizeMax;
    }
}

