/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.seq;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.xyou.xcommon.cls.XCls;
import org.xyou.xcommon.ex.XEx;
import org.xyou.xcommon.function.XConsumer;
import org.xyou.xcommon.function.XConsumer2;
import org.xyou.xcommon.function.XFunction;
import org.xyou.xcommon.function.XFunction2;
import org.xyou.xcommon.function.XSupplier;

public final class XSeq {
    @SafeVarargs
    public static <V> V[] newArr(V ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return arr;
    }

    public static <V> V[] newArr(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        int size = XSeq.size(coll);
        Class<?> cls = XCls.getClassEle(coll);
        Object[] arr = (Object[])XCls.initArr(cls, size);
        XSeq.forEach(coll, (V e, Integer i) -> {
            arr[i.intValue()] = e;
        });
        return arr;
    }

    public static <V> Collection<V> addAll(@NonNull Collection<V> coll, @NonNull Iterable<V> collOther) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        if (collOther == null) {
            throw new NullPointerException("collOther is marked non-null but is null");
        }
        collOther.forEach(coll::add);
        return coll;
    }

    @SafeVarargs
    public static <V> Collection<V> addAll(@NonNull Collection<V> coll, V ... arr) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        XSeq.forEach(arr, coll::add);
        return coll;
    }

    public static <V> List<V> newList(@NonNull XSupplier<List<V>> constructor, @NonNull Iterable<V> collEle) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        if (collEle == null) {
            throw new NullPointerException("collEle is marked non-null but is null");
        }
        return (List)XSeq.addAll((Collection)constructor.get(), collEle);
    }

    @SafeVarargs
    public static <V> List<V> newList(@NonNull XSupplier<List<V>> constructor, V ... arr) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return (List)XSeq.addAll((Collection)constructor.get(), arr);
    }

    public static <V> List<V> newArrayList(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.newList(ArrayList::new, coll);
    }

    @SafeVarargs
    public static <V> List<V> newArrayList(V ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XSeq.newList(ArrayList::new, arr);
    }

    public static <V> List<V> newLinkedList(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.newList(ArrayList::new, coll);
    }

    @SafeVarargs
    public static <V> List<V> newLinkedList(V ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XSeq.newList(LinkedList::new, arr);
    }

    public static <V> Set<V> newSet(@NonNull XSupplier<Set<V>> constructor, @NonNull Iterable<V> coll) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return (Set)XSeq.addAll((Collection)constructor.get(), coll);
    }

    @SafeVarargs
    public static <V> Set<V> newSet(@NonNull XSupplier<Set<V>> constructor, V ... arr) {
        if (constructor == null) {
            throw new NullPointerException("constructor is marked non-null but is null");
        }
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return (Set)XSeq.addAll((Collection)constructor.get(), arr);
    }

    public static <V> Set<V> newHashSet(@NonNull Iterable<V> collEle) {
        if (collEle == null) {
            throw new NullPointerException("collEle is marked non-null but is null");
        }
        return XSeq.newSet(HashSet::new, collEle);
    }

    @SafeVarargs
    public static <V> Set<V> newHashSet(V ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XSeq.newSet(HashSet::new, arr);
    }

    public static <V> Set<V> newTreeSet(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.newSet(TreeSet::new, coll);
    }

    @SafeVarargs
    public static <V> Set<V> newTreeSet(V ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XSeq.newSet(TreeSet::new, arr);
    }

    public static <V> Set<V> newLinkedHashSet(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.newSet(LinkedHashSet::new, coll);
    }

    @SafeVarargs
    public static <V> Set<V> newLinkedHashSet(V ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XSeq.newSet(LinkedHashSet::new, arr);
    }

    static <V> Set<V> newConcurrentHashSet() {
        return Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public static <V> Set<V> newConcurrentHashSet(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.newSet(XSeq::newConcurrentHashSet, coll);
    }

    @SafeVarargs
    public static <V> Set<V> newConcurrentHashSet(V ... arr) {
        if (arr == null) {
            throw new NullPointerException("arr is marked non-null but is null");
        }
        return XSeq.newSet(XSeq::newConcurrentHashSet, arr);
    }

    public static int size(@NonNull Object in) {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        if (in instanceof Object[]) {
            return ((Object[])in).length;
        }
        if (in instanceof byte[]) {
            return ((byte[])in).length;
        }
        if (in instanceof short[]) {
            return ((short[])in).length;
        }
        if (in instanceof int[]) {
            return ((int[])in).length;
        }
        if (in instanceof long[]) {
            return ((long[])in).length;
        }
        if (in instanceof float[]) {
            return ((float[])in).length;
        }
        if (in instanceof double[]) {
            return ((double[])in).length;
        }
        if (in instanceof boolean[]) {
            return ((boolean[])in).length;
        }
        if (in instanceof Collection) {
            return ((Collection)in).size();
        }
        if (in instanceof Iterable) {
            Iterator iter = ((Iterable)in).iterator();
            int size = 0;
            while (iter.hasNext()) {
                ++size;
            }
            return size;
        }
        throw XEx.createClassInvalid(in);
    }

    public static boolean isEmpty(Object seq) {
        if (seq == null) {
            return true;
        }
        if (seq instanceof Collection) {
            return ((Collection)seq).isEmpty();
        }
        if (XCls.isArr(seq).booleanValue()) {
            return Array.getLength(seq) == 0;
        }
        throw XEx.createClassInvalid(seq);
    }

    public static <V> Set<V> toSetIfNot(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        if (coll instanceof Set) {
            return (Set)coll;
        }
        return XSeq.newHashSet(coll);
    }

    public static <V> Set<V> intersect(@NonNull Iterable<V> col1, @NonNull Iterable<V> col2) {
        if (col1 == null) {
            throw new NullPointerException("col1 is marked non-null but is null");
        }
        if (col2 == null) {
            throw new NullPointerException("col2 is marked non-null but is null");
        }
        Set<V> set1 = XSeq.newHashSet(col1);
        Set set2 = XSeq.newHashSet(col2);
        if (set1.size() < set2.size()) {
            Set<V> setTmp = set1;
            set1 = set2;
            set2 = setTmp;
        }
        HashSet set = new HashSet();
        Set set2Final = set2;
        set1.forEach(e -> {
            if (set2Final.contains(e)) {
                set.add(e);
            }
        });
        return set;
    }

    public static <V> boolean containAll(@NonNull Iterable<V> coll1, @NonNull Iterable<V> coll2) {
        if (coll1 == null) {
            throw new NullPointerException("coll1 is marked non-null but is null");
        }
        if (coll2 == null) {
            throw new NullPointerException("coll2 is marked non-null but is null");
        }
        if (XSeq.isEmpty(coll2)) {
            return false;
        }
        Set<V> set1 = XSeq.toSetIfNot(coll1);
        for (V ele : coll2) {
            if (set1.contains(ele)) continue;
            return false;
        }
        return true;
    }

    public static <V> List<V> reverse(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        List<V> lsData = XSeq.newArrayList(coll);
        Collections.reverse(lsData);
        return lsData;
    }

    public static <V1, V2> boolean containAny(@NonNull Iterable<V1> coll1, @NonNull Iterable<V2> coll2) {
        if (coll1 == null) {
            throw new NullPointerException("coll1 is marked non-null but is null");
        }
        if (coll2 == null) {
            throw new NullPointerException("coll2 is marked non-null but is null");
        }
        Set<V1> set1 = XSeq.toSetIfNot(coll1);
        for (V2 ele : coll2) {
            if (!set1.contains(ele)) continue;
            return true;
        }
        return false;
    }

    public static <V> List<List<V>> partition(@NonNull Iterable<V> coll, @NonNull Integer size) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        ArrayList lsPart = new ArrayList();
        coll.forEach(ele -> {
            ArrayList<Object> part = null;
            int idxPart = lsPart.size() - 1;
            if (idxPart >= 0) {
                part = (List)lsPart.get(idxPart);
            }
            if (part == null || part.size() == size.intValue()) {
                part = new ArrayList<Object>();
                lsPart.add(part);
            }
            part.add(ele);
        });
        return lsPart;
    }

    public static <V> List<V> slice(@NonNull Iterable<V> coll, @NonNull Integer idxEnd) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        if (idxEnd == null) {
            throw new NullPointerException("idxEnd is marked non-null but is null");
        }
        return XSeq.slice(coll, null, idxEnd);
    }

    public static <V> List<V> slice(@NonNull Iterable<V> coll, Integer start, Integer end) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        int size = XSeq.size(coll);
        if (start == null) {
            start = 0;
        }
        if (end == null) {
            end = size;
        }
        if (start < 0) {
            start = start + size;
        }
        if (end < 0) {
            end = end + size;
        }
        if (start < 0) {
            throw new RuntimeException(String.format("start %s < 0", start));
        }
        if (end < 0) {
            throw new RuntimeException(String.format("end %s < 0", end));
        }
        if (start > end) {
            throw new RuntimeException(String.format("start %s > end %s", start, end));
        }
        int sizeSlice = end - start;
        ArrayList lsSub = new ArrayList();
        int startFinal = start;
        XSeq.forEach(coll, (V ele, Integer idx) -> {
            if (lsSub.size() == sizeSlice) {
                return;
            }
            if (idx >= startFinal) {
                lsSub.add(ele);
            }
        });
        return lsSub;
    }

    public static <V> void addNotNull(@NonNull Collection<V> coll, V ele) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        if (ele != null) {
            coll.add(ele);
        }
    }

    public static <V> List<V> shuffle(@NonNull Iterable<V> lsItem) {
        if (lsItem == null) {
            throw new NullPointerException("lsItem is marked non-null but is null");
        }
        List<V> lsData = XSeq.newArrayList(lsItem);
        Collections.shuffle(lsData);
        return lsData;
    }

    public static <V> List<V> shuffleLsTop(@NonNull List<V> lsItem, @NonNull Integer numTop) {
        if (lsItem == null) {
            throw new NullPointerException("lsItem is marked non-null but is null");
        }
        if (numTop == null) {
            throw new NullPointerException("numTop is marked non-null but is null");
        }
        if (numTop < 0) {
            throw new RuntimeException(String.format("numTop %s < 0", numTop));
        }
        ArrayList<V> lsData = new ArrayList<V>();
        List<V> lsTop = XSeq.slice(lsItem, null, numTop);
        List<V> lsRemain = XSeq.slice(lsItem, numTop, numTop + lsItem.size());
        Collections.shuffle(lsTop);
        lsData.addAll(lsTop);
        lsData.addAll(lsRemain);
        return lsData;
    }

    public static <V> List<V> shuffleLsLsByLsWeight(@NonNull List<List<V>> lsLs, @NonNull List<Double> lsWeight, @NonNull Integer sizePartition) {
        boolean isEmptyAllLs;
        if (lsLs == null) {
            throw new NullPointerException("lsLs is marked non-null but is null");
        }
        if (lsWeight == null) {
            throw new NullPointerException("lsWeight is marked non-null but is null");
        }
        if (sizePartition == null) {
            throw new NullPointerException("sizePartition is marked non-null but is null");
        }
        if (XSeq.isEmpty(lsLs)) {
            throw new RuntimeException("lsLs must have data.");
        }
        if (XSeq.isEmpty(lsWeight)) {
            throw new RuntimeException("lsWeight must have data.");
        }
        if (lsLs.size() != lsWeight.size()) {
            throw new RuntimeException("lsWeight must be the same size as lsWeight.");
        }
        if (Math.abs(XSeq.sum(lsWeight) - 1.0) > 0.01) {
            throw new RuntimeException("The sum of lsWeight must be 1.");
        }
        if (sizePartition < 1) {
            throw new RuntimeException("Size partition must at least 1.");
        }
        List lsIndex = lsLs.stream().map(ele -> 0).collect(Collectors.toList());
        List lsStep = lsWeight.stream().map(weight -> (int)Math.ceil(weight * (double)sizePartition.intValue())).collect(Collectors.toList());
        ArrayList lsResult = new ArrayList();
        ArrayList<V> lsShuffled = new ArrayList<V>();
        do {
            isEmptyAllLs = true;
            lsShuffled.clear();
            for (int idx = 0; idx < lsLs.size(); ++idx) {
                List<V> lsData = lsLs.get(idx);
                int idxFrom = (Integer)lsIndex.get(idx);
                if (XSeq.isEmpty(lsData) || idxFrom >= lsData.size()) continue;
                isEmptyAllLs = false;
                int step = (Integer)lsStep.get(idx);
                int idxTo = idxFrom + step;
                idxTo = Math.min(idxTo, lsData.size());
                lsShuffled.addAll(lsData.subList(idxFrom, idxTo));
                lsIndex.set(idx, idxTo);
            }
            Collections.shuffle(lsShuffled);
            lsResult.addAll(lsShuffled);
        } while (!isEmptyAllLs);
        return lsResult;
    }

    public static <V extends Number> double sum(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.reduce(XSeq.map(coll, (V v) -> v.doubleValue()), (V v1, V v2) -> v1 + v2);
    }

    public static <V extends Number> V min(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return (V)XSeq.reduce(coll, (V v1, V v2) -> v1.doubleValue() > v2.doubleValue() ? (Number)((Number)v2) : (Number)((Number)v1));
    }

    public static <V extends Number> V max(@NonNull Iterable<V> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return (V)XSeq.reduce(coll, (V v1, V v2) -> v1.doubleValue() > v2.doubleValue() ? (Number)((Number)v1) : (Number)((Number)v2));
    }

    public static <V> List<V> distinct(@NonNull Iterable<V> seq) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        HashSet set = new HashSet();
        ArrayList lsDistinct = new ArrayList();
        seq.forEach(e -> {
            if (set.contains(e)) {
                return;
            }
            lsDistinct.add(e);
            set.add(e);
        });
        return lsDistinct;
    }

    public static List<Byte> filter(@NonNull byte[] seq, @NonNull XFunction<Byte, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (Byte e, Integer i) -> (Boolean)func.apply((Byte)e));
    }

    public static List<Short> filter(@NonNull short[] seq, @NonNull XFunction<Short, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (Short e, Integer i) -> (Boolean)func.apply((Short)e));
    }

    public static List<Integer> filter(@NonNull int[] seq, @NonNull XFunction<Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (Integer e, Integer i) -> (Boolean)func.apply((Integer)e));
    }

    public static List<Long> filter(@NonNull long[] seq, @NonNull XFunction<Long, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (Long e, Integer i) -> (Boolean)func.apply((Long)e));
    }

    public static List<Float> filter(@NonNull float[] seq, @NonNull XFunction<Float, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (Float e, Integer i) -> (Boolean)func.apply((Float)e));
    }

    public static List<Double> filter(@NonNull double[] seq, @NonNull XFunction<Double, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (Double e, Integer i) -> (Boolean)func.apply((Double)e));
    }

    public static List<Boolean> filter(@NonNull boolean[] seq, @NonNull XFunction<Boolean, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (Boolean e, Integer i) -> (Boolean)func.apply((Boolean)e));
    }

    public static <V> List<V> filter(@NonNull V[] seq, @NonNull XFunction<V, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (V e, Integer i) -> (Boolean)func.apply(e));
    }

    public static <V> List<V> filter(@NonNull Iterable<V> seq, @NonNull XFunction<V, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.filter(seq, (V e, Integer i) -> (Boolean)func.apply(e));
    }

    public static List<Byte> filter(@NonNull byte[] seq, @NonNull XFunction2<Byte, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<Byte> ls = new ArrayList<Byte>();
        XSeq.forEach(seq, (Byte e, Integer i) -> {
            if (((Boolean)func.apply((Byte)e, (Integer)i)).booleanValue()) {
                ls.add((Byte)e);
            }
        });
        return ls;
    }

    public static List<Short> filter(@NonNull short[] seq, @NonNull XFunction2<Short, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<Short> ls = new ArrayList<Short>();
        XSeq.forEach(seq, (Short e, Integer i) -> {
            if (((Boolean)func.apply((Short)e, (Integer)i)).booleanValue()) {
                ls.add((Short)e);
            }
        });
        return ls;
    }

    public static List<Integer> filter(@NonNull int[] seq, @NonNull XFunction2<Integer, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<Integer> ls = new ArrayList<Integer>();
        XSeq.forEach(seq, (Integer e, Integer i) -> {
            if (((Boolean)func.apply((Integer)e, (Integer)i)).booleanValue()) {
                ls.add((Integer)e);
            }
        });
        return ls;
    }

    public static List<Long> filter(@NonNull long[] seq, @NonNull XFunction2<Long, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<Long> ls = new ArrayList<Long>();
        XSeq.forEach(seq, (Long e, Integer i) -> {
            if (((Boolean)func.apply((Long)e, (Integer)i)).booleanValue()) {
                ls.add((Long)e);
            }
        });
        return ls;
    }

    public static List<Float> filter(@NonNull float[] seq, @NonNull XFunction2<Float, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<Float> ls = new ArrayList<Float>();
        XSeq.forEach(seq, (Float e, Integer i) -> {
            if (((Boolean)func.apply((Float)e, (Integer)i)).booleanValue()) {
                ls.add((Float)e);
            }
        });
        return ls;
    }

    public static List<Double> filter(@NonNull double[] seq, @NonNull XFunction2<Double, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<Double> ls = new ArrayList<Double>();
        XSeq.forEach(seq, (Double e, Integer i) -> {
            if (((Boolean)func.apply((Double)e, (Integer)i)).booleanValue()) {
                ls.add((Double)e);
            }
        });
        return ls;
    }

    public static List<Boolean> filter(@NonNull boolean[] seq, @NonNull XFunction2<Boolean, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList<Boolean> ls = new ArrayList<Boolean>();
        XSeq.forEach(seq, (Boolean e, Integer i) -> {
            if (((Boolean)func.apply((Boolean)e, (Integer)i)).booleanValue()) {
                ls.add((Boolean)e);
            }
        });
        return ls;
    }

    public static <V> List<V> filter(@NonNull V[] seq, @NonNull XFunction2<V, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList ls = new ArrayList();
        XSeq.forEach(seq, (V e, Integer i) -> {
            if (((Boolean)func.apply((Object)e, (Integer)i)).booleanValue()) {
                ls.add(e);
            }
        });
        return ls;
    }

    public static <V> List<V> filter(@NonNull Iterable<V> seq, @NonNull XFunction2<V, Integer, Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList ls = new ArrayList();
        XSeq.forEach(seq, (V e, Integer i) -> {
            if (((Boolean)func.apply((Object)e, (Integer)i)).booleanValue()) {
                ls.add(e);
            }
        });
        return ls;
    }

    public static <V, T> List<T> map(@NonNull V[] seq, @NonNull XFunction<V, T> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.map(seq, (V e, Integer i) -> func.apply(e));
    }

    public static <V, T> List<T> map(@NonNull Iterable<V> coll, @NonNull XFunction<V, T> func) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.map(coll, (V e, Integer i) -> func.apply(e));
    }

    public static <V, T> List<T> map(@NonNull V[] seq, @NonNull XFunction2<V, Integer, T> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList ls = new ArrayList();
        XSeq.forEach(seq, (V e, Integer i) -> ls.add(func.apply((Object)e, (Integer)i)));
        return ls;
    }

    public static <V, T> List<T> map(@NonNull Iterable<V> seq, @NonNull XFunction2<V, Integer, T> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        ArrayList ls = new ArrayList();
        XSeq.forEach(seq, (V e, Integer i) -> ls.add(func.apply((Object)e, (Integer)i)));
        return ls;
    }

    public static <V> V reduce(@NonNull V[] seq, @NonNull XFunction2<V, V, V> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return XSeq.reduce(XSeq.newArrayList(seq), func);
    }

    public static <V> V reduce(@NonNull Iterable<V> seq, @NonNull XFunction2<V, V, V> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        Iterator<V> iterator = seq.iterator();
        V d = iterator.next();
        while (iterator.hasNext()) {
            d = func.apply(d, iterator.next());
        }
        return d;
    }

    public static void forEach(@NonNull byte[] seq, @NonNull XConsumer<Byte> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (Byte e, Integer i) -> func.accept((Byte)e));
    }

    public static void forEach(@NonNull short[] seq, @NonNull XConsumer<Short> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (Short e, Integer i) -> func.accept((Short)e));
    }

    public static void forEach(@NonNull int[] seq, @NonNull XConsumer<Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (Integer e, Integer i) -> func.accept((Integer)e));
    }

    public static void forEach(@NonNull long[] seq, @NonNull XConsumer<Long> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (Long e, Integer i) -> func.accept((Long)e));
    }

    public static void forEach(@NonNull float[] seq, @NonNull XConsumer<Float> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (Float e, Integer i) -> func.accept((Float)e));
    }

    public static void forEach(@NonNull double[] seq, @NonNull XConsumer<Double> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (Double e, Integer i) -> func.accept((Double)e));
    }

    public static void forEach(@NonNull boolean[] seq, @NonNull XConsumer<Boolean> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (Boolean e, Integer i) -> func.accept((Boolean)e));
    }

    public static <V> void forEach(@NonNull V[] seq, @NonNull XConsumer<V> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (V e, Integer i) -> func.accept(e));
    }

    public static <V> void forEach(@NonNull Iterable<V> seq, @NonNull XConsumer<V> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XSeq.forEach(seq, (V e, Integer i) -> func.accept(e));
    }

    public static void forEach(@NonNull byte[] seq, @NonNull XConsumer2<Byte, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (byte e : seq) {
            func.accept(e, i);
            ++i;
        }
    }

    public static void forEach(@NonNull short[] seq, @NonNull XConsumer2<Short, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (short e : seq) {
            func.accept(e, i);
            ++i;
        }
    }

    public static void forEach(@NonNull int[] seq, @NonNull XConsumer2<Integer, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (int e : seq) {
            func.accept(e, i);
            ++i;
        }
    }

    public static void forEach(@NonNull long[] seq, @NonNull XConsumer2<Long, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (long e : seq) {
            func.accept(e, i);
            ++i;
        }
    }

    public static void forEach(@NonNull float[] seq, @NonNull XConsumer2<Float, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (float e : seq) {
            func.accept(Float.valueOf(e), i);
            ++i;
        }
    }

    public static void forEach(@NonNull double[] seq, @NonNull XConsumer2<Double, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (double e : seq) {
            func.accept(e, i);
            ++i;
        }
    }

    public static void forEach(@NonNull boolean[] seq, @NonNull XConsumer2<Boolean, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (boolean e : seq) {
            func.accept(e, i);
            ++i;
        }
    }

    public static <V> void forEach(@NonNull V[] seq, @NonNull XConsumer2<V, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (V e : seq) {
            func.accept(e, i);
            ++i;
        }
    }

    public static <V> void forEach(@NonNull Iterable<V> seq, @NonNull XConsumer2<V, Integer> func) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        int i = 0;
        for (V e : seq) {
            func.accept(e, i);
            ++i;
        }
    }
}

