/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.str;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import lombok.NonNull;
import org.xyou.xcommon.app.XApp;
import org.xyou.xcommon.function.XConsumer;
import org.xyou.xcommon.seq.XSeq;
import org.xyou.xcommon.str.XStrBuilder;
import org.xyou.xcommon.str.XStrJoiner;

public final class XStr {
    public static boolean isEmpty(String data) {
        return data == null || data.isEmpty();
    }

    public static String castEmptyOnNull(String data) {
        return data == null ? "" : data;
    }

    public static String encodeBase64(@NonNull byte[] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return Base64.getUrlEncoder().encodeToString(data);
    }

    public static byte[] decodeBase64(@NonNull String dataEncoded) {
        if (dataEncoded == null) {
            throw new NullPointerException("dataEncoded is marked non-null but is null");
        }
        return Base64.getUrlDecoder().decode(dataEncoded);
    }

    public static String toSnakeFromCamel(@NonNull String data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        XStrBuilder builder = new XStrBuilder();
        XApp.repeat((Integer)data.length(), idx -> {
            char character = data.charAt((int)idx);
            if (Character.isUpperCase(character)) {
                builder.append("_");
                builder.append(Character.valueOf(Character.toLowerCase(character)));
            } else {
                builder.append(Character.valueOf(character));
            }
        });
        return builder.toString();
    }

    public static String toSnakeFromSnakeUpper(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return inpt.toLowerCase();
    }

    public static String toSnakeUpperFromSnake(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return inpt.toUpperCase();
    }

    public static String toSnakeUpperFromCamel(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toSnakeUpperFromSnake(XStr.toSnakeFromCamel(inpt));
    }

    public static String toSnakeUpperFromKebab(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toSnakeUpperFromSnake(XStr.toSnakeFromKebab(inpt));
    }

    public static String toSnakeUpperFromPascal(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toSnakeUpperFromSnake(XStr.toSnakeFromPascal(inpt));
    }

    public static String toSnakeFromKebab(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return inpt.replace('-', '_');
    }

    public static String toSnakeFromPascal(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toSnakeFromCamel(XStr.toCamelFromPascal(inpt));
    }

    public static String toCamelFromPascal(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return inpt.substring(0, 1).toLowerCase() + inpt.substring(1);
    }

    public static String toCamelFromSnake(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        XStrBuilder builder = new XStrBuilder();
        for (int idx = 0; idx < inpt.length(); ++idx) {
            char character = inpt.charAt(idx);
            if (idx > 0 && character == '_') {
                builder.append(Character.valueOf(Character.toUpperCase(inpt.charAt(idx + 1))));
                ++idx;
                continue;
            }
            builder.append(Character.valueOf(character));
        }
        return builder.toString();
    }

    public static String toCamelFromSnakeUpper(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toCamelFromSnake(XStr.toSnakeFromSnakeUpper(inpt));
    }

    public static String toCamelFromKebab(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toCamelFromSnake(XStr.toSnakeFromKebab(inpt));
    }

    public static String toPascalFromCamel(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return inpt.substring(0, 1).toUpperCase() + inpt.substring(1);
    }

    public static String toPascalFromSnake(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toPascalFromCamel(XStr.toCamelFromSnake(inpt));
    }

    public static String toPascalFromSnakeUpper(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toPascalFromCamel(XStr.toCamelFromSnakeUpper(inpt));
    }

    public static String toPascalFromKebab(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toPascalFromCamel(XStr.toCamelFromKebab(inpt));
    }

    public static String toKebabFromSnake(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return inpt.replace('_', '-');
    }

    public static String toKebabFromSnakeUpper(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toKebabFromSnake(XStr.toSnakeFromSnakeUpper(inpt));
    }

    public static String toKebabFromCamel(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toKebabFromSnake(XStr.toSnakeFromCamel(inpt));
    }

    public static String toKebabFromPascal(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return XStr.toKebabFromSnake(XStr.toSnakeFromPascal(inpt));
    }

    public static String sliceEdge(@NonNull String inpt) {
        if (inpt == null) {
            throw new NullPointerException("inpt is marked non-null but is null");
        }
        return inpt.substring(1, inpt.length() - 1);
    }

    public static List<String> toSnakeFromCamel(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeFromCamel(e));
    }

    public static List<String> toSnakeFromSnakeUpper(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeFromSnakeUpper(e));
    }

    public static List<String> toSnakeUpperFromSnake(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeUpperFromSnake(e));
    }

    public static List<String> toSnakeUpperFromCamel(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeUpperFromCamel(e));
    }

    public static List<String> toSnakeUpperFromKebab(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeUpperFromKebab(e));
    }

    public static List<String> toSnakeUpperFromPascal(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeUpperFromPascal(e));
    }

    public static List<String> toSnakeFromKebab(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeFromKebab(e));
    }

    public static List<String> toSnakeFromPascal(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toSnakeFromPascal(e));
    }

    public static List<String> toCamelFromPascal(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toCamelFromPascal(e));
    }

    public static List<String> toCamelFromKebab(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toCamelFromKebab(e));
    }

    public static List<String> toCamelFromSnake(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toCamelFromSnake(e));
    }

    public static List<String> toCamelFromSnakeUpper(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toCamelFromSnakeUpper(e));
    }

    public static List<String> toPascalFromCamel(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toPascalFromCamel(e));
    }

    public static List<String> toPascalFromKebab(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toPascalFromKebab(e));
    }

    public static List<String> toPascalFromSnake(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toPascalFromSnake(e));
    }

    public static List<String> toPascalFromSnakeUpper(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toPascalFromSnakeUpper(e));
    }

    public static List<String> toKebabFromSnake(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toKebabFromSnake(e));
    }

    public static List<String> toKebabFromCamel(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toKebabFromCamel(e));
    }

    public static List<String> toKebabFromSnakeUpper(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toKebabFromSnakeUpper(e));
    }

    public static List<String> toKebabFromPascal(@NonNull Collection<String> coll) {
        if (coll == null) {
            throw new NullPointerException("coll is marked non-null but is null");
        }
        return XSeq.map(coll, e -> XStr.toKebabFromPascal(e));
    }

    public static String build(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream is marked non-null but is null");
        }
        try {
            XStrBuilder builder = new XStrBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                int c;
                while ((c = ((Reader)reader).read()) != -1) {
                    builder.append(Character.valueOf((char)c));
                }
            }
            if (builder.length() == 0) {
                return null;
            }
            return builder.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static String join(@NonNull Object delimiter, @NonNull XConsumer<XStrJoiner> func) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        XStrJoiner joiner = new XStrJoiner(delimiter.toString());
        func.accept(joiner);
        return joiner.toString();
    }

    public static String join(@NonNull Object delimiter, @NonNull Iterable<?> collEle) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        if (collEle == null) {
            throw new NullPointerException("collEle is marked non-null but is null");
        }
        return XStr.join(delimiter, (XStrJoiner j) -> collEle.forEach(e -> j.add(e)));
    }

    public static String join(@NonNull Object delimiter, Object ... arrEle) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        if (arrEle == null) {
            throw new NullPointerException("arrEle is marked non-null but is null");
        }
        return XStr.join(delimiter, (XStrJoiner j) -> XSeq.forEach(arrEle, j::add));
    }
}

