/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.thread;

import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.xyou.xcommon.base.XBaseObject;
import org.xyou.xcommon.conf.XConf;
import org.xyou.xcommon.function.XSupplier;
import org.xyou.xcommon.profiler.XProfiler;
import org.xyou.xcommon.profiler.XProfilerObj;
import org.xyou.xcommon.thread.XThreadFuture;

public final class XThreadPool
extends XBaseObject {
    String name;
    Integer numThread;
    Integer sizeQueueMax;
    Boolean isProfiler;
    transient ThreadPoolExecutor pool;
    transient XProfilerObj objProfiler;

    public XThreadPool(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.init(new XConf(name));
    }

    public XThreadPool(@NonNull XConf conf) {
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        this.init(conf);
    }

    void init(@NonNull XConf conf) {
        if (conf == null) {
            throw new NullPointerException("conf is marked non-null but is null");
        }
        this.name = conf.getName();
        this.numThread = conf.getInt("numThread");
        this.sizeQueueMax = conf.getInt("sizeQueueMax");
        this.isProfiler = conf.getBool("isProfiler", false);
        this.initPool(this.numThread, this.sizeQueueMax);
        if (this.isProfiler.booleanValue()) {
            this.objProfiler = XProfiler.createObj(conf);
            this.objProfiler.scheduleGauge("size", this::sizeQueue);
        }
    }

    public XThreadPool(@NonNull Integer numThread, @NonNull Integer sizeQueueMax) {
        if (numThread == null) {
            throw new NullPointerException("numThread is marked non-null but is null");
        }
        if (sizeQueueMax == null) {
            throw new NullPointerException("sizeQueueMax is marked non-null but is null");
        }
        this.initPool(numThread, sizeQueueMax);
    }

    private void initPool(@NonNull Integer numThread, @NonNull Integer sizeQueueMax) {
        if (numThread == null) {
            throw new NullPointerException("numThread is marked non-null but is null");
        }
        if (sizeQueueMax == null) {
            throw new NullPointerException("sizeQueueMax is marked non-null but is null");
        }
        this.numThread = numThread;
        this.sizeQueueMax = sizeQueueMax;
        LinkedBlockingDeque<Runnable> queue = new LinkedBlockingDeque<Runnable>(sizeQueueMax);
        this.pool = new ThreadPoolExecutor(numThread, numThread, 60000L, TimeUnit.MILLISECONDS, queue);
    }

    public int sizeQueue() {
        return this.pool.getQueue().size();
    }

    public XThreadFuture submit(@NonNull Runnable func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return new XThreadFuture(this.pool.submit(func::run));
    }

    public XThreadFuture submit(@NonNull XSupplier<?> func) {
        if (func == null) {
            throw new NullPointerException("func is marked non-null but is null");
        }
        return new XThreadFuture(this.pool.submit(func::get));
    }

    public boolean shutdown() {
        return this.shutdown(Long.MAX_VALUE);
    }

    public boolean shutdown(@NonNull Long msWait) {
        if (msWait == null) {
            throw new NullPointerException("msWait is marked non-null but is null");
        }
        try {
            this.pool.shutdown();
            return this.pool.awaitTermination(msWait, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    public Integer getNumThread() {
        return this.numThread;
    }

    public Integer getSizeQueueMax() {
        return this.sizeQueueMax;
    }

    public Boolean getIsProfiler() {
        return this.isProfiler;
    }
}

