/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.time;

import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.NonNull;

public final class XTime {
    public static final String FM_SLASH_YM = "yyyy/MM";
    public static final String FM_SLASH_YMD = "yyyy/MM/dd";
    public static final String FM_SLASH_YMDH = "yyyy/MM/dd/HH";
    public static final String FM_SLASH_YMDHM = "yyyy/MM/dd/HH/mm";
    public static final String FM_SLASH_YMDHMS = "yyyy/MM/dd/HH/mm/ss";
    public static final String FM_SLASH_YMDHMSM = "yyyy/MM/dd/HH/mm/ss/SSS";
    public static final String FM_HYPHEN_YMD = "yyyy-MM-dd";
    public static final String FM_HYPHEN_YMDH = "yyyy-MM-dd-HH";
    public static final String FM_HYPHEN_YMDHM = "yyyy-MM-dd-HH-mm";
    public static final String FM_HYPHEN_YMDHMS = "yyyy-MM-dd-HH-mm-ss";
    public static final String FM_HYPHEN_YMDHMSM = "yyyy-MM-dd-HH-mm-ss-SSS";
    public static final String FM_YMD = "yyyyMMdd";
    public static final String FM_YMDH = "yyyyMMddHH";
    public static final String FM_DATE_TIME = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final long SEC_MIN = 60L;
    public static final long SEC_HR = 3600L;
    public static final long SEC_DAY = 86400L;
    public static final long SEC_WEEK = 604800L;
    public static final long SEC_MONTH = 2592000L;
    public static final long SEC_YEAR = 31536000L;
    public static final long MS_SEC = 1000L;
    public static final long MS_MIN = 60000L;
    public static final long MS_HR = 3600000L;
    public static final long MS_DAY = 86400000L;
    public static final long MS_WEEK = 604800000L;
    public static final long MS_MONTH = 2592000000L;
    public static final long MS_YEAR = 31536000000L;
    public static final long US_SEC = 1000000L;
    public static final long US_MIN = 60000000L;
    public static final long US_HR = 3600000L;
    public static final long US_DAY = 86400000L;
    public static final long US_WEEK = 604800000L;
    public static final long US_MONTH = 2592000000L;
    public static final long US_YEAR = 31536000000L;
    public static final long NS_US = 1000L;
    public static final long NS_MS = 1000000L;
    public static final long NS_SEC = 1000000000L;
    public static final long NS_MIN = 60000000000L;
    public static final long NS_HR = 3600000000000L;
    public static final long NS_DAY = 86400000000000L;
    public static final long NS_WEEK = 604800000000000L;
    public static final long NS_MONTH = 2592000000000000L;
    public static final long NS_YEAR = 31536000000000000L;
    public static final Long TIME_START = XTime.getCurMs();
    public static final String TIME_START_SLASH_YMD = XTime.toStrMs(TIME_START, "yyyy/MM/dd");
    public static final String TIME_START_SLASH_YMDH = XTime.toStrMs(TIME_START, "yyyy/MM/dd/HH");
    public static final String TIME_START_HYPHEN_YMDHMS = XTime.toStrMs(TIME_START, "yyyy-MM-dd-HH-mm-ss");

    public static long truncate(@NonNull Number timestamp, @NonNull Number timestampRef) {
        if (timestamp == null) {
            throw new NullPointerException("timestamp is marked non-null but is null");
        }
        if (timestampRef == null) {
            throw new NullPointerException("timestampRef is marked non-null but is null");
        }
        return timestamp.longValue() / timestampRef.longValue();
    }

    public static long roundDay(@NonNull Number timestampMs) {
        if (timestampMs == null) {
            throw new NullPointerException("timestampMs is marked non-null but is null");
        }
        String timeRoudStr = XTime.toStrMs(timestampMs, FM_YMD);
        return XTime.fromStrMs(timeRoudStr, FM_YMD);
    }

    public static long round(@NonNull Number timestamp, @NonNull Number timestampRef) {
        if (timestamp == null) {
            throw new NullPointerException("timestamp is marked non-null but is null");
        }
        if (timestampRef == null) {
            throw new NullPointerException("timestampRef is marked non-null but is null");
        }
        return XTime.truncate(timestamp, timestampRef) * timestampRef.longValue();
    }

    public static long normWeekSec(@NonNull Number timestampSec) {
        if (timestampSec == null) {
            throw new NullPointerException("timestampSec is marked non-null but is null");
        }
        return XTime.normWeekSec(timestampSec, 0L);
    }

    public static long normWeekSec(@NonNull Number timestampSec, @NonNull Number timestampRefSec) {
        if (timestampSec == null) {
            throw new NullPointerException("timestampSec is marked non-null but is null");
        }
        if (timestampRefSec == null) {
            throw new NullPointerException("timestampRefSec is marked non-null but is null");
        }
        return XTime.normWeekMs(timestampSec.longValue() * 1000L, timestampRefSec.longValue() * 1000L) / 1000L;
    }

    public static long normWeekMs(@NonNull Number timestampMs) {
        if (timestampMs == null) {
            throw new NullPointerException("timestampMs is marked non-null but is null");
        }
        return XTime.normWeekMs(timestampMs, 0);
    }

    public static long normWeekMs(@NonNull Number timestampMs, @NonNull Number timestampRefMs) {
        long timeRefNorm;
        if (timestampMs == null) {
            throw new NullPointerException("timestampMs is marked non-null but is null");
        }
        if (timestampRefMs == null) {
            throw new NullPointerException("timestampRefMs is marked non-null but is null");
        }
        long timeNorm = timestampMs.longValue() % 604800000L;
        if (timeNorm < (timeRefNorm = timestampRefMs.longValue() % 604800000L)) {
            timeNorm += 604800000L;
        }
        return timeNorm;
    }

    public static long getCurMs() {
        return System.currentTimeMillis();
    }

    public static long getCurSec() {
        return XTime.getCurMs() / 1000L;
    }

    public static Long fromStrMs(@NonNull String timeStr, @NonNull String format) {
        if (timeStr == null) {
            throw new NullPointerException("timeStr is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat(format);
            Date date = dateFormatter.parse(timeStr);
            long timestamp = date.getTime();
            return timestamp;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Long fromStrSec(@NonNull String timeStr, @NonNull String format) {
        if (timeStr == null) {
            throw new NullPointerException("timeStr is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return XTime.fromStrMs(timeStr, format) / 1000L;
    }

    public static String toStrMs(@NonNull Number timestampMs, @NonNull String format) {
        if (timestampMs == null) {
            throw new NullPointerException("timestampMs is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        Date date = new Date(timestampMs.longValue());
        String timeStr = formatter.format(date);
        return timeStr;
    }

    public static String toStrSec(@NonNull Number timestampSec, @NonNull String format) {
        if (timestampSec == null) {
            throw new NullPointerException("timestampSec is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        return XTime.toStrMs(timestampSec.longValue() * 1000L, format);
    }

    public static void sleep(@NonNull Number ms) {
        if (ms == null) {
            throw new NullPointerException("ms is marked non-null but is null");
        }
        try {
            Thread.sleep(ms.longValue());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

