/*
 * Decompiled with CFR 0.152.
 */
package org.xyou.xcommon.url;

import java.net.URL;
import lombok.NonNull;

public class XUrl {
    public static URL init(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            return new URL(url);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPath(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return XUrl.init(url).getPath();
    }

    public static String getHost(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return XUrl.init(url).getHost();
    }

    public static Integer getPort(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        Integer port = XUrl.init(url).getPort();
        if (port == -1) {
            String protocol = XUrl.getProtocol(url);
            if (protocol.equals("http")) {
                return 80;
            }
            if (protocol.equals("https")) {
                return 443;
            }
        }
        if (port > 65535) {
            throw new RuntimeException("Invalid port " + port);
        }
        return port;
    }

    public static String getProtocol(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return XUrl.init(url).getProtocol();
    }

    public static String getQuery(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return XUrl.init(url).getQuery();
    }
}

