/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.tests;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsServer;
import org.yamcs.client.ClientException;
import org.yamcs.client.ConnectionListener;
import org.yamcs.client.YamcsClient;
import org.yamcs.commanding.PreparedCommand;
import org.yamcs.mdb.Mdb;
import org.yamcs.mdb.MdbFactory;
import org.yamcs.parameter.ParameterValue;
import org.yamcs.protobuf.Pvalue;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.tctm.AbstractTcDataLink;
import org.yamcs.tctm.Link;
import org.yamcs.tctm.ParameterDataLink;
import org.yamcs.tctm.ParameterSink;
import org.yamcs.tctm.TmPacketDataLink;
import org.yamcs.tctm.TmSink;
import org.yamcs.tests.RefMdbPacketGenerator;
import org.yamcs.utils.FileUtils;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.utils.ValueUtility;

public abstract class AbstractIntegrationTest {
    protected final String yamcsHost = "localhost";
    protected final int yamcsPort = 9190;
    protected final String yamcsInstance = "instance1";
    ParameterProvider parameterProvider;
    MyConnectionListener connectionListener;
    protected YamcsClient yamcsClient;
    protected String adminUsername = "admin";
    protected char[] adminPassword = "rootpassword".toCharArray();
    RefMdbPacketGenerator packetGenerator;
    RefMdbPacketGenerator packetGenerator2;
    static YamcsServer yamcs;

    @BeforeAll
    public static void beforeClass() throws Exception {
        AbstractIntegrationTest.setupYamcs("IntegrationTest", true);
    }

    @BeforeEach
    public void before() throws ClientException {
        this.parameterProvider = ParameterProvider.instance[0];
        Assertions.assertNotNull((Object)this.parameterProvider);
        this.connectionListener = new MyConnectionListener();
        this.yamcsClient = YamcsClient.newBuilder((String)"localhost", (int)9190).withUserAgent("it-junit").build();
        this.yamcsClient.addConnectionListener((ConnectionListener)this.connectionListener);
        if (yamcs.getSecurityStore().isEnabled()) {
            this.yamcsClient.login(this.adminUsername, this.adminPassword);
        }
        this.yamcsClient.connectWebSocket();
        this.packetGenerator = PacketProvider.instance[0].mdbPacketGenerator;
        this.packetGenerator.setGenerationTime(Long.MIN_VALUE);
        this.packetGenerator2 = PacketProvider.instance[1].mdbPacketGenerator;
        this.packetGenerator2.setGenerationTime(Long.MIN_VALUE);
        yamcs.getInstance("instance1").getProcessor("realtime").getParameterProcessorManager().getAlarmServer().clearAll();
    }

    protected static void setupYamcs(String integrationTestConfig, boolean cleanExistingData) throws Exception {
        if (cleanExistingData) {
            Path dataDir = Path.of(System.getProperty("java.io.tmpdir"), "yamcs-IntegrationTest-data");
            FileUtils.deleteRecursivelyIfExists((Path)dataDir);
        }
        YConfiguration.setupTest((String)integrationTestConfig);
        yamcs = YamcsServer.getServer();
        yamcs.prepareStart();
        yamcs.start();
    }

    @AfterEach
    public void after() throws InterruptedException {
        this.yamcsClient.close();
        Assertions.assertTrue((boolean)this.connectionListener.onDisconnect.tryAcquire(5L, TimeUnit.SECONDS));
    }

    @AfterAll
    public static void shutDownYamcs() throws Exception {
        YamcsServer.getServer().shutDown();
    }

    void generatePkt13AndPps(String utcStart, int numPackets) {
        long t0 = TimeEncoding.parse((String)utcStart);
        for (int i = 0; i < numPackets; ++i) {
            this.packetGenerator.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator.generate_PKT1_1();
            this.packetGenerator.generate_PKT1_3();
            this.parameterProvider.setGenerationTime(t0 + (long)(1000 * i) + 10L);
            this.parameterProvider.generateParameters(i);
        }
    }

    void generatePkt1AndTm2Pkt1(String utcStart, int numPackets) {
        long t0 = TimeEncoding.parse((String)utcStart);
        for (int i = 0; i < numPackets; ++i) {
            this.packetGenerator.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator.generate_PKT1_1();
            this.packetGenerator2.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator2.generate_TM2_PKT1();
        }
    }

    void generatePkt3(String utcStart, int numPackets) {
        long t0 = TimeEncoding.parse((String)utcStart);
        for (int i = 0; i < numPackets; ++i) {
            this.packetGenerator.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator.generate_PKT3();
        }
    }

    void generatePkt7(String utcStart, int numPackets) {
        long t0 = TimeEncoding.parse((String)utcStart);
        for (int i = 0; i < numPackets; ++i) {
            this.packetGenerator.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator.generate_PKT7();
        }
    }

    void generatePkt8(String utcStart, int numPackets) {
        long t0 = TimeEncoding.parse((String)utcStart);
        for (int i = 0; i < numPackets; ++i) {
            this.packetGenerator.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator.generate_PKT8();
        }
    }

    void generatePkt13AndTm2Pkt1(String utcStart, int numPackets) {
        long t0 = TimeEncoding.parse((String)utcStart);
        for (int i = 0; i < numPackets; ++i) {
            this.packetGenerator.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator.generate_PKT13();
            this.packetGenerator2.setGenerationTime(t0 + (long)(1000 * i));
            this.packetGenerator2.generate_TM2_PKT1();
        }
    }

    public static class ParameterProvider
    implements ParameterDataLink {
        int seqNum = 0;
        ParameterSink ppListener;
        long generationTime;
        static volatile ParameterProvider[] instance = new ParameterProvider[2];
        Mdb xtcedb;
        YConfiguration config;
        String name;

        public void init(String yamcsInstance, String linkName, YConfiguration config) {
            ParameterProvider.instance[config.getInt((String)"num", (int)0)] = this;
            this.xtcedb = MdbFactory.getInstance((String)yamcsInstance);
            this.config = config;
            this.name = linkName;
        }

        public Link.Status getLinkStatus() {
            return Link.Status.OK;
        }

        public String getDetailedStatus() {
            return null;
        }

        public void enable() {
        }

        public void disable() {
        }

        public boolean isDisabled() {
            return false;
        }

        public long getDataInCount() {
            return 0L;
        }

        public long getDataOutCount() {
            return this.seqNum * 3;
        }

        public void resetCounters() {
        }

        public void setParameterSink(ParameterSink ppListener) {
            this.ppListener = ppListener;
        }

        public void setGenerationTime(long genTime) {
            this.generationTime = genTime;
        }

        void generateParameters(int x) {
            ParameterValue pv1 = new ParameterValue(this.xtcedb.getParameter("/REFMDB/SUBSYS1/processed_para_uint"));
            pv1.setUnsignedIntegerValue(x);
            pv1.setGenerationTime(this.generationTime);
            ParameterValue pv2 = new ParameterValue(this.xtcedb.getParameter("/REFMDB/SUBSYS1/processed_para_string"));
            pv2.setGenerationTime(this.generationTime);
            pv2.setStringValue("para" + x);
            ParameterValue pv5 = new ParameterValue(this.xtcedb.getParameter("/REFMDB/SUBSYS1/processed_para_enum_nc"));
            pv5.setGenerationTime(this.generationTime);
            pv5.setRawUnsignedInteger(1);
            this.ppListener.updateParameters(this.generationTime, "IntegrationTest", this.seqNum, Arrays.asList(pv1, pv2, pv5));
            Pvalue.ParameterValue pv3 = Pvalue.ParameterValue.newBuilder().setAcquisitionStatus(Pvalue.AcquisitionStatus.ACQUIRED).setId(Yamcs.NamedObjectId.newBuilder().setName("/REFMDB/SUBSYS1/processed_para_double")).setGenerationTime(TimeEncoding.toProtobufTimestamp((long)this.generationTime)).setEngValue(ValueUtility.getDoubleGbpValue((double)x)).build();
            this.ppListener.updateParams(this.generationTime, "IntegrationTest", this.seqNum, Arrays.asList(pv3));
            Pvalue.ParameterValue pv4 = Pvalue.ParameterValue.newBuilder().setAcquisitionStatus(Pvalue.AcquisitionStatus.ACQUIRED).setId(Yamcs.NamedObjectId.newBuilder().setName("/REFMDB/SUBSYS1/processed_para_uint")).setGenerationTime(TimeEncoding.toProtobufTimestamp((long)(this.generationTime + 20L))).setEngValue(ValueUtility.getUint32GbpValue((int)x)).build();
            this.ppListener.updateParams(this.generationTime + 20L, "IntegrationTest2", this.seqNum, Arrays.asList(pv4));
            ++this.seqNum;
        }

        public YConfiguration getConfig() {
            return this.config;
        }

        public String getName() {
            return this.name;
        }
    }

    static class MyConnectionListener
    implements ConnectionListener {
        Semaphore onConnect = new Semaphore(0);
        Semaphore onDisconnect = new Semaphore(0);

        MyConnectionListener() {
        }

        public void connecting() {
        }

        public void connected() {
            this.onConnect.release();
        }

        public void connectionFailed(Throwable cause) {
        }

        public void disconnected() {
            this.onDisconnect.release();
        }
    }

    public static class PacketProvider
    implements TmPacketDataLink {
        static volatile PacketProvider[] instance = new PacketProvider[4];
        RefMdbPacketGenerator mdbPacketGenerator = new RefMdbPacketGenerator();
        YConfiguration config;
        String name;

        public void init(String yamcsInstance, String linkName, YConfiguration config) {
            PacketProvider.instance[config.getInt((String)"num", (int)0)] = this;
            this.config = config;
            this.name = linkName;
        }

        public Link.Status getLinkStatus() {
            return Link.Status.OK;
        }

        public String getDetailedStatus() {
            return "OK";
        }

        public void enable() {
        }

        public void disable() {
        }

        public boolean isDisabled() {
            return false;
        }

        public long getDataInCount() {
            return 0L;
        }

        public long getDataOutCount() {
            return 0L;
        }

        public void resetCounters() {
        }

        public void setTmSink(TmSink tmSink) {
            this.mdbPacketGenerator.setTmSink(tmSink);
        }

        public YConfiguration getConfig() {
            return this.config;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class TcDataLink
    extends AbstractTcDataLink {
        static short seqNum = (short)5000;
        static volatile TcDataLink[] instance = new TcDataLink[4];
        List<PreparedCommand> commands = new ArrayList<PreparedCommand>();

        public void init(String yamcsInstance, String name, YConfiguration config) {
            super.init(yamcsInstance, name, config);
            TcDataLink.instance[config.getInt((String)"num", (int)0)] = this;
        }

        public boolean sendCommand(PreparedCommand preparedCommand) {
            if (preparedCommand.getCmdName().contains("ALG_VERIF_TC")) {
                this.commandHistoryPublisher.publish(preparedCommand.getCommandId(), "packetSeqNum", (int)seqNum);
            }
            this.commands.add(preparedCommand);
            return true;
        }

        protected Link.Status connectionStatus() {
            return Link.Status.OK;
        }

        protected void doStart() {
            this.notifyStarted();
        }

        protected void doStop() {
            this.notifyStopped();
        }
    }
}

