/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.tests;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingUtils {
    public static void configureLogging(Level level) {
        Logger logger = Logger.getLogger("org.yamcs");
        logger.setLevel(level);
        Handler ch = null;
        for (Handler h : Logger.getLogger("").getHandlers()) {
            if (!(h instanceof ConsoleHandler)) continue;
            ch = (ConsoleHandler)h;
            break;
        }
        if (ch == null) {
            ch = new ConsoleHandler();
            Logger.getLogger("").addHandler(ch);
        }
        ch.setLevel(level);
    }

    public static void enableTracing() {
        LoggingUtils.configureLogging(Level.ALL);
    }

    public static ArrayLogHandler startCapture(Class<?> clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        logger.setLevel(Level.ALL);
        ArrayLogHandler ah = new ArrayLogHandler();
        ah.setLevel(Level.ALL);
        logger.addHandler(ah);
        return ah;
    }

    public static void stopCapture(Class<?> clazz) {
        Logger logger = Logger.getLogger(clazz.getName());
        for (Handler h : logger.getHandlers()) {
            if (!(h instanceof ArrayLogHandler)) continue;
            logger.removeHandler(h);
        }
    }

    public static class ArrayLogHandler
    extends Handler {
        public final List<LogRecord> records = new ArrayList<LogRecord>();

        @Override
        public void publish(LogRecord record) {
            this.records.add(record);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }

        public boolean contains(String msg) {
            for (LogRecord lr : this.records) {
                if (!lr.getMessage().contains(msg)) continue;
                return true;
            }
            return false;
        }
    }
}

