/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.tests;

import com.google.common.util.concurrent.AbstractService;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.yamcs.ConfigurationException;
import org.yamcs.Processor;
import org.yamcs.TmPacket;
import org.yamcs.TmPacketProvider;
import org.yamcs.TmProcessor;
import org.yamcs.YConfiguration;
import org.yamcs.tctm.TmSink;
import org.yamcs.utils.GpsCcsdsTime;
import org.yamcs.utils.StringConverter;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.xtce.SequenceContainer;

public class RefMdbPacketGenerator
extends AbstractService
implements TmPacketProvider {
    TmProcessor tmProcessor;
    public final int headerLength = 16;
    public final int pkt1Length = 19;
    public final int pkt1_1Length = 75;
    public final int pkt1_2Length = 35;
    public final int pkt1_3Length = 119;
    public final int pkt1_4Length = 319;
    public final int pkt1_5Length = 69;
    public final int pkt1_6Length = 23;
    public final int pkt1_7Length = 25;
    public final int pkt1_8Length = 25;
    public final int pkt1_9Length = 20;
    public final int pkt1_10Length = 27;
    public final int pkt1_11Length = 23;
    public final int pkt4Length = 20;
    public final int pkt5Length = 16 + pFixedBinary1.length + pPrependedSizeBinary1.length;
    public final int pkt6Length = 21;
    public final int pkt2Length = 8;
    public final int pkt1_ListLength = 19;
    public final int pkt1_AndLength = 19;
    public final int pkt1_OrLength = 19;
    public final int pkt1_And_OrLength = 19;
    public final int contVerifCmdAck_Length = 23;
    public final int algVerifCmdAck_Length = 25;
    public volatile short pIntegerPara1_1 = (short)5;
    public volatile byte pIntegerPara1_1_1 = (byte)20;
    public volatile short pFloatPara1_1_2 = (short)1000;
    public volatile float pFloatPara1_1_3 = 2.0f;
    public volatile byte pEnumerationPara1_1_4 = 0;
    public volatile String pStringPara1_1_5 = "cucu";
    public volatile int pIntegerPara1_1_6 = 236;
    public volatile byte pIntegerPara1_1_7 = (byte)34;
    public volatile long pIntegerPara1_1_8 = 5084265585L;
    public volatile int pIntegerPara1_11_1 = -1342177282;
    public volatile long pIntegerPara1_11_1_unsigned_value = 0xAFFFFFFEL;
    public volatile float pFloatPara1_20_1 = 1.5707964f;
    public volatile int pTimePara_sec6_1 = 1;
    public volatile byte pTimePara_sec6_2 = (byte)-128;
    public volatile byte pLEIntegerPara1_2_1 = (byte)13;
    public volatile short pLEIntegerPara1_2_2 = (short)1300;
    public volatile int pLEIntegerPara1_2_3 = 130000;
    public volatile short pLEFloatPara1_2_1 = (short)300;
    public volatile float pLEFloatPara1_2_2 = 2.7182f;
    public static final String pFixedStringPara1_3_1 = "Ab";
    public static final String pFixedStringPara1_3_2 = "A";
    public static final String pTerminatedStringPara1_3_3 = "Abcdef";
    public static final String pTerminatedStringPara1_3_4 = "Abcdef";
    public static final String pPrependedSizeStringPara1_3_5 = "Abcdefghijklmnopqrstuvwxyz";
    public static final String pPrependedSizeStringPara1_3_6 = "Abcdef";
    public static final String pFixedStringPara1_3_7 = "Abcdefghijklmnop";
    public String pStringFloatFSPara1_4_1 = "1.34";
    public String pStringFloatTSCPara1_4_2 = "0.0000001";
    public static final String pStringFloatTSSCPara1_4_3 = "0.12";
    public static final String pStringFloatFSBPara1_4_4 = "1.34567890123456";
    public static final String pStringFloatPSPara1_4_5 = "1.345678";
    public static final String pStringIntFixedPara1_5_1 = "120";
    public String pStringIntTermPara1_5_2 = "12";
    public static final String pStringIntTermPara1_5_3 = "12045";
    public static final String pStringIntPrePara1_5_4 = "1204507";
    public static final String pStringIntStrPara1_5_5 = "123406789";
    public static final byte[] pFixedBinary1 = StringConverter.hexStringToArray((String)"0102030004050607");
    public static final byte[] pPrependedSizeBinary1 = StringConverter.hexStringToArray((String)"0220AC");
    public String pStringEnumPara1_12_1 = "1";
    public String pStringBooleanPara10_1 = "True";
    public static final int pIntegerPara2_1 = 123;
    public static final int pIntegerPara2_2 = 25;
    Map<Integer, AtomicInteger> seqCount = new HashMap<Integer, AtomicInteger>();
    private long generationTime = Long.MIN_VALUE;
    TmSink tmSink;
    SequenceContainer rootSc;
    public final int pkt7Length = 23;
    public byte paggr1_member1 = (byte)2;
    public short paggr1_member2 = (short)30;
    public float paggr1_member3 = 2.72f;
    public final int para_pkt8_count = 150;
    public final int pkt8Length = 1103;
    public final int pkt9Length = 22;

    public RefMdbPacketGenerator(String instance, String name, String spec) {
    }

    public RefMdbPacketGenerator() {
    }

    public void init(Processor proc, YConfiguration config, Object spec) {
        this.tmProcessor = proc.getTmProcessor();
        proc.setPacketProvider((TmPacketProvider)this);
        this.rootSc = proc.getMdb().getRootSequenceContainer();
        if (this.rootSc == null) {
            throw new ConfigurationException("Cannot find the root sequence container");
        }
    }

    public void setTmSink(TmSink tmSink) {
        this.tmSink = tmSink;
    }

    public byte[] generate_PKT1_1() {
        ByteBuffer bb = ByteBuffer.allocate(75);
        this.fill_PKT1_1(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_2() {
        ByteBuffer bb = ByteBuffer.allocate(35);
        this.fill_PKT1_2(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_3() {
        ByteBuffer bb = ByteBuffer.allocate(119);
        this.fill_PKT1_3(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT14() {
        ByteBuffer bb = ByteBuffer.allocate(319);
        this.fill_PKT1_4(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_5() {
        ByteBuffer bb = ByteBuffer.allocate(69);
        this.fill_PKT1_5(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_TM2_PKT1() {
        ByteBuffer bb = ByteBuffer.allocate(12);
        bb.putInt(1);
        bb.putInt(20);
        bb.putFloat(3.15f);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_6(int pIntegerPara16_1, int pIntegerPara16_2) {
        return this.generate_PKT1_6(pIntegerPara16_1, pIntegerPara16_2, TimeEncoding.getWallclockTime(), TimeEncoding.getWallclockTime());
    }

    public byte[] generate_PKT1_6(int pIntegerPara16_1, int pIntegerPara16_2, long rectime, long gentime) {
        ByteBuffer bb = ByteBuffer.allocate(23);
        this.fill_PKT1_6(bb, pIntegerPara16_1, pIntegerPara16_2);
        this.sendToTmProcessor(bb, rectime, gentime);
        return bb.array();
    }

    public byte[] generate_PKT1_7() {
        ByteBuffer bb = ByteBuffer.allocate(25);
        this.fill_PKT1_7(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_8(int pIntegerPara18_1, int pIntegerPara18_2) {
        ByteBuffer bb = ByteBuffer.allocate(25);
        this.fill_PKT1_8(bb, pIntegerPara18_1, pIntegerPara18_2);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_9() {
        ByteBuffer bb = ByteBuffer.allocate(20);
        this.fill_PKT1_9(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_10(int pIntegerPara1_10_1, int pEnumerationPara1_10_2, float pFloatPara1_10_3) {
        ByteBuffer bb = ByteBuffer.allocate(27);
        this.fill_PKT1_10(bb, pIntegerPara1_10_1, pEnumerationPara1_10_2, pFloatPara1_10_3);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_11() {
        ByteBuffer bb = ByteBuffer.allocate(23);
        this.fill_PKT1(bb, 11);
        bb.position(19);
        bb.putInt(this.pIntegerPara1_11_1);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT1_12() {
        ByteBuffer bb = ByteBuffer.allocate(19 + this.pStringEnumPara1_12_1.length() + 1);
        this.fill_PKT1_12(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT4() {
        ByteBuffer bb = ByteBuffer.allocate(20);
        this.fill_PKT4(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT5() {
        ByteBuffer bb = ByteBuffer.allocate(this.pkt5Length);
        this.fill_PKT5(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    private void fill_PKT5(ByteBuffer bb) {
        this.fill_CcsdsHeader(bb, 995, 5);
        bb.position(16);
        bb.put(pFixedBinary1);
        bb.put(pPrependedSizeBinary1);
    }

    public byte[] generate_PKT6() {
        ByteBuffer bb = ByteBuffer.allocate(21);
        this.fill_PKT6(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT2() {
        ByteBuffer bb = ByteBuffer.allocate(8);
        this.fill_PKT2(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public ByteBuffer generate_PKT1_List() {
        ByteBuffer bb = ByteBuffer.allocate(19);
        this.fill_PKT1(bb, 1, 13, (short)2);
        this.sendToTmProcessor(bb);
        return bb;
    }

    public ByteBuffer generate_PKT1_AND() {
        ByteBuffer bb = ByteBuffer.allocate(19);
        this.fill_PKT1(bb, 2, 13, (short)3);
        this.sendToTmProcessor(bb);
        return bb;
    }

    public ByteBuffer generate_PKT1_OR_1() {
        ByteBuffer bb = ByteBuffer.allocate(19);
        this.fill_PKT1(bb, 1, 14, (short)2);
        this.sendToTmProcessor(bb);
        return bb;
    }

    public ByteBuffer generate_PKT1_AND_OR_1() {
        ByteBuffer bb = ByteBuffer.allocate(19);
        this.fill_PKT1(bb, 1, 15, (short)1);
        this.sendToTmProcessor(bb);
        return bb;
    }

    public ByteBuffer generate_PKT1_AND_OR_2() {
        ByteBuffer bb = ByteBuffer.allocate(19);
        this.fill_PKT1(bb, 14, 0, (short)15);
        this.sendToTmProcessor(bb);
        return bb;
    }

    public byte[] generate_PKT1(int integerPara1_1, int packetType, short integerPara1_2) {
        ByteBuffer bb = ByteBuffer.allocate(19);
        this.fill_PKT1(bb, integerPara1_1, packetType, integerPara1_2);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public ByteBuffer generateContVerifCmdAck(short cmdId, byte stage, int result) {
        ByteBuffer bb = ByteBuffer.allocate(23);
        this.fill_CcsdsHeader(bb, 101, 1000);
        bb.position(16);
        bb.putShort(cmdId);
        bb.put(stage);
        bb.putInt(result);
        this.sendToTmProcessor(bb);
        return bb;
    }

    public ByteBuffer generateAlgVerifCmdAck(short cmdId, short packetSeq, byte stage, int result) {
        ByteBuffer bb = ByteBuffer.allocate(25);
        this.fill_CcsdsHeader(bb, 101, 2000);
        bb.position(16);
        bb.putShort(cmdId);
        bb.putShort(packetSeq);
        bb.put(stage);
        bb.putInt(result);
        this.sendToTmProcessor(bb);
        return bb;
    }

    public byte[] generate_PKT3() {
        int pktLength = 44;
        ByteBuffer bb = ByteBuffer.allocate(pktLength);
        this.fill_PKT3(bb);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public void setGenerationTime(long genTime) {
        this.generationTime = genTime;
    }

    private void fill_CcsdsHeader(ByteBuffer bb, int apid, int packetId) {
        short xs = (short)(0x1800 | apid);
        bb.putShort(0, xs);
        AtomicInteger a = this.seqCount.computeIfAbsent(apid, r -> new AtomicInteger(0));
        xs = (short)(0xC000 | a.getAndIncrement());
        bb.putShort(2, xs);
        bb.putShort(4, (short)(bb.capacity() - 7));
        GpsCcsdsTime t = TimeEncoding.toGpsTime((long)this.generationTime);
        bb.putInt(6, t.coarseTime);
        bb.put(10, t.fineTime);
        bb.putInt(12, packetId);
        bb.position(16);
    }

    private void fill_PKT1(ByteBuffer bb, int packetType) {
        this.fill_CcsdsHeader(bb, 995, 318813007);
        bb.put(16, (byte)((this.pIntegerPara1_1 << 4) + packetType));
    }

    private void fill_PKT1(ByteBuffer bb, int integerPara1_1, int packetType, short integerPara1_2) {
        this.fill_CcsdsHeader(bb, 995, 318813007);
        bb.put(16, (byte)((integerPara1_1 << 4) + packetType));
        bb.putShort(17, integerPara1_2);
    }

    private void fill_PKT1_1(ByteBuffer bb) {
        this.fill_PKT1(bb, 1);
        int offset = 19;
        bb.position(offset);
        bb.put(this.pIntegerPara1_1_1);
        bb.putShort(this.pFloatPara1_1_2);
        bb.putFloat(this.pFloatPara1_1_3);
        bb.put(this.pEnumerationPara1_1_4);
        bb.put((byte)(this.pIntegerPara1_1_6 >> 16));
        bb.putShort((short)(this.pIntegerPara1_1_6 & 0xFFFF));
        bb.put(this.pIntegerPara1_1_7);
        bb.putShort((short)(this.pIntegerPara1_1_8 >> 32));
        bb.putInt((int)this.pIntegerPara1_1_8 & 0xFFFFFFFF);
        byte[] b = new byte[10];
        System.arraycopy(this.pStringPara1_1_5.getBytes(), 0, b, 0, this.pStringPara1_1_5.getBytes().length);
        bb.put(b);
    }

    private void fill_PKT1_2(ByteBuffer bb) {
        this.fill_PKT1(bb, 2);
        bb.position(19);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        bb.put(this.pLEIntegerPara1_2_1);
        bb.putShort(this.pLEIntegerPara1_2_2);
        bb.putInt(this.pLEIntegerPara1_2_3);
        bb.putShort(this.pLEFloatPara1_2_1);
        bb.putFloat(this.pLEFloatPara1_2_2);
    }

    private void fill_PKT1_3(ByteBuffer bb) {
        this.fill_PKT1(bb, 3);
        int offset = 19;
        bb.position(offset);
        this.putFixedStringParam(bb, pFixedStringPara1_3_1, 16);
        this.putFixedStringParam(bb, pFixedStringPara1_3_2, 8);
        this.putTerminatedStringParam(bb, "Abcdef", (byte)0);
        this.putTerminatedStringParam(bb, "Abcdef", (byte)44);
        this.putPrependedSizeStringParam(bb, pPrependedSizeStringPara1_3_5, 16);
        this.putPrependedSizeStringParam(bb, "Abcdef", 8);
        this.putFixedStringParam(bb, pFixedStringPara1_3_7, 128);
    }

    private void fill_PKT1_4(ByteBuffer bb) {
        this.fill_PKT1(bb, 4);
        int offset = 19;
        bb.position(offset);
        this.putFixedStringParam(bb, this.pStringFloatFSPara1_4_1, 32);
        this.putTerminatedStringParam(bb, this.pStringFloatTSCPara1_4_2, (byte)44);
        this.putTerminatedStringParam(bb, pStringFloatTSSCPara1_4_3, (byte)59);
        this.putTerminatedStringParam(bb, pStringFloatTSSCPara1_4_3, (byte)59);
        this.putPrependedSizeStringParam(bb, pStringFloatPSPara1_4_5, 8);
        this.putFixedStringParam(bb, pStringFloatFSBPara1_4_4, 128);
    }

    private void fill_PKT1_5(ByteBuffer bb) {
        this.fill_PKT1(bb, 5);
        int offset = 19;
        bb.position(offset);
        this.putFixedStringParam(bb, pStringIntFixedPara1_5_1, 24);
        this.putTerminatedStringParam(bb, this.pStringIntTermPara1_5_2, (byte)44);
        this.putTerminatedStringParam(bb, pStringIntTermPara1_5_3, (byte)59);
        this.putPrependedSizeStringParam(bb, pStringIntPrePara1_5_4, 16);
        this.putTerminatedStringParam(bb, pStringIntStrPara1_5_5, (byte)0);
    }

    private void fill_PKT4(ByteBuffer bb) {
        this.fill_CcsdsHeader(bb, 995, 4);
        bb.position(16);
        bb.putFloat(this.pFloatPara1_20_1);
    }

    private void fill_PKT6(ByteBuffer bb) {
        this.fill_CcsdsHeader(bb, 995, 6);
        bb.position(16);
        bb.putInt(this.pTimePara_sec6_1);
        bb.put(this.pTimePara_sec6_2);
    }

    private void fill_PKT2(ByteBuffer bb) {
        bb.position(4);
        bb.putShort((short)123);
        bb.putShort((short)25);
    }

    private void fill_PKT1_6(ByteBuffer bb, int pIntegerPara16_1, int pIntegerPara16_2) {
        this.fill_PKT1(bb, 6);
        int offset = 19;
        bb.position(offset);
        bb.putShort((short)(pIntegerPara16_1 & 0xFFFF));
        bb.putShort((short)(pIntegerPara16_2 & 0xFFFF));
    }

    private void fill_PKT1_7(ByteBuffer bb) {
        this.fill_PKT1(bb, 7);
        int offset = 19;
        bb.position(offset);
        bb.put(StringConverter.hexStringToArray((String)"BA50"));
        bb.put(StringConverter.hexStringToArray((String)"1846"));
        bb.put(StringConverter.hexStringToArray((String)"1879"));
    }

    private void fill_PKT1_8(ByteBuffer bb, int pIntegerPara18_1, int pIntegerPara18_2) {
        this.fill_PKT1(bb, 8);
        int offset = 19;
        bb.position(offset);
        bb.putShort((short)(pIntegerPara18_1 & 0xFFFF));
        bb.putInt(pIntegerPara18_2);
    }

    private void fill_PKT1_9(ByteBuffer bb) {
        this.fill_PKT1(bb, 9);
        int offset = 19;
        bb.position(offset);
        bb.put((byte)-95);
    }

    private void fill_PKT1_10(ByteBuffer bb, int pIntegerPara1_10_1, int pEnumerationPara1_10_2, float pFloatPara1_10_3) {
        this.fill_PKT1(bb, 10);
        int offset = 19;
        bb.position(offset);
        bb.putShort((short)pIntegerPara1_10_1);
        bb.put((byte)pEnumerationPara1_10_2);
        bb.put((byte)0);
        bb.putFloat(pFloatPara1_10_3);
    }

    private void fill_PKT1_12(ByteBuffer bb) {
        this.fill_PKT1(bb, 12);
        int offset = 19;
        bb.position(offset);
        this.putTerminatedStringParam(bb, this.pStringEnumPara1_12_1, (byte)59);
    }

    private void fill_PKT3(ByteBuffer bb) {
        this.fill_CcsdsHeader(bb, 995, 318813009);
        bb.position(16);
        bb.put((byte)32);
        bb.put((byte)0);
        bb.put((byte)3);
        bb.put((byte)0);
        bb.put((byte)4);
        bb.put((byte)5);
        bb.put((byte)6);
        bb.put((byte)61);
        bb.put((byte)7);
        bb.put((byte)8);
        bb.put((byte)9);
        bb.put((byte)10);
        bb.put((byte)11);
        bb.put((byte)12);
        bb.put((byte)13);
        bb.put((byte)14);
        bb.putShort((short)15);
        bb.putFloat(15.5f);
        bb.putShort((short)16);
        bb.putFloat(16.5f);
    }

    public byte[] generate_PKT7() {
        ByteBuffer bb = ByteBuffer.allocate(23);
        this.fill_CcsdsHeader(bb, 995, 7);
        bb.put(this.paggr1_member1);
        bb.putShort(this.paggr1_member2);
        bb.putFloat(this.paggr1_member3);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT8() {
        int i;
        ByteBuffer bb = ByteBuffer.allocate(1103);
        this.fill_CcsdsHeader(bb, 995, 8);
        bb.position(16);
        bb.put((byte)-106);
        for (i = 0; i < 150; ++i) {
            bb.put((byte)i);
            bb.putShort((short)(i * 2));
            bb.putFloat((float)i / 2.0f);
        }
        for (i = 0; i < 9; ++i) {
            bb.putFloat(i);
        }
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT9(short obId, int v) {
        ByteBuffer bb = ByteBuffer.allocate(1103);
        this.fill_CcsdsHeader(bb, 995, 9);
        bb.putShort(obId);
        bb.putInt(v);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT10() {
        int pkt10Length = 16 + this.pStringBooleanPara10_1.length() + 1;
        ByteBuffer bb = ByteBuffer.allocate(pkt10Length);
        this.fill_CcsdsHeader(bb, 995, 10);
        this.putTerminatedStringParam(bb, this.pStringBooleanPara10_1, (byte)0);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT11(String s, byte v) {
        int strLength = 20;
        int pkt11Length = 16 + strLength + 1;
        ByteBuffer bb = ByteBuffer.allocate(pkt11Length);
        this.fill_CcsdsHeader(bb, 995, 11);
        byte[] sb = s.getBytes();
        bb.put(sb, 0, Math.min(20, sb.length));
        bb.put(16 + strLength, v);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT12() {
        int pkt12Length = 116;
        ByteBuffer bb = ByteBuffer.allocate(pkt12Length);
        this.fill_CcsdsHeader(bb, 995, 12);
        bb.putInt(-1);
        bb.putInt(-252579085);
        bb.putLong(-2L);
        bb.putLong(-1084818905618843913L);
        bb.putDouble(3.14);
        bb.putFloat(2.72f);
        bb.put((byte)1);
        bb.put((byte)1);
        bb.put("bla".getBytes());
        bb.put((byte)0);
        bb.put((byte)5);
        bb.put(StringConverter.hexStringToArray((String)"0102030405"));
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    public byte[] generate_PKT13() {
        int pkt13Length = 20;
        ByteBuffer bb = ByteBuffer.allocate(pkt13Length);
        this.fill_CcsdsHeader(bb, 995, 13);
        bb.putFloat(16, 100.1f);
        this.sendToTmProcessor(bb);
        return bb.array();
    }

    private void putFixedStringParam(ByteBuffer bb, String value, int bits) {
        int baSize = bits / 8;
        if (bits == -1) {
            baSize = value.getBytes().length;
        }
        byte[] ba = new byte[baSize];
        System.arraycopy(value.getBytes(), 0, ba, 0, value.getBytes().length);
        bb.put(ba);
    }

    private void putTerminatedStringParam(ByteBuffer bb, String value, byte terminator) {
        byte[] ba = new byte[value.getBytes().length + 1];
        System.arraycopy(value.getBytes(), 0, ba, 0, value.getBytes().length);
        ba[ba.length - 1] = terminator;
        bb.put(ba);
    }

    private void putPrependedSizeStringParam(ByteBuffer bb, String value, int tagSizeInBits) {
        if (tagSizeInBits <= 8) {
            bb.put((byte)value.getBytes().length);
        } else {
            bb.putShort((short)value.getBytes().length);
        }
        byte[] ba = new byte[value.getBytes().length];
        System.arraycopy(value.getBytes(), 0, ba, 0, value.getBytes().length);
        bb.put(ba);
    }

    private void sendToTmProcessor(ByteBuffer bb) {
        long gentime = this.generationTime;
        if (gentime == Long.MIN_VALUE) {
            gentime = TimeEncoding.getWallclockTime();
        }
        this.sendToTmProcessor(bb, TimeEncoding.getWallclockTime(), gentime);
    }

    private void sendToTmProcessor(ByteBuffer bb, long rectime, long gentime) {
        if (this.tmProcessor != null) {
            this.tmProcessor.processPacket(new TmPacket(rectime, gentime, bb.getInt(0), bb.array()), this.rootSc);
        }
        if (this.tmSink != null) {
            this.tmSink.processPacket(new TmPacket(rectime, gentime, bb.getInt(0), bb.array()));
        }
    }

    public long getGenerationTime() {
        return this.generationTime;
    }

    public void simulateGap(int apid) {
        AtomicInteger a = this.seqCount.computeIfAbsent(apid, r -> new AtomicInteger(0));
        a.incrementAndGet();
    }

    public boolean isArchiveReplay() {
        return false;
    }

    protected void doStart() {
        this.notifyStarted();
    }

    protected void doStop() {
        this.notifyStopped();
    }
}

