/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.tests;

import com.google.protobuf.Message;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.yamcs.client.Subscription;

public class MessageCaptor<T extends Message> {
    private static final int TIMELY_WAIT_TIME = 3000;
    private BlockingQueue<T> queue = new LinkedBlockingQueue<T>();

    private MessageCaptor(Subscription<?, T> subscription) {
        subscription.addMessageListener(this.queue::add);
    }

    public T poll() {
        return (T)((Message)this.queue.poll());
    }

    public T poll(long timeout) throws InterruptedException {
        return (T)((Message)this.queue.poll(timeout, TimeUnit.MILLISECONDS));
    }

    public T expectTimely() throws InterruptedException, TimeoutException {
        Message message = (Message)this.queue.poll(3000L, TimeUnit.MILLISECONDS);
        if (message == null) {
            throw new TimeoutException();
        }
        return (T)message;
    }

    public void clear() {
        this.queue.clear();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int getPendingCount() {
        return this.queue.size();
    }

    public static <T extends Message> MessageCaptor<T> of(Subscription<?, T> subscription) {
        return new MessageCaptor<T>(subscription);
    }
}

