/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.tests;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.yamcs.client.ParameterSubscription;
import org.yamcs.protobuf.Pvalue;
import org.yamcs.protobuf.Yamcs;

public class ParameterCaptor {
    private static final int TIMELY_WAIT_TIME = 3000;
    private BlockingQueue<Yamcs.NamedObjectId> invalidIdentifierQueue = new LinkedBlockingQueue<Yamcs.NamedObjectId>();
    private BlockingQueue<List<Pvalue.ParameterValue>> deliveryQueue = new LinkedBlockingQueue<List<Pvalue.ParameterValue>>();

    private ParameterCaptor(ParameterSubscription subscription) {
        subscription.addListener(new ParameterSubscription.Listener(){

            public void onData(List<Pvalue.ParameterValue> values) {
                ParameterCaptor.this.deliveryQueue.add(values);
            }

            public void onInvalidIdentification(Yamcs.NamedObjectId id) {
                ParameterCaptor.this.invalidIdentifierQueue.add(id);
            }
        });
    }

    public List<Pvalue.ParameterValue> poll() {
        return (List)this.deliveryQueue.poll();
    }

    public List<Pvalue.ParameterValue> poll(long timeout) throws InterruptedException {
        return this.deliveryQueue.poll(timeout, TimeUnit.MILLISECONDS);
    }

    public List<Pvalue.ParameterValue> expectTimely() throws InterruptedException, TimeoutException {
        List<Pvalue.ParameterValue> values = this.deliveryQueue.poll(3000L, TimeUnit.MILLISECONDS);
        if (values == null) {
            throw new TimeoutException();
        }
        return values;
    }

    public void assertSilence() throws InterruptedException {
        List<Pvalue.ParameterValue> values = this.deliveryQueue.poll(3000L, TimeUnit.MILLISECONDS);
        Assertions.assertNull(values, (String)"Received a message while a moment of silence was expected");
    }

    public void clear() {
        this.deliveryQueue.clear();
        this.invalidIdentifierQueue.clear();
    }

    public boolean isEmpty() {
        return this.deliveryQueue.isEmpty();
    }

    public int getPendingCount() {
        return this.deliveryQueue.size();
    }

    public Yamcs.NamedObjectId expectTimelyInvalidIdentifier() throws InterruptedException, TimeoutException {
        Yamcs.NamedObjectId id = this.invalidIdentifierQueue.poll(3000L, TimeUnit.MILLISECONDS);
        if (id == null) {
            throw new TimeoutException();
        }
        return id;
    }

    public static ParameterCaptor of(ParameterSubscription subscription) {
        return new ParameterCaptor(subscription);
    }
}

