/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.yamcs.YConfiguration;
import org.yamcs.archive.TagDb;
import org.yamcs.archive.TagReceiver;
import org.yamcs.cli.ArchiveCli;
import org.yamcs.cli.Command;
import org.yamcs.oldparchive.ParameterArchive;
import org.yamcs.oldparchive.ParameterGroupIdDb;
import org.yamcs.parameterarchive.ParameterArchiveV2;
import org.yamcs.parameterarchive.ParameterIdDb;
import org.yamcs.parameterarchive.SegmentKey;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.utils.SortedIntArray;
import org.yamcs.utils.TimeInterval;
import org.yamcs.yarch.AbstractStream;
import org.yamcs.yarch.ColumnDefinition;
import org.yamcs.yarch.DataType;
import org.yamcs.yarch.Partition;
import org.yamcs.yarch.Stream;
import org.yamcs.yarch.StreamSubscriber;
import org.yamcs.yarch.TableDefinition;
import org.yamcs.yarch.TableWriter;
import org.yamcs.yarch.Tuple;
import org.yamcs.yarch.TupleDefinition;
import org.yamcs.yarch.YarchDatabase;
import org.yamcs.yarch.YarchDatabaseInstance;
import org.yamcs.yarch.YarchException;
import org.yamcs.yarch.oldrocksdb.HistogramRebuilder;
import org.yamcs.yarch.oldrocksdb.RdbPartition;
import org.yamcs.yarch.oldrocksdb.RdbPartitionManager;
import org.yamcs.yarch.oldrocksdb.RdbStorageEngine;
import org.yamcs.yarch.rocksdb.Tablespace;

@Parameters(commandDescription="Upgrade tables to latest format. It can only be done when the Yamcs server is not running.")
public class ArchiveUpgradeCommand
extends Command {
    @Parameter(names={"--instance"}, description="yamcs instance", required=true)
    String yamcsInstance;
    FileWriter filesToRemove;
    int filesToRemoveCount;

    public ArchiveUpgradeCommand(ArchiveCli archiveCli) {
        super("upgrade", archiveCli);
    }

    @Override
    public void execute() throws Exception {
        RocksDB.loadLibrary();
        RdbStorageEngine.getInstance().setIgnoreVersionIncompatibility(true);
        if (this.yamcsInstance != null) {
            if (!YarchDatabase.instanceExistsOnDisk((String)this.yamcsInstance)) {
                throw new ParameterException("Archive instance '" + this.yamcsInstance + "' does not exist");
            }
            this.upgradeInstance(this.yamcsInstance);
        } else {
            List instances = YConfiguration.getConfiguration((String)"yamcs").getList("instances");
            for (String instance : instances) {
                this.upgradeInstance(instance);
            }
        }
    }

    private void upgradeInstance(String instance) throws Exception {
        String f = "/tmp/" + instance + "-cleanup.sh";
        this.filesToRemove = new FileWriter(f);
        this.upgradeYarchTables(instance);
        this.upgradeParameterArchive(instance);
        this.upgradeTagsDb(instance);
        console.println("\n*************************************\n");
        console.println("Instance " + instance + " has been upgraded");
        if (this.filesToRemoveCount > 0) {
            this.filesToRemove.write("find '" + YarchDatabase.getInstance((String)instance).getRoot() + "' -type d -empty -delete\n");
            console.println("A number of files are not required anymore after upgrade and a script to remove them has been created in " + f);
            console.println("Please execute the script after making sure that eveything is ok");
        }
        this.filesToRemove.close();
    }

    private void upgradeYarchTables(String instance) throws Exception {
        YarchDatabaseInstance ydb = YarchDatabase.getInstance((String)instance);
        for (TableDefinition tblDef : ydb.getTableDefinitions()) {
            if (tblDef.getFormatVersion() == 0) {
                this.upgrade0_1(ydb, tblDef);
                tblDef.changeFormatDefinition(1);
            }
            if (tblDef.getFormatVersion() == 1) {
                this.upgrade1_2(ydb, tblDef);
                tblDef.changeFormatDefinition(2);
            }
            if (!tblDef.getStorageEngineName().equals("rocksdb")) continue;
            this.upgradeRocksDBTable(ydb, tblDef);
            tblDef.changeStorageEngineName("rocksdb2");
        }
    }

    private void upgrade0_1(YarchDatabaseInstance ydb, TableDefinition tblDef) throws Exception {
        console.println("upgrading table " + ydb.getName() + "/" + tblDef.getName() + " from version 0 to version 1");
        if ("pp".equals(tblDef.getName())) {
            this.changePpGroup(ydb, tblDef);
        }
        if (tblDef.hasHistogram()) {
            this.rebuildHistogram(ydb, tblDef);
        }
    }

    private void upgrade1_2(YarchDatabaseInstance ydb, TableDefinition tblDef) {
        console.println("upgrading table " + ydb.getName() + "/" + tblDef.getName() + " from version 1 to version 2");
        if ("pp".equals(tblDef.getName())) {
            ArchiveUpgradeCommand.changeParaValueType(tblDef);
        }
    }

    static void changeParaValueType(TableDefinition tblDef) {
        TupleDefinition valueDef = tblDef.getValueDefinition();
        List l = valueDef.getColumnDefinitions();
        for (int i = 0; i < l.size(); ++i) {
            ColumnDefinition cd = (ColumnDefinition)l.get(i);
            if (!"org.yamcs.protobuf.Pvalue$ParameterValue".equals(cd.getType().name())) continue;
            ColumnDefinition cd1 = new ColumnDefinition(cd.getName(), DataType.PARAMETER_VALUE);
            l.set(i, cd1);
        }
    }

    private void changePpGroup(YarchDatabaseInstance ydb, TableDefinition tblDef) {
        if (tblDef.getColumnDefinition("ppgroup") == null) {
            this.log.info("Table {}/{} has no ppgroup column", (Object)ydb.getName(), (Object)tblDef.getName());
            return;
        }
        this.log.info("Renaming ppgroup -> group column in table {}/{}", (Object)ydb.getName(), (Object)tblDef.getName());
        tblDef.renameColumn("ppgroup", "group");
    }

    private void rebuildHistogram(YarchDatabaseInstance ydb, TableDefinition tblDef) throws InterruptedException, ExecutionException, YarchException {
        HistogramRebuilder hrb = new HistogramRebuilder(ydb, tblDef.getName());
        hrb.rebuild(new TimeInterval()).get();
    }

    private void upgradeRocksDBTable(YarchDatabaseInstance ydb, final TableDefinition tblDef) throws Exception {
        console.println("upgrading table " + ydb.getName() + "/" + tblDef.getName() + "to new RocksDB storage engine");
        org.yamcs.yarch.rocksdb.RdbStorageEngine newRse = org.yamcs.yarch.rocksdb.RdbStorageEngine.getInstance();
        newRse.createTable(ydb, tblDef);
        RdbStorageEngine oldRse = RdbStorageEngine.getInstance();
        AbstractStream stream = oldRse.newTableReaderStream(ydb, tblDef, true, false);
        TableWriter tw = newRse.newTableWriter(ydb, tblDef, TableWriter.InsertMode.LOAD);
        stream.addSubscriber((StreamSubscriber)tw);
        final Semaphore semaphore = new Semaphore(0);
        final AtomicInteger count = new AtomicInteger();
        stream.addSubscriber(new StreamSubscriber(){
            int c = 0;

            public void streamClosed(Stream stream) {
                count.set(this.c);
                semaphore.release();
            }

            public void onTuple(Stream stream, Tuple tuple) {
                ++this.c;
                if (this.c % 100000 == 0) {
                    Command.console.println(tblDef.getName() + " saved " + this.c + " tuples");
                }
            }
        });
        AtomicReference exception = new AtomicReference();
        stream.exceptionHandler((s, tuple, t1) -> {
            console.print("Error saving tuple " + tuple);
            exception.set(t1);
        });
        stream.start();
        semaphore.acquire();
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw new Exception(t);
        }
        console.println(ydb.getName() + "/" + tblDef.getName() + " upgrade finished: converted " + count + " tuples");
        RdbPartitionManager pm = oldRse.getPartitionManager(tblDef);
        for (Partition p : pm.getPartitions()) {
            RdbPartition rp = (RdbPartition)p;
            this.filesToRemove.write("rm -rf '" + ydb.getRoot() + "/" + rp.getDir() + "'\n");
            ++this.filesToRemoveCount;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void upgradeParameterArchive(String instance) throws Exception {
        void var15_18;
        YarchDatabaseInstance ydb = YarchDatabase.getInstance((String)instance);
        File f = new File(ydb.getRoot() + "/ParameterArchive");
        if (!f.exists()) {
            return;
        }
        console.println(instance + ": upgrading parameter archive");
        ParameterArchiveV2 newparch = new ParameterArchiveV2(instance);
        ParameterArchive oldparch = new ParameterArchive(instance);
        org.yamcs.yarch.rocksdb.RdbStorageEngine rse = org.yamcs.yarch.rocksdb.RdbStorageEngine.getInstance();
        Tablespace tablespace = rse.getTablespace(ydb.getTablespaceName());
        org.yamcs.oldparchive.ParameterIdDb oldParaIdDb = oldparch.getParameterIdDb();
        ParameterIdDb newParaIdDb = newparch.getParameterIdDb();
        console.println("creating parameter ids in the tablespace " + tablespace.getName());
        HashMap<Integer, Integer> oldToNewParaId = new HashMap<Integer, Integer>();
        oldToNewParaId.put(0, newParaIdDb.getTimeParameterId());
        for (Map.Entry e : oldParaIdDb.getMap().entrySet()) {
            String fqn = (String)e.getKey();
            for (Map.Entry entry : ((Map)e.getValue()).entrySet()) {
                int n = (Integer)entry.getKey();
                int oldParamId = (Integer)entry.getValue();
                int newParamId = newParaIdDb.createAndGet(fqn, org.yamcs.oldparchive.ParameterIdDb.getEngType((int)n), org.yamcs.oldparchive.ParameterIdDb.getRawType((int)n));
                oldToNewParaId.put(oldParamId, newParamId);
            }
        }
        console.println("creating parameter groups in the tablespace " + tablespace.getName());
        ParameterGroupIdDb oldParaGroupIdDb = oldparch.getParameterGroupIdDb();
        org.yamcs.parameterarchive.ParameterGroupIdDb newParaGroupIdDb = newparch.getParameterGroupIdDb();
        Map oldGroups = oldParaGroupIdDb.getMap();
        HashMap oldToNewGroupId = new HashMap();
        for (Map.Entry entry : oldGroups.entrySet()) {
            SortedIntArray s = new SortedIntArray();
            ((SortedIntArray)entry.getKey()).forEach(x -> s.insert(((Integer)oldToNewParaId.get(x)).intValue()));
            int newGroupId = newParaGroupIdDb.createAndGet(s);
            oldToNewGroupId.put(entry.getValue(), newGroupId);
        }
        console.println(instance + ": migrating the ParameterArchive data");
        boolean bl = false;
        for (ParameterArchive.Partition oldpart : oldparch.getPartitions()) {
            RocksIterator it = oldparch.getIterator(oldpart);
            Throwable throwable = null;
            try {
                it.seekToFirst();
                while (it.isValid()) {
                    org.yamcs.oldparchive.SegmentKey oldkey = org.yamcs.oldparchive.SegmentKey.decode((byte[])it.key());
                    int newparaid = (Integer)oldToNewParaId.get(oldkey.getParameterId());
                    int newgroupid = (Integer)oldToNewGroupId.get(oldkey.getParameterGroupId());
                    SegmentKey newkey = new SegmentKey(newparaid, newgroupid, oldkey.getSegmentStart(), oldkey.getType());
                    byte[] val = it.value();
                    ParameterArchiveV2.Partition newpart = newparch.createAndGetPartition(oldkey.getSegmentStart());
                    tablespace.getRdb(newpart.getPartitionDir(), false).put(newkey.encode(), val);
                    if (++var15_18 % 1000 == false) {
                        console.println(instance + ": ParameterArchive migrated " + (int)var15_18 + " segments");
                    }
                    it.next();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (it == null) continue;
                if (throwable != null) {
                    try {
                        it.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                it.close();
            }
        }
        console.println(instance + ": ParameterArchive migration finished, migrated " + (int)var15_18 + " segments");
        File file = new File(ydb.getRoot() + "/ParameterArchive.old");
        if (!f.renameTo(file)) {
            throw new IOException("Could not rename " + f + " to " + file);
        }
        ++this.filesToRemoveCount;
        this.filesToRemove.write("rm -rf " + file.getAbsolutePath() + "\n");
    }

    private void upgradeTagsDb(String instance) throws Exception {
        console.println(instance + ": Migrating TagDB");
        YarchDatabaseInstance ydb = YarchDatabase.getInstance((String)instance);
        File f = new File(ydb.getRoot() + "/tags");
        if (!f.exists()) {
            return;
        }
        org.yamcs.yarch.rocksdb.RdbStorageEngine newRse = org.yamcs.yarch.rocksdb.RdbStorageEngine.getInstance();
        RdbStorageEngine oldRse = RdbStorageEngine.getInstance();
        TagDb oldTagDb = oldRse.getTagDb(ydb);
        final TagDb newTagDb = newRse.getTagDb(ydb);
        final Semaphore s = new Semaphore(0);
        final AtomicInteger count = new AtomicInteger();
        oldTagDb.getTags(new TimeInterval(), new TagReceiver(){

            public void onTag(Yamcs.ArchiveTag tag) {
                try {
                    newTagDb.insertTag(tag);
                    count.incrementAndGet();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error when inserting tag", e);
                }
            }

            public void finished() {
                s.release();
            }
        });
        s.acquire();
        File f1 = new File(ydb.getRoot() + "/tags.old");
        if (!f.renameTo(f1)) {
            throw new IOException("Could not rename " + f + " to " + f1);
        }
        this.filesToRemove.write("rm -rf " + f1.getAbsolutePath() + "\n");
        ++this.filesToRemoveCount;
        console.println(instance + ": TagDB migration finished, migrated " + count + " tags");
    }
}

