/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.rocksdb.BackupEngine;
import org.rocksdb.BackupInfo;
import org.rocksdb.BackupableDBOptions;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Env;
import org.rocksdb.Options;
import org.rocksdb.RestoreOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.rest.RestClient;
import org.yamcs.cli.Command;
import org.yamcs.cli.YamcsCli;
import org.yamcs.yarch.BackupUtils;

@Parameters(commandDescription="Perform and restore backups")
public class Backup
extends Command {
    public Backup(YamcsCli yamcsCli) {
        super("backup", yamcsCli);
        this.addSubCommand(new BackupCreate());
        this.addSubCommand(new BackupDelete());
        this.addSubCommand(new BackupList());
        this.addSubCommand(new BackupRestore());
    }

    @Override
    void execute() throws Exception {
        RocksDB.loadLibrary();
        super.execute();
    }

    private void error(String msg) {
        throw new ParameterException(this.getFullCommandName() + ": " + msg);
    }

    @Parameters(commandDescription="Delete a backup")
    public class BackupDelete
    extends BackupCommand {
        @Parameter(names={"--backupId"}, description="backup id", required=true)
        Integer backupId;

        public BackupDelete() {
            super("delete", Backup.this);
        }

        @Override
        void execute() throws Exception {
            BackupUtils.verifyBackupDirectory((String)this.backupDir, (boolean)true);
            try (BackupableDBOptions opt = new BackupableDBOptions(this.backupDir);
                 BackupEngine backupEngine = BackupEngine.open((Env)Env.getDefault(), (BackupableDBOptions)opt);){
                backupEngine.deleteBackup(this.backupId.intValue());
            }
            console.println("Backup with id " + this.backupId + " removed");
        }
    }

    @Parameters(commandDescription="List the existing backups")
    private class BackupList
    extends BackupCommand {
        public BackupList() {
            super("list", Backup.this);
        }

        @Override
        void execute() throws Exception {
            BackupUtils.verifyBackupDirectory((String)this.backupDir, (boolean)true);
            BackupableDBOptions opt = new BackupableDBOptions(this.backupDir);
            BackupEngine backupEngine = BackupEngine.open((Env)Env.getDefault(), (BackupableDBOptions)opt);
            List blist = backupEngine.getBackupInfo();
            String sep = "+----------+---------------+----------+------------------------------+";
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.of("UTC"));
            console.println(sep);
            console.println(String.format("|%10s|%15s|%10s|%30s|", "backup id", "size (bytes)", "num files", "time"));
            console.println(sep);
            for (BackupInfo bi : blist) {
                console.println(String.format("|%10d|%15d|%10d|%30s|", bi.backupId(), bi.size(), bi.numberFiles(), formatter.format(Instant.ofEpochMilli(1000L * bi.timestamp()))));
            }
            console.println(sep);
            backupEngine.close();
            opt.close();
        }
    }

    @Parameters(commandDescription="Restore a backup. This can only be done when the Yamcs server is not running.")
    private class BackupRestore
    extends BackupCommand {
        @Parameter(names={"--restoreDir"}, description="restore directory (where the backup will be restored)", required=true)
        String restoreDir;
        @Parameter(names={"--backupId"}, description="Backup id. If not specified, the last backup will be restored.")
        Integer backupId;

        public BackupRestore() {
            super("restore", Backup.this);
        }

        @Override
        void execute() throws Exception {
            BackupUtils.verifyBackupDirectory((String)this.backupDir, (boolean)true);
            try (BackupableDBOptions opt = new BackupableDBOptions(this.backupDir);
                 BackupEngine backupEngine = BackupEngine.open((Env)Env.getDefault(), (BackupableDBOptions)opt);
                 RestoreOptions restoreOpt = new RestoreOptions(true);){
                if (this.backupId != null) {
                    backupEngine.restoreDbFromBackup(this.backupId.intValue(), this.restoreDir, this.restoreDir, restoreOpt);
                } else {
                    backupEngine.restoreDbFromLatestBackup(this.restoreDir, this.restoreDir, restoreOpt);
                }
            }
            console.println("Backup restored successfully to " + this.restoreDir);
        }
    }

    @Parameters(commandDescription="Create a new backup. Backups can be done directly or via a running Yamcs server.")
    private class BackupCreate
    extends BackupCommand {
        @Parameter(names={"--dbDir"}, description="database directory", required=true)
        String dbDir;

        public BackupCreate() {
            super("create", Backup.this);
        }

        @Override
        void validate() {
            YamcsConnectionProperties yamcsConn = this.getYamcsConnectionProperties();
            if (yamcsConn != null && yamcsConn.getInstance() == null) {
                Backup.this.error("please specify the yamcs instance in the yamcs connection url (-y)");
            }
        }

        @Override
        void execute() throws Exception {
            YamcsConnectionProperties yamcsConn = this.getYamcsConnectionProperties();
            if (yamcsConn == null) {
                File current = new File(this.dbDir + File.separatorChar + "CURRENT");
                if (!current.exists()) {
                    throw new Exception("'" + this.dbDir + "' does not look like a RocksDB database directory");
                }
                this.backupDirectly();
            } else {
                RestClient restClient = new RestClient(yamcsConn);
                QueryStringEncoder qse = new QueryStringEncoder("/archive/" + yamcsConn.getInstance() + "/rocksdb/backup" + this.dbDir);
                qse.addParam("backupDir", this.backupDir);
                String resource = qse.toString();
                try {
                    restClient.doRequest(resource, HttpMethod.POST).get();
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause();
                    throw new Exception("got error when performing POST request for resource '" + resource + "': " + t.getMessage());
                }
            }
            console.println("Backup performed succesfully");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void backupDirectly() throws IOException {
            BackupUtils.verifyBackupDirectory((String)this.backupDir, (boolean)false);
            try (Options opt = new Options();
                 BackupableDBOptions bopt = new BackupableDBOptions(this.backupDir);
                 ColumnFamilyOptions cfOptions = new ColumnFamilyOptions();
                 DBOptions dbOptions = new DBOptions();
                 BackupEngine backupEngine = BackupEngine.open((Env)Env.getDefault(), (BackupableDBOptions)bopt);){
                List cfl = RocksDB.listColumnFamilies((Options)opt, (String)this.dbDir);
                ArrayList<ColumnFamilyDescriptor> cfdList = new ArrayList<ColumnFamilyDescriptor>(cfl.size());
                for (byte[] b : cfl) {
                    cfdList.add(new ColumnFamilyDescriptor(b, cfOptions));
                }
                ArrayList cfhList = new ArrayList(cfl.size());
                try {
                    block76: {
                        RocksDB db;
                        block77: {
                            db = RocksDB.open((DBOptions)dbOptions, (String)this.dbDir, cfdList, cfhList);
                            Throwable throwable = null;
                            try {
                                backupEngine.createNewBackup(db);
                                if (db == null) break block76;
                                if (throwable == null) break block77;
                            }
                            catch (Throwable throwable3) {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (db == null) throw throwable4;
                                    if (throwable == null) {
                                        db.close();
                                        throw throwable4;
                                    }
                                    try {
                                        db.close();
                                        throw throwable4;
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                        throw throwable4;
                                    }
                                }
                            }
                            try {
                                db.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        db.close();
                    }
                }
                finally {
                    Iterator iterator = cfhList.iterator();
                    while (iterator.hasNext()) {
                        ColumnFamilyHandle cfh = (ColumnFamilyHandle)iterator.next();
                        cfh.close();
                    }
                    return;
                }
            }
            catch (RocksDBException e) {
                throw new IOException("Error when backing up database '" + this.dbDir + "' to '" + this.backupDir + "': " + e.getMessage());
            }
        }
    }

    private abstract class BackupCommand
    extends Command {
        @Parameter(names={"--backupDir"}, description="backup directory")
        String backupDir;

        public BackupCommand(String name, Command parent) {
            super(name, parent);
        }
    }
}

