/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.google.common.io.Files;
import java.io.File;
import java.util.List;
import org.yamcs.YConfiguration;
import org.yamcs.YConfigurationResolver;
import org.yamcs.YamcsServer;
import org.yamcs.cli.Command;
import org.yamcs.cli.YamcsCli;
import org.yamcs.utils.FileUtils;
import org.yamcs.yarch.YarchDatabase;

@Parameters(commandDescription="Check the Yamcs configuration by loading all services without starting them.")
public class CheckConfig
extends Command {
    @Parameter(required=false, description="config-dir - use this directory in preference for loading configuration files. If --no-etc is specified, all configuration files will be loaded from this directory. Note that the data directory (yamcs.yaml dataDir) will be changed before starting the services,otherwise there will be RocksDB LOCK errors if a yamcs server is running.")
    private List<String> args;
    String configDir;
    @Parameter(names={"--no-etc"}, required=false, description="Do not use any file from the default Yamcs etc directory. If this is specified, the argument config-dir becomes mandatory.")
    boolean noEtc = false;

    public CheckConfig(Command parent) {
        super("confcheck", parent);
    }

    @Override
    void validate() throws ParameterException {
        super.validate();
        if (this.noEtc && this.args == null) {
            throw new ParameterException("If --no-etc option is specified, the config-dir becomes mandatory.");
        }
        if (this.noEtc && this.getYamcsCli().getEtcDir() != null) {
            throw new ParameterException("You cannot specify both --etc-dir and --no-etc.");
        }
        if (this.args != null) {
            if (this.args.size() != 1) {
                throw new ParameterException("Please specify only one config-dir.");
            }
            this.configDir = this.args.get(0);
            File d = new File(this.configDir);
            if (!d.exists()) {
                throw new ParameterException("Error: directory '" + this.configDir + "' does not exist");
            }
        }
    }

    @Override
    void execute() throws Exception {
        String etcDir = this.getYamcsCli().getEtcDir();
        if (etcDir != null) {
            if (this.configDir == null) {
                YConfiguration.setResolver((YConfigurationResolver)new YamcsCli.DirConfigurationResolver(etcDir));
            } else {
                YConfiguration.setResolver((YConfigurationResolver)new YamcsCli.DirConfigurationResolver(this.configDir, etcDir));
            }
        } else if (this.noEtc) {
            YConfiguration.setResolver((YConfigurationResolver)new YamcsCli.DirConfigurationResolver(this.configDir));
        } else if (this.configDir != null) {
            YConfiguration.setup(null, (String)this.configDir);
        }
        File tmpDir = Files.createTempDir();
        YarchDatabase.setHome((String)tmpDir.getAbsolutePath());
        YamcsServer.createGlobalServicesAndInstances();
        FileUtils.deleteRecursively((File)tmpDir);
        console.println("The configuration appears to be valid.");
    }
}

