/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.concurrent.CompletableFuture;
import org.yamcs.api.InstanceClient;
import org.yamcs.api.YamcsClient;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.Command;
import org.yamcs.cli.TableStringBuilder;
import org.yamcs.protobuf.YamcsManagement;

@Parameters(commandDescription="List clients")
public class ClientsCli
extends Command {
    public ClientsCli(Command parent) {
        super("clients", parent);
        this.addSubCommand(new ClientsList());
        this.setYcpRequired(true, true);
    }

    @Parameters(commandDescription="List connected clients")
    class ClientsList
    extends Command {
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public ClientsList() {
            super("list", ClientsCli.this);
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            if (this.global) {
                ((CompletableFuture)yamcsClient.getClients().thenAccept(response -> {
                    TableStringBuilder builder = new TableStringBuilder("ID", "USER", "APPLICATION", "INSTANCE", "PROCESSOR", "LOGIN");
                    for (YamcsManagement.ClientInfo client : response.getClientList()) {
                        builder.addLine(client.getId(), client.getUsername(), client.getApplicationName(), client.getInstance(), client.getProcessorName(), client.getLoginTimeUTC());
                    }
                    console.println(builder.toString());
                })).get();
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                ((CompletableFuture)instanceClient.getClients().thenAccept(response -> {
                    TableStringBuilder builder = new TableStringBuilder("ID", "USER", "APPLICATION", "PROCESSOR", "LOGIN");
                    for (YamcsManagement.ClientInfo client : response.getClientList()) {
                        builder.addLine(client.getId(), client.getUsername(), client.getApplicationName(), client.getProcessorName(), client.getLoginTimeUTC());
                    }
                    console.println(builder.toString());
                })).get();
            }
        }
    }
}

