/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Console;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.YamcsCli;
import org.yamcs.spi.Plugin;

public abstract class Command {
    protected static Console console = JCommander.getConsole();
    protected JCommander jc = new JCommander((Object)this);
    protected Map<String, Command> subCommands = new LinkedHashMap<String, Command>();
    protected Command selectedCommand;
    private final String name;
    final Command parent;
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Parameter(names={"-h", "--help"}, description="Show usage", help=true)
    private boolean help;
    private boolean ycpRequired = false;
    private boolean instanceRequired = false;
    private Comparator<? super ParameterDescription> parameterDescriptionComparator = (p0, p1) -> p0.getLongestName().compareTo(p1.getLongestName());

    public void setYcpRequired(boolean requiredYcp, boolean requireInstance) {
        this.ycpRequired = requiredYcp;
        this.instanceRequired = requireInstance;
    }

    public Command(String name, Command parent) {
        this.name = name;
        this.parent = parent;
        this.jc.setProgramName(this.getFullCommandName());
    }

    protected void addSubCommand(Command cmd) {
        this.subCommands.put(cmd.name, cmd);
        this.jc.addCommand(cmd.name, (Object)cmd);
    }

    protected YamcsConnectionProperties getYamcsConnectionProperties() {
        return this.getYamcsCli().ycp;
    }

    protected YamcsCli getYamcsCli() {
        Command c = this;
        while (c != null) {
            if (c instanceof YamcsCli) {
                return (YamcsCli)c;
            }
            c = c.parent;
        }
        return null;
    }

    public void parse(String ... args) {
        int k;
        try {
            if (this.subCommands.isEmpty()) {
                this.jc.parse(args);
            } else {
                for (k = 0; k < args.length && args[k].startsWith("-"); ++k) {
                    k += this.getArity(args[k]);
                }
                this.jc.parse(Arrays.copyOf(args, k));
            }
            if (this.help) {
                console.println(this.getUsage());
                System.exit(0);
            }
        }
        catch (ParameterException e) {
            console.println(e.getMessage());
            console.println(this.getUsage());
            System.exit(1);
        }
        if (this.subCommands.isEmpty()) {
            return;
        }
        if (this instanceof YamcsCli && ((YamcsCli)this).version) {
            console.println("yamcs 4.5.0");
            for (Plugin plugin : ServiceLoader.load(Plugin.class)) {
                console.println(plugin.getName() + " " + plugin.getVersion());
            }
            System.exit(0);
        }
        if (k == args.length) {
            console.println(this.getUsage());
            System.exit(1);
        }
        String subcmdName = args[k];
        this.selectedCommand = this.subCommands.get(subcmdName);
        if (this.selectedCommand == null) {
            String fullcmd = this.getFullCommandName();
            StringBuilder sb = new StringBuilder();
            sb.append(fullcmd).append(": '").append(subcmdName).append("'").append(" is not a valid command name. See '").append(fullcmd).append(" -h'");
            console.println(sb.toString());
            System.exit(1);
        }
        this.selectedCommand.parse(Arrays.copyOfRange(args, k + 1, args.length));
    }

    int getArity(String arg) {
        for (ParameterDescription pd : this.jc.getParameters()) {
            if (!Arrays.asList(pd.getParameter().names()).contains(arg)) continue;
            return this.getArity(pd);
        }
        throw new ParameterException("Unknown option '" + arg + "'");
    }

    int getArity(ParameterDescription pd) {
        Class fieldType = pd.getParameterized().getType();
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return 0;
        }
        return pd.getParameter().arity() == -1 ? 1 : pd.getParameter().arity();
    }

    String getFullCommandName() {
        ArrayList<Command> a = new ArrayList<Command>();
        Command c = this;
        while (c != null) {
            a.add(c);
            c = c.parent;
        }
        StringBuilder sb = new StringBuilder();
        int i = a.size() - 1;
        while (true) {
            sb.append(((Command)a.get(i)).getName());
            if (i == 0) break;
            sb.append(" ");
            --i;
        }
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    void execute() throws Exception {
        if (this.selectedCommand == null) {
            throw new IllegalStateException("Please implement the execute method in " + this);
        }
        this.selectedCommand.execute();
    }

    void validate() throws ParameterException {
        if (this.ycpRequired) {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            if (ycp == null) {
                throw new ParameterException("This command requires a connection to a live Yamcs. Use the 'yamcs -y' option");
            }
            if (this.instanceRequired && ycp.getInstance() == null) {
                throw new ParameterException("This command requires the Yamcs instance specified in the Yamcs URL. Use the 'yamcs -y http://host:port/instance' option");
            }
        }
        if (this.selectedCommand != null) {
            this.selectedCommand.validate();
        }
    }

    public String getUsage() {
        String format;
        int i;
        String[] descrArray;
        String descr;
        int maxLength;
        StringBuilder out = new StringBuilder();
        out.append("usage: " + this.getFullCommandName()).append(" ");
        List sorted = this.jc.getParameters();
        Collections.sort(sorted, this.parameterDescriptionComparator);
        if (!sorted.isEmpty()) {
            out.append("[<options>]");
        }
        if (!this.subCommands.isEmpty()) {
            out.append(" <command> [<command options>]");
        }
        if (this.jc.getMainParameter() != null) {
            out.append(" ");
            if (this.jc.getMainParameter().getParameter().required()) {
                out.append(this.jc.getMainParameterDescription());
            } else {
                out.append("[").append(this.jc.getMainParameterDescription()).append("]");
            }
        }
        out.append("\n");
        if (sorted.size() > 0) {
            maxLength = 3 + sorted.stream().map(pd -> pd.getNames().length()).max(Integer::max).get();
            out.append("Options:\n");
            for (ParameterDescription pd2 : sorted) {
                descr = pd2.getDescription();
                descrArray = descr.split("\\n");
                out.append(String.format("    %-" + maxLength + "s    %s\n", pd2.getNames(), descrArray[0]));
                for (i = 1; i < descrArray.length; ++i) {
                    format = "%-" + (maxLength + pd2.getNames().length() + 1) + "s%s\n";
                    out.append(String.format(format, "", descrArray[i]));
                }
            }
        }
        if (!this.subCommands.isEmpty()) {
            out.append("Commands:\n");
            maxLength = this.subCommands.values().stream().mapToInt(c -> c.getName().length()).max().getAsInt();
            for (Command c2 : this.subCommands.values()) {
                descr = this.jc.getCommandDescription(c2.getName());
                descrArray = descr.split("\\n");
                out.append(String.format("    %-" + maxLength + "s    %s\n", c2.getName(), descrArray[0]));
                for (i = 1; i < descrArray.length; ++i) {
                    format = "%-" + (maxLength + c2.getName().length() + 3) + "s%s\n";
                    out.append(String.format(format, "", descrArray[i]));
                }
            }
        }
        return out.toString();
    }
}

