/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.Command;
import org.yamcs.cli.YamcsCli;

@Parameters(commandDescription="Manage Yamcs client properties")
public class Config
extends Command {
    public Config(YamcsCli yamcsCli) {
        super("config", yamcsCli);
        this.addSubCommand(new ConfigList());
        this.addSubCommand(new ConfigGet());
        this.addSubCommand(new ConfigSet());
    }

    private static Properties loadProperties() throws IOException {
        Properties props = new Properties();
        File preferenceFile = YamcsConnectionProperties.getPreferenceFile();
        if (preferenceFile.exists()) {
            try (FileInputStream in = new FileInputStream(preferenceFile);){
                props.load(in);
            }
        }
        return props;
    }

    @Parameters(commandDescription="Set client property")
    private class ConfigSet
    extends Command {
        @Parameter(description="property value", arity=2)
        List<String> main;

        public ConfigSet() {
            super("set", Config.this);
            this.main = new ArrayList<String>();
        }

        @Override
        void execute() throws Exception {
            String property = this.main.get(0);
            String value = this.main.get(1);
            Properties props = Config.loadProperties();
            props.setProperty(property, value);
            File preferenceFile = YamcsConnectionProperties.getPreferenceFile();
            try (FileOutputStream out = new FileOutputStream(preferenceFile);){
                props.store(out, null);
            }
        }
    }

    @Parameters(commandDescription="Get value of client property")
    private class ConfigGet
    extends Command {
        @Parameter(description="property", arity=1)
        List<String> main;

        public ConfigGet() {
            super("get", Config.this);
            this.main = new ArrayList<String>();
        }

        @Override
        void execute() throws Exception {
            String property = this.main.get(0);
            Properties props = Config.loadProperties();
            if (!props.containsKey(property)) {
                throw new IllegalArgumentException("No property " + property);
            }
            console.println(props.getProperty(property));
        }
    }

    @Parameters(commandDescription="List client properties")
    private class ConfigList
    extends Command {
        public ConfigList() {
            super("list", Config.this);
        }

        @Override
        void execute() throws Exception {
            Properties props = Config.loadProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                console.println(entry.getKey() + " = " + entry.getValue());
            }
        }
    }
}

