/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.yamcs.api.YamcsClient;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.Command;
import org.yamcs.cli.TableStringBuilder;
import org.yamcs.protobuf.YamcsManagement;

@Parameters(commandDescription="Read Yamcs instances")
public class InstancesCli
extends Command {
    public InstancesCli(Command parent) {
        super("instances", parent);
        this.addSubCommand(new InstancesDescribe());
        this.addSubCommand(new InstancesList());
        this.setYcpRequired(true, false);
    }

    @Parameters(commandDescription="Describe instance")
    class InstancesDescribe
    extends Command {
        @Parameter(required=true, description="instance")
        List<String> instances;

        public InstancesDescribe() {
            super("describe", InstancesCli.this);
            this.instances = new ArrayList<String>();
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            for (String instance : this.instances) {
                ((CompletableFuture)yamcsClient.getInstance(instance).thenAccept(response -> console.println(response.toString()))).get();
            }
        }
    }

    @Parameters(commandDescription="List instances")
    class InstancesList
    extends Command {
        public InstancesList() {
            super("list", InstancesCli.this);
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            ((CompletableFuture)yamcsClient.getInstances().thenAccept(response -> {
                TableStringBuilder builder = new TableStringBuilder("NAME", "STATE", "MISSION TIME");
                for (YamcsManagement.YamcsInstance instance : response.getInstanceList()) {
                    builder.addLine(instance.getName(), instance.getState(), instance.getMissionTime());
                }
                console.println(builder.toString());
            })).get();
        }
    }
}

