/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.yamcs.api.InstanceClient;
import org.yamcs.api.YamcsClient;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.Command;
import org.yamcs.cli.TableStringBuilder;
import org.yamcs.protobuf.Rest;
import org.yamcs.protobuf.YamcsManagement;

@Parameters(commandDescription="Read and manipulate data links")
public class LinksCli
extends Command {
    public LinksCli(Command parent) {
        super("links", parent);
        this.addSubCommand(new LinksList());
        this.addSubCommand(new LinksEnable());
        this.addSubCommand(new LinksDisable());
        this.addSubCommand(new LinksDescribe());
        this.setYcpRequired(true, true);
    }

    @Parameters(commandDescription="Describe link")
    class LinksDescribe
    extends Command {
        @Parameter(required=true, description="instance")
        List<String> links;

        public LinksDescribe() {
            super("describe", LinksCli.this);
            this.links = new ArrayList<String>();
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
            for (String link : this.links) {
                ((CompletableFuture)instanceClient.getLink(link).thenAccept(response -> console.println(response.toString()))).get();
            }
        }
    }

    @Parameters(commandDescription="Disable a link")
    class LinksDisable
    extends Command {
        @Parameter(description="link", required=true)
        List<String> links;

        public LinksDisable() {
            super("disable", LinksCli.this);
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
            for (String link : this.links) {
                Rest.EditLinkRequest options = Rest.EditLinkRequest.newBuilder().setState("disabled").build();
                instanceClient.editLink(link, options).get();
            }
        }
    }

    @Parameters(commandDescription="Enable a link")
    class LinksEnable
    extends Command {
        @Parameter(description="link", required=true)
        List<String> links;

        public LinksEnable() {
            super("enable", LinksCli.this);
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
            for (String link : this.links) {
                Rest.EditLinkRequest options = Rest.EditLinkRequest.newBuilder().setState("enabled").build();
                instanceClient.editLink(link, options).get();
            }
        }
    }

    @Parameters(commandDescription="List links")
    class LinksList
    extends Command {
        public LinksList() {
            super("list", LinksCli.this);
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
            ((CompletableFuture)instanceClient.getLinks().thenAccept(response -> {
                TableStringBuilder builder = new TableStringBuilder("NAME", "TYPE", "STREAM", "STATUS", "DATA COUNT");
                for (YamcsManagement.LinkInfo link : response.getLinkList()) {
                    builder.addLine(link.getName(), link.getType(), link.getStream(), link.getStatus(), link.getDataCount());
                }
                console.println(builder.toString());
            })).get();
        }
    }
}

