/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.HashMap;
import org.rocksdb.RocksDB;
import org.yamcs.cli.Command;
import org.yamcs.cli.YamcsCli;
import org.yamcs.parameterarchive.ParameterArchiveV2;
import org.yamcs.parameterarchive.ParameterGroupIdDb;
import org.yamcs.parameterarchive.ParameterId;
import org.yamcs.parameterarchive.ParameterIdDb;
import org.yamcs.utils.SortedIntArray;
import org.yamcs.utils.TimeEncoding;

@Parameters(commandDescription="Parameter Archive operations (offline)")
public class ParameterArchiveCli
extends Command {
    @Parameter(names={"--instance"}, description="yamcs instance", required=true)
    String yamcsInstance;

    public ParameterArchiveCli(YamcsCli yamcsCli) {
        super("parchive", yamcsCli);
        this.addSubCommand(new PrintPid());
        this.addSubCommand(new PrintPgid());
        TimeEncoding.setUp();
    }

    @Parameters(commandDescription="Print parameter group compositions")
    class PrintPgid
    extends Command {
        @Parameter(names={"--name"}, description="fully qualified name of the parameter", required=true)
        String name;

        PrintPgid() {
            super("print-pgid", ParameterArchiveCli.this);
        }

        @Override
        public void execute() throws Exception {
            RocksDB.loadLibrary();
            ParameterArchiveV2 parchive = new ParameterArchiveV2(ParameterArchiveCli.this.yamcsInstance, new HashMap());
            ParameterIdDb pid = parchive.getParameterIdDb();
            ParameterGroupIdDb pgid = parchive.getParameterGroupIdDb();
            ParameterId[] pids = pid.get(this.name);
            if (pids == null) {
                console.println("No parameter named '" + this.name + "' in the parameter archive");
                return;
            }
            for (ParameterId p : pids) {
                int[] groups;
                console.println("groups for " + p + ": ");
                for (int g : groups = pgid.getAllGroups(p.pid)) {
                    console.print(g + ": ");
                    SortedIntArray sia = pgid.getParameterGroup(g);
                    for (int a : sia.getArray()) {
                        console.print(pid.getParameterFqnById(a) + " ");
                    }
                    console.println("");
                }
            }
        }
    }

    @Parameters(commandDescription="Print parameter name to parameter id mapping")
    class PrintPid
    extends Command {
        PrintPid() {
            super("print-pid", ParameterArchiveCli.this);
        }

        @Override
        public void execute() throws Exception {
            RocksDB.loadLibrary();
            ParameterArchiveV2 parchive = new ParameterArchiveV2(ParameterArchiveCli.this.yamcsInstance, new HashMap());
            ParameterIdDb pid = parchive.getParameterIdDb();
            pid.print(System.out);
        }
    }
}

