/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameters;
import java.io.Console;
import java.util.Arrays;
import org.yamcs.cli.Command;
import org.yamcs.cli.YamcsCli;
import org.yamcs.security.PBKDF2PasswordHasher;

@Parameters(commandDescription="Generate password hash for use in users.yaml")
public class PasswordHashCli
extends Command {
    public PasswordHashCli(YamcsCli yamcsCli) {
        super("password-hash", yamcsCli);
    }

    @Override
    void execute() throws Exception {
        Console console = System.console();
        console.printf("Enter password: ", new Object[0]);
        char[] newPassword = console.readPassword();
        console.printf("Confirm password: ", new Object[0]);
        char[] confirmedPassword = console.readPassword();
        if (!Arrays.equals(newPassword, confirmedPassword)) {
            console.printf("Password confirmation does not match\n", new Object[0]);
            System.exit(-1);
        }
        PBKDF2PasswordHasher hasher = new PBKDF2PasswordHasher();
        console.printf(hasher.createHash(confirmedPassword), new Object[0]);
        console.printf("\n", new Object[0]);
    }
}

