/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.concurrent.CompletableFuture;
import org.yamcs.api.InstanceClient;
import org.yamcs.api.YamcsClient;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.Command;
import org.yamcs.cli.TableStringBuilder;
import org.yamcs.protobuf.YamcsManagement;

@Parameters(commandDescription="List processors")
public class ProcessorsCli
extends Command {
    public ProcessorsCli(Command parent) {
        super("processors", parent);
        this.addSubCommand(new ProcessorsList());
        this.setYcpRequired(true, true);
    }

    @Parameters(commandDescription="List processors")
    class ProcessorsList
    extends Command {
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public ProcessorsList() {
            super("list", ProcessorsCli.this);
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            if (this.global) {
                ((CompletableFuture)yamcsClient.getProcessors().thenAccept(response -> {
                    TableStringBuilder builder = new TableStringBuilder("INSTANCE", "NAME", "TYPE", "OWNER", "PERSISTENT", "TIME", "STATUS");
                    for (YamcsManagement.ProcessorInfo processor : response.getProcessorList()) {
                        builder.addLine(processor.getInstance(), processor.getName(), processor.getType(), processor.getCreator(), processor.getPersistent(), processor.getTime(), processor.getState());
                    }
                    console.println(builder.toString());
                })).get();
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                ((CompletableFuture)instanceClient.getProcessors().thenAccept(response -> {
                    TableStringBuilder builder = new TableStringBuilder("NAME", "TYPE", "OWNER", "PERSISTENT", "TIME", "STATUS");
                    for (YamcsManagement.ProcessorInfo processor : response.getProcessorList()) {
                        builder.addLine(processor.getName(), processor.getType(), processor.getCreator(), processor.getPersistent(), processor.getTime(), processor.getState());
                    }
                    console.println(builder.toString());
                })).get();
            }
        }
    }
}

