/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.yamcs.cli.Command;
import org.yamcs.cli.RocksDbBenchmark;
import org.yamcs.cli.YamcsCli;
import org.yamcs.yarch.rocksdb.RdbConfig;
import org.yamcs.yarch.rocksdb.YRDB;

@Parameters(commandDescription="Provides low-level RocksDB data operations")
public class RocksDbCli
extends Command {
    public RocksDbCli(YamcsCli yamcsCli) {
        super("rocksdb", yamcsCli);
        this.addSubCommand(new RocksdbCompact());
        this.addSubCommand(new RocksDbBenchmark(this));
    }

    @Override
    public void execute() throws Exception {
        RocksDB.loadLibrary();
        super.execute();
    }

    @Parameters(commandDescription="Compact rocksdb database")
    private class RocksdbCompact
    extends Command {
        @Parameter(names={"--dbDir"}, description="database directory", required=true)
        String dbDir;
        @Parameter(names={"--sizeMB"}, description="target size of each SST files in MB (by default 256 MB)", required=false)
        int sizeMB;

        public RocksdbCompact() {
            super("compact", RocksDbCli.this);
            this.sizeMB = 256;
        }

        @Override
        void execute() throws Exception {
            Options opt = new Options();
            List cfl = RocksDB.listColumnFamilies((Options)opt, (String)this.dbDir);
            ArrayList<ColumnFamilyDescriptor> cfdList = new ArrayList<ColumnFamilyDescriptor>(cfl.size());
            RdbConfig rdbConfig = RdbConfig.getInstance();
            ColumnFamilyOptions cfoptions = rdbConfig.getDefaultColumnFamilyOptions();
            cfoptions.setCompactionStyle(CompactionStyle.UNIVERSAL);
            cfoptions.setTargetFileSizeBase(0x100000L * (long)this.sizeMB);
            for (byte[] b : cfl) {
                cfdList.add(new ColumnFamilyDescriptor(b, cfoptions));
            }
            ArrayList cfhList = new ArrayList(cfl.size());
            try (DBOptions dbOptions = new DBOptions();
                 RocksDB db = RocksDB.open((DBOptions)dbOptions, (String)this.dbDir, cfdList, cfhList);){
                for (int i = 0; i < cfhList.size(); ++i) {
                    ColumnFamilyHandle cfh = (ColumnFamilyHandle)cfhList.get(i);
                    console.println("Compacting Column Family " + YRDB.cfNameToString((byte[])((byte[])cfl.get(i))));
                    db.compactRange(cfh);
                }
            }
            cfoptions.close();
            opt.close();
        }
    }
}

