/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.yamcs.api.InstanceClient;
import org.yamcs.api.YamcsClient;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.Command;
import org.yamcs.cli.TableStringBuilder;
import org.yamcs.protobuf.Rest;
import org.yamcs.protobuf.YamcsManagement;

@Parameters(commandDescription="Read and manipulate services")
public class ServicesCli
extends Command {
    public ServicesCli(Command parent) {
        super("services", parent);
        this.addSubCommand(new ServicesList());
        this.addSubCommand(new ServicesEnable());
        this.addSubCommand(new ServicesDisable());
        this.addSubCommand(new ServicesDescribe());
        this.setYcpRequired(true, true);
    }

    @Parameters(commandDescription="Describe service")
    class ServicesDescribe
    extends Command {
        @Parameter(required=true, description="instance")
        List<String> services;
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public ServicesDescribe() {
            super("describe", ServicesCli.this);
            this.services = new ArrayList<String>();
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            if (this.global) {
                for (String service : this.services) {
                    ((CompletableFuture)yamcsClient.getService(service).thenAccept(response -> console.println(response.toString()))).get();
                }
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                for (String service : this.services) {
                    ((CompletableFuture)instanceClient.getService(service).thenAccept(response -> console.println(response.toString()))).get();
                }
            }
        }
    }

    @Parameters(commandDescription="Disable a service")
    class ServicesDisable
    extends Command {
        @Parameter(description="service", required=true)
        List<String> services;
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public ServicesDisable() {
            super("disable", ServicesCli.this);
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            if (this.global) {
                for (String service : this.services) {
                    Rest.EditServiceRequest options = Rest.EditServiceRequest.newBuilder().setState("stopped").build();
                    yamcsClient.editService(service, options).get();
                }
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                for (String service : this.services) {
                    Rest.EditServiceRequest options = Rest.EditServiceRequest.newBuilder().setState("stopped").build();
                    instanceClient.editService(service, options).get();
                }
            }
        }
    }

    @Parameters(commandDescription="Enable a service")
    class ServicesEnable
    extends Command {
        @Parameter(description="service", required=true)
        List<String> services;
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public ServicesEnable() {
            super("enable", ServicesCli.this);
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            if (this.global) {
                for (String service : this.services) {
                    Rest.EditServiceRequest options = Rest.EditServiceRequest.newBuilder().setState("running").build();
                    yamcsClient.editService(service, options).get();
                }
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                for (String service : this.services) {
                    Rest.EditServiceRequest options = Rest.EditServiceRequest.newBuilder().setState("running").build();
                    instanceClient.editService(service, options).get();
                }
            }
        }
    }

    @Parameters(commandDescription="List services")
    class ServicesList
    extends Command {
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public ServicesList() {
            super("list", ServicesCli.this);
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            if (this.global) {
                ((CompletableFuture)yamcsClient.getServices().thenAccept(response -> {
                    TableStringBuilder builder = new TableStringBuilder("NAME", "STATUS");
                    for (YamcsManagement.ServiceInfo service : response.getServiceList()) {
                        builder.addLine(service.getName(), service.getState());
                    }
                    console.println(builder.toString());
                })).get();
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                ((CompletableFuture)instanceClient.getServices().thenAccept(response -> {
                    TableStringBuilder builder = new TableStringBuilder("NAME", "STATUS");
                    for (YamcsManagement.ServiceInfo service : response.getServiceList()) {
                        builder.addLine(service.getName(), service.getState());
                    }
                    console.println(builder.toString());
                })).get();
            }
        }
    }
}

