/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.yamcs.api.InstanceClient;
import org.yamcs.api.YamcsClient;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.Command;
import org.yamcs.protobuf.Rest;

@Parameters(commandDescription="Manage object storage")
public class StorageCli
extends Command {
    public StorageCli(Command parent) {
        super("storage", parent);
        this.addSubCommand(new StorageCat());
        this.addSubCommand(new StorageList());
        this.addSubCommand(new StorageMakeBuckets());
        this.addSubCommand(new StorageRemoveBuckets());
        this.setYcpRequired(true, true);
    }

    @Parameters(commandDescription="Remove buckets")
    class StorageRemoveBuckets
    extends Command {
        @Parameter(required=true, description="bucket...")
        List<String> main;
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public StorageRemoveBuckets() {
            super("rb", StorageCli.this);
            this.main = new ArrayList<String>();
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            for (String bucket : this.main) {
                if (this.global) {
                    yamcsClient.deleteBucket(bucket).get();
                    continue;
                }
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                instanceClient.deleteBucket(bucket).get();
            }
        }
    }

    @Parameters(commandDescription="Make buckets")
    class StorageMakeBuckets
    extends Command {
        @Parameter(required=true, description="bucket...")
        List<String> main;
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public StorageMakeBuckets() {
            super("mb", StorageCli.this);
            this.main = new ArrayList<String>();
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            for (String bucket : this.main) {
                Rest.CreateBucketRequest req = Rest.CreateBucketRequest.newBuilder().setName(bucket).build();
                if (this.global) {
                    yamcsClient.createBucket(req).get();
                    continue;
                }
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                instanceClient.createBucket(req).get();
            }
        }
    }

    @Parameters(commandDescription="Concatenate object content to stdout")
    class StorageCat
    extends Command {
        @Parameter(required=true, description="bucket object", arity=2)
        List<String> main;
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public StorageCat() {
            super("cat", StorageCli.this);
            this.main = new ArrayList<String>();
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            String bucket = this.main.get(0);
            String object = this.main.get(1);
            if (this.global) {
                ((CompletableFuture)yamcsClient.getObject(bucket, object).thenAccept(response -> {
                    try {
                        System.out.write((byte[])response);
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                })).get();
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                ((CompletableFuture)instanceClient.getObject(bucket, object).thenAccept(response -> {
                    try {
                        System.out.write((byte[])response);
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                })).get();
            }
        }
    }

    @Parameters(commandDescription="List buckets or objects")
    class StorageList
    extends Command {
        @Parameter(required=false, description="bucket", arity=1)
        List<String> main;
        @Parameter(names={"-g", "--global"}, description="Do not use instance-specific data")
        boolean global;

        public StorageList() {
            super("list", StorageCli.this);
            this.main = new ArrayList<String>();
            this.global = false;
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            YamcsClient yamcsClient = new YamcsClient(ycp);
            if (this.global) {
                if (this.main.isEmpty()) {
                    ((CompletableFuture)yamcsClient.getBuckets().thenAccept(response -> {
                        for (Rest.BucketInfo bucket : response.getBucketList()) {
                            console.println(bucket.getName());
                        }
                    })).get();
                } else {
                    String bucket = this.main.get(0);
                    ((CompletableFuture)yamcsClient.getObjects(bucket).thenAccept(response -> {
                        for (Rest.ObjectInfo object : response.getObjectList()) {
                            console.println(object.getName());
                        }
                    })).get();
                }
            } else {
                InstanceClient instanceClient = yamcsClient.selectInstance(ycp.getInstance());
                if (this.main.isEmpty()) {
                    ((CompletableFuture)instanceClient.getBuckets().thenAccept(response -> {
                        for (Rest.BucketInfo bucket : response.getBucketList()) {
                            console.println(bucket.getName());
                        }
                    })).get();
                } else {
                    String bucket = this.main.get(0);
                    ((CompletableFuture)instanceClient.getObjects(bucket).thenAccept(response -> {
                        for (Rest.ObjectInfo object : response.getObjectList()) {
                            console.println(object.getName());
                        }
                    })).get();
                }
            }
        }
    }
}

