/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import java.util.ArrayList;
import java.util.List;

public class TableStringBuilder {
    private String[] header;
    private List<String[]> rows = new ArrayList<String[]>();
    private int[] widths;

    public TableStringBuilder(String ... header) {
        this.header = header;
        this.widths = new int[header.length];
        for (int i = 0; i < header.length; ++i) {
            this.widths[i] = header[i].length();
        }
    }

    public void addLine(Object ... data) {
        String[] dataStrings = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            String stringValue;
            dataStrings[i] = stringValue = data[i] != null ? data[i].toString() : "";
            if (data[i] == null || stringValue.length() <= this.widths[i]) continue;
            this.widths[i] = stringValue.length();
        }
        this.rows.add(dataStrings);
    }

    private String buildStringFormat() {
        StringBuilder fm = new StringBuilder();
        for (int i = 0; i < this.widths.length; ++i) {
            fm.append("%-").append(this.widths[i]).append("s");
            if (i >= this.widths.length - 1) continue;
            fm.append("  ");
        }
        return fm.toString();
    }

    public String toString() {
        String fm = this.buildStringFormat();
        String hline = String.format(fm, this.header);
        StringBuilder buf = new StringBuilder(hline);
        for (String[] row : this.rows) {
            String line = String.format(fm, row);
            buf.append("\n").append(line);
        }
        return buf.toString();
    }
}

