/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.yamcs.api.InstanceClient;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsClient;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.rest.BulkRestDataSender;
import org.yamcs.api.rest.RestClient;
import org.yamcs.cli.Command;
import org.yamcs.protobuf.Archive;
import org.yamcs.protobuf.Table;

@Parameters(commandDescription="Read and manipulate tables")
public class TablesCli
extends Command {
    public TablesCli(Command parent) {
        super("tables", parent);
        this.addSubCommand(new TablesList());
        this.addSubCommand(new TablesDump());
        this.addSubCommand(new TablesLoad());
        this.setYcpRequired(true, true);
    }

    @Parameters(commandDescription="Load data to table")
    class TablesLoad
    extends Command {
        @Parameter(names={"-d"}, description="Name of the directory to load files from. If not specified, the current directory will be used. The directory has to contain <tableName>.dump.")
        String dir;
        @Parameter(description="table1 table2...", required=true)
        List<String> tableList;

        public TablesLoad() {
            super("load", TablesCli.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void loadTable(String tableName) throws Exception {
            String fileName = tableName + ".dump";
            if (this.dir != null) {
                fileName = this.dir + "/" + tableName + ".dump";
            }
            GZIPInputStream is = new GZIPInputStream(new FileInputStream(fileName));
            System.out.println("Loading " + fileName + " into table " + tableName);
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            try (RestClient restClient = new RestClient(ycp);){
                Table.Row tr;
                CompletableFuture cf = restClient.doBulkSendRequest("/archive/" + ycp.getInstance() + "/tables/" + tableName + "/data", HttpMethod.POST);
                BulkRestDataSender bds = (BulkRestDataSender)cf.get();
                ByteBuf buf = Unpooled.buffer();
                ByteBufOutputStream bufstream = new ByteBufOutputStream(buf);
                int c = 0;
                while ((tr = Table.Row.parseDelimitedFrom((InputStream)is)) != null) {
                    tr.writeDelimitedTo((OutputStream)bufstream);
                    if ((c++ & 0xF) == 0) {
                        bufstream.close();
                        bds.sendData(buf);
                        buf = Unpooled.buffer();
                        bufstream = new ByteBufOutputStream(buf);
                    }
                    if (c % 100 != 0) continue;
                    System.out.print("\r" + c + " rows loaded");
                    System.out.flush();
                }
                bufstream.close();
                if (buf.readableBytes() > 0) {
                    bds.sendData(buf);
                }
                ((InputStream)is).close();
                Table.TableLoadResponse tlr = Table.TableLoadResponse.parseFrom((byte[])((byte[])bds.completeRequest().get()));
                System.out.println("\nTable load finished successfully: " + tlr.getRowsLoaded() + " rows loaded");
            }
        }

        @Override
        public void execute() throws Exception {
            for (String tn : this.tableList) {
                this.loadTable(tn);
            }
        }
    }

    @Parameters(commandDescription="Dumps table data to file")
    class TablesDump
    extends Command {
        @Parameter(names={"-d"}, description="Name of the output directory. If not specified, the current directory will be used. The directory has to exist.")
        String dir;
        @Parameter(description="table1 table2...", required=true)
        List<String> tableList;

        public TablesDump() {
            super("dump", TablesCli.this);
        }

        private void dumpTable(String tableName) throws Exception {
            String fileName = tableName + ".dump";
            if (this.dir != null) {
                fileName = this.dir + "/" + fileName;
            }
            AtomicInteger count = new AtomicInteger();
            System.out.println("Dumping data from " + tableName + " table to " + fileName);
            try (GZIPOutputStream outputs = new GZIPOutputStream(new FileOutputStream(fileName));){
                YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
                RestClient restClient = new RestClient(ycp);
                CompletableFuture cf = restClient.doBulkGetRequest("/archive/" + ycp.getInstance() + "/downloads/tables/" + tableName + "?format=dump", data -> {
                    try {
                        Table.Row tr = Table.Row.parseFrom((byte[])data);
                        tr.writeDelimitedTo(outputs);
                        int x = count.incrementAndGet();
                        if (x % 100 == 0) {
                            System.out.print("\r" + x + " rows saved");
                            System.out.flush();
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Error receiving table row: " + e.getMessage());
                        throw new YamcsApiException("error decoding or writing table row: " + e.getMessage(), (Throwable)e);
                    }
                });
                cf.get();
                restClient.close();
            }
            System.out.println("\rsaved " + count.get() + " rows");
        }

        @Override
        public void execute() throws Exception {
            for (String tableName : this.tableList) {
                this.dumpTable(tableName);
            }
        }
    }

    @Parameters(commandDescription="List existing tables")
    class TablesList
    extends Command {
        public TablesList() {
            super("list", TablesCli.this);
        }

        @Override
        public void execute() throws Exception {
            YamcsConnectionProperties ycp = this.getYamcsConnectionProperties();
            InstanceClient instanceClient = new YamcsClient(ycp).selectInstance(ycp.getInstance());
            ((CompletableFuture)instanceClient.getTables().thenAccept(response -> {
                for (Archive.TableInfo table : response.getTableList()) {
                    console.println(table.getName());
                }
            })).get();
        }
    }
}

