/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yamcs.ConfigurationException;
import org.yamcs.YConfiguration;
import org.yamcs.cli.Command;
import org.yamcs.xtce.XtceDb;
import org.yamcs.xtceproc.XtceDbFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

@Parameters(commandDescription="Provides information about the xtce database")
public class XtceDbCli
extends Command {
    @Parameter(names={"-f"}, required=false, description="Use this file instead of default mdb.yaml")
    String mdbConfigFile;

    public XtceDbCli(Command parent) {
        super("xtcedb", parent);
        this.addSubCommand(new XtceDbListConfigs());
        this.addSubCommand(new XtceDbPrint());
        this.addSubCommand(new XtceDbVerify());
    }

    private XtceDb getXtceDb(String configSection) {
        XtceDb xtcedb;
        if (this.mdbConfigFile == null) {
            xtcedb = XtceDbFactory.createInstanceByConfig((String)configSection);
        } else {
            Yaml yaml = new Yaml();
            try (FileInputStream is = new FileInputStream(this.mdbConfigFile);){
                Object o = yaml.load((InputStream)is);
                if (o == null) {
                    throw new ConfigurationException(this.mdbConfigFile, this.mdbConfigFile + ": file is empty!?");
                }
                if (!(o instanceof Map)) {
                    throw new ConfigurationException(this.mdbConfigFile, this.mdbConfigFile + ": top level structure must be a map and not a " + o);
                }
                if ((o = ((Map)o).get(configSection)) == null) {
                    throw new ConfigurationException(this.mdbConfigFile, this.mdbConfigFile + ": does not contain a mapping for " + configSection);
                }
                if (!(o instanceof List)) {
                    throw new ConfigurationException(this.mdbConfigFile, this.mdbConfigFile + ": mapping for " + configSection + " must be a list and not a " + o.getClass());
                }
                List list = (List)o;
                xtcedb = XtceDbFactory.createInstance((List)list, (boolean)false, (boolean)false);
            }
            catch (IOException | YAMLException e) {
                throw new ConfigurationException(this.mdbConfigFile, e.toString(), e);
            }
        }
        return xtcedb;
    }

    @Parameters(commandDescription="List the MDB configurations defined in mdb.yaml.")
    private class XtceDbListConfigs
    extends Command {
        public XtceDbListConfigs() {
            super("listConfigs", XtceDbCli.this);
        }

        @Override
        void execute() throws Exception {
            Set keys;
            if (XtceDbCli.this.mdbConfigFile == null) {
                YConfiguration.setup();
                YConfiguration c = YConfiguration.getConfiguration((String)"mdb");
                keys = c.getKeys();
            } else {
                Yaml yaml = new Yaml();
                try (FileInputStream is = new FileInputStream(XtceDbCli.this.mdbConfigFile);){
                    Object o = yaml.load((InputStream)is);
                    if (o == null) {
                        throw new ConfigurationException(XtceDbCli.this.mdbConfigFile, "file is empty!?");
                    }
                    if (!(o instanceof Map)) {
                        throw new ConfigurationException(XtceDbCli.this.mdbConfigFile, "top level structure must be a map and not a " + o);
                    }
                    keys = ((Map)o).keySet();
                }
            }
            for (String s : keys) {
                console.println(s);
            }
        }
    }

    @Parameters(commandDescription="Verify  that the XtceDB can be loaded.")
    private class XtceDbVerify
    extends Command {
        @Parameter(required=true, description="config-name")
        private List<String> args;

        public XtceDbVerify() {
            super("verify", XtceDbCli.this);
        }

        @Override
        void validate() {
            if (this.args.size() > 1) {
                throw new ParameterException("Please specify only one configuration.");
            }
        }

        @Override
        void execute() throws Exception {
            if (XtceDbCli.this.mdbConfigFile == null) {
                YConfiguration.setup();
            }
            XtceDb xtcedb = XtceDbCli.this.getXtceDb(this.args.get(0));
            console.println("The XtceDB was loaded without error; it contains ");
            console.println(String.format("%10d subsystems", xtcedb.getSpaceSystems().size()));
            console.println(String.format("%10d parameters", xtcedb.getParameters().size()));
            console.println(String.format("%10d sequence containers", xtcedb.getSequenceContainers().size()));
            console.println(String.format("%10d commands", xtcedb.getMetaCommands().size()));
        }
    }

    @Parameters(commandDescription="Print the contents of the XtceDB.")
    private class XtceDbPrint
    extends Command {
        @Parameter(required=true, description="config-name")
        private List<String> args;

        public XtceDbPrint() {
            super("print", XtceDbCli.this);
        }

        @Override
        void validate() {
            if (this.args.size() > 1) {
                throw new ParameterException("Please specify only one configuration.");
            }
        }

        @Override
        void execute() throws Exception {
            YConfiguration.setup();
            XtceDb xtcedb = XtceDbCli.this.getXtceDb(this.args.get(0));
            xtcedb.print(System.out);
        }
    }
}

