/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.cli;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import org.yamcs.ConfigurationException;
import org.yamcs.YConfiguration;
import org.yamcs.YConfigurationResolver;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.cli.ArchiveCli;
import org.yamcs.cli.Backup;
import org.yamcs.cli.CheckConfig;
import org.yamcs.cli.ClientsCli;
import org.yamcs.cli.Command;
import org.yamcs.cli.Config;
import org.yamcs.cli.InstancesCli;
import org.yamcs.cli.LinksCli;
import org.yamcs.cli.ParameterArchiveCli;
import org.yamcs.cli.PasswordHashCli;
import org.yamcs.cli.ProcessorsCli;
import org.yamcs.cli.RocksDbCli;
import org.yamcs.cli.ServicesCli;
import org.yamcs.cli.StorageCli;
import org.yamcs.cli.TablesCli;
import org.yamcs.cli.XtceDbCli;

public class YamcsCli
extends Command {
    @Parameter(names={"-y", "--yamcs-url"}, description="Yamcs URL")
    private String yamcsUrl;
    @Parameter(names={"--etc-dir"}, description="Override default Yamcs configuration directory")
    private String etcDir;
    @Parameter(names={"-v", "--version"}, description="Print version information and quit")
    boolean version;
    YamcsConnectionProperties ycp;

    public YamcsCli() {
        super("yamcs", null);
        this.addSubCommand(new ArchiveCli(this));
        this.addSubCommand(new Backup(this));
        this.addSubCommand(new CheckConfig(this));
        this.addSubCommand(new ClientsCli(this));
        this.addSubCommand(new Config(this));
        this.addSubCommand(new InstancesCli(this));
        this.addSubCommand(new LinksCli(this));
        this.addSubCommand(new ParameterArchiveCli(this));
        this.addSubCommand(new PasswordHashCli(this));
        this.addSubCommand(new ProcessorsCli(this));
        this.addSubCommand(new RocksDbCli(this));
        this.addSubCommand(new ServicesCli(this));
        this.addSubCommand(new StorageCli(this));
        this.addSubCommand(new TablesCli(this));
        this.addSubCommand(new XtceDbCli(this));
    }

    @Override
    void validate() throws ParameterException {
        if (this.yamcsUrl != null) {
            try {
                this.ycp = YamcsConnectionProperties.parse((String)this.yamcsUrl);
            }
            catch (URISyntaxException e) {
                throw new ParameterException("Invalid Yamcs URL '" + this.yamcsUrl + "'");
            }
        }
        File preferencesFile = YamcsConnectionProperties.getPreferenceFile();
        if (preferencesFile.exists()) {
            YamcsConnectionProperties yprops = new YamcsConnectionProperties();
            try {
                yprops.load();
                this.ycp = yprops;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.etcDir != null) {
            YConfiguration.setResolver((YConfigurationResolver)new DirConfigurationResolver(this.etcDir));
        }
        this.selectedCommand.validate();
    }

    public static void main(String[] args) {
        YamcsCli yamcsCli = new YamcsCli();
        yamcsCli.parse(args);
        try {
            yamcsCli.validate();
            yamcsCli.execute();
        }
        catch (ExecutionException e) {
            System.err.println(e.getCause());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        System.exit(0);
    }

    public String getEtcDir() {
        return this.etcDir;
    }

    public static class DirConfigurationResolver
    implements YConfigurationResolver {
        private String[] dirs;

        public DirConfigurationResolver(String ... dirs) {
            this.dirs = dirs;
        }

        public InputStream getConfigurationStream(String name) throws ConfigurationException {
            for (String dir : this.dirs) {
                File f = new File(dir, name);
                if (!f.exists()) continue;
                try {
                    FileInputStream is = new FileInputStream(f);
                    return is;
                }
                catch (FileNotFoundException e) {
                    throw new YConfiguration.ConfigurationNotFoundException("Cannot read file " + f + ": " + e.getMessage(), (Throwable)e);
                }
            }
            throw new YConfiguration.ConfigurationNotFoundException("Configuration file " + name + " does not exist. Searched in: " + Arrays.toString(this.dirs));
        }
    }
}

