/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.rest.BulkRestDataReceiver;
import org.yamcs.api.rest.RestClient;
import org.yamcs.protobuf.Pvalue;
import org.yamcs.protobuf.Rest;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.ParameterRetrievalGui;
import org.yamcs.utils.ParameterFormatter;
import org.yamcs.utils.TimeEncoding;

public class CliParameterExtractor {
    static void printUsageAndExit(String error) {
        if (error != null) {
            System.err.println(error);
        }
        System.err.println("Usage: parameter-extractor.sh [OPTIONS] yamcs-url startTime stopTime [parameter_opsnames | -f file_with_parameters]");
        System.err.println("The yamcs-url has to contain the archive instance");
        System.err.println("OPTIONS:");
        System.err.println("         \t-a           print only those lines where all parameters are set");
        System.err.println("         \t-h           print this help");
        System.err.println("         \t-k           keep previous parameters");
        System.err.println("         \t-r           print raw values in addition to engineering values");
        System.err.println("         \t-t           print the generation time on the first column");
        System.err.println("         \t-u           print unique lines only");
        System.err.println("         \t-n NAMESPACE alternative parameter namespace (e.g. \"MDB:OPS Name\")");
        System.err.println("         \t-w MILLIS    join multiple lines with timestamps within the given time window");
        System.err.println("Example:\n parameter-extractor.sh http://localhost:8090/yops 2007-08-01T12:34:00 2007-08-23T18:34:00 /SUBSYS1/IntegerPara11 /SUBSYS1/FloatPara11_1");
        System.exit(1);
    }

    public static Rest.BulkDownloadParameterValueRequest.Builder getRequest(String namespace, String ... params) {
        Rest.BulkDownloadParameterValueRequest.Builder prr = Rest.BulkDownloadParameterValueRequest.newBuilder();
        for (String p : params) {
            if (namespace != null) {
                prr.addId(Yamcs.NamedObjectId.newBuilder().setName(p).setNamespace(namespace));
                continue;
            }
            prr.addId(Yamcs.NamedObjectId.newBuilder().setName(p));
        }
        return prr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ExecutionException, URISyntaxException, FileNotFoundException, IOException, InterruptedException {
        YamcsConnectionProperties ycd;
        if (args.length < 1) {
            CliParameterExtractor.printUsageAndExit(null);
        }
        int k = 0;
        int timewindow = -1;
        boolean printRaw = false;
        boolean printUnique = false;
        boolean printTime = false;
        boolean allParametersPresent = false;
        boolean keepValues = false;
        String namespace = null;
        while (args[k].startsWith("-")) {
            if (args[k].equals("-t")) {
                printTime = true;
            } else if (args[k].equals("-r")) {
                printRaw = true;
            } else if (args[k].equals("-u")) {
                printUnique = true;
            } else if (args[k].equals("-a")) {
                allParametersPresent = true;
            } else if (args[k].equals("-k")) {
                keepValues = true;
            } else if (args[k].equals("-n")) {
                namespace = args[++k];
            } else if (args[k].equals("-h")) {
                CliParameterExtractor.printUsageAndExit(null);
            } else if (args[k].equals("-w")) {
                boolean ok = true;
                try {
                    if (++k < args.length) {
                        timewindow = Integer.valueOf(args[k]);
                    } else {
                        CliParameterExtractor.printUsageAndExit("timewindow value missing");
                    }
                    if (timewindow < 0) {
                        ok = false;
                    }
                }
                catch (NumberFormatException x) {
                    ok = false;
                }
                if (!ok) {
                    CliParameterExtractor.printUsageAndExit("timewindow must be a non-negative integer (got '" + args[k] + "')");
                }
            } else {
                CliParameterExtractor.printUsageAndExit("Unknown option '" + args[k] + "'");
            }
            ++k;
        }
        if (args.length < k + 4) {
            CliParameterExtractor.printUsageAndExit("too few arguments");
        }
        if ((ycd = YamcsConnectionProperties.parse((String)args[k++])).getInstance() == null) {
            CliParameterExtractor.printUsageAndExit("The Yamcs URL does not contain the archive instance. Use something like http://hostname/archiveInstance");
        }
        TimeEncoding.setUp();
        String start = args[k++];
        String stop = args[k++];
        Rest.BulkDownloadParameterValueRequest.Builder prr = null;
        prr = "-f".equals(args[k]) ? Rest.BulkDownloadParameterValueRequest.newBuilder().addAllId(ParameterRetrievalGui.loadParameters(new BufferedReader(new FileReader(args[k + 1])))) : CliParameterExtractor.getRequest(namespace, Arrays.copyOfRange(args, k, args.length));
        prr.setStart(start).setStop(stop);
        final ParameterFormatter pf = new ParameterFormatter(new BufferedWriter(new PrintWriter(System.out)), (Collection)prr.getIdList());
        pf.setPrintRaw(printRaw);
        pf.setPrintTime(printTime);
        pf.setPrintUnique(printUnique);
        pf.setAllParametersPresent(allParametersPresent);
        pf.setKeepValues(keepValues);
        pf.setTimeWindow(timewindow);
        RestClient restClient = new RestClient(ycd);
        CompletableFuture completableFuture = restClient.doBulkGetRequest("/archive/" + ycd.getInstance() + "/downloads/parameters", prr.build().toByteArray(), new BulkRestDataReceiver(){

            public void receiveData(byte[] data) throws YamcsApiException {
                try {
                    Pvalue.ParameterData pd = Pvalue.ParameterData.parseFrom((byte[])data);
                    pf.writeParameters(pd.getParameterList());
                }
                catch (InvalidProtocolBufferException e) {
                    System.err.println("Cannot decode parameter message: " + (Object)((Object)e));
                }
                catch (IOException e) {
                    System.err.println("Error when saving parameters: " + e);
                }
            }
        });
        try {
            completableFuture.get();
        }
        catch (ExecutionException e) {
            Throwable t;
            Throwable throwable = t = e.getCause() != null ? e.getCause() : e;
            if (t instanceof YamcsApiException) {
                YamcsApiException.RestExceptionData msg = ((YamcsApiException)t).getRestData();
                if (msg != null) {
                    System.err.println(msg.getType() + ": " + msg.getMessage());
                } else {
                    System.err.println(t.getMessage());
                }
            } else {
                System.err.println(t);
            }
        }
        finally {
            pf.close();
            restClient.close();
        }
    }
}

