/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.rest.RestClient;
import org.yamcs.protobuf.Commanding;
import org.yamcs.utils.CommandHistoryFormatter;
import org.yamcs.utils.TimeEncoding;

public class CommandHistoryRetrievalGui
extends JFrame
implements ActionListener {
    JButton startStop;
    JFileChooser fileChooser;
    List<String> cmdNames;
    long startInstant;
    long stopInstant;
    String archiveInstance;
    Component parent;
    ProgressMonitor progressMonitor;
    private File outputFile;
    private BufferedWriter writer;
    YamcsConnectionProperties connectionParams;
    CommandHistoryFormatter cmdhistFormatter;
    private CompletableFuture<Void> completableFuture;
    int count;
    long downloadStartTime;

    public CommandHistoryRetrievalGui(YamcsConnectionProperties connectionParams, Component parent) {
        super("Save Command History");
        this.connectionParams = connectionParams;
        this.parent = parent;
        Container frameContentPane = this.getContentPane();
        frameContentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Saving the command history for the selected interval into a file.");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        frameContentPane.add((Component)label, gbc);
        gbc.insets = new Insets(2, 2, 2, 2);
        this.fileChooser = new JFileChooser("Select Output Directory");
        this.fileChooser.setApproveButtonText("Save");
        this.fileChooser.addActionListener(this);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        frameContentPane.add((Component)this.fileChooser, gbc);
        this.pack();
    }

    public void setValues(String archiveInstance, List<String> cmdNames, long start, long stop) {
        this.cmdNames = cmdNames;
        this.startInstant = start;
        this.stopInstant = stop;
        this.archiveInstance = archiveInstance;
        String startWinCompatibleDateTime = TimeEncoding.toWinCompatibleDateTime((long)this.startInstant);
        String stopWinCompatibleDateTime = TimeEncoding.toWinCompatibleDateTime((long)this.stopInstant);
        String fileName = String.format("cmdhistory_%s_%s.csv", startWinCompatibleDateTime, stopWinCompatibleDateTime);
        this.fileChooser.setSelectedFile(new File(this.fileChooser.getSelectedFile(), fileName));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("CancelSelection")) {
            this.setVisible(false);
        } else {
            this.outputFile = this.fileChooser.getSelectedFile();
            if (this.outputFile.exists() && JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite " + this.outputFile, "Overwrite file?", 0, 2) == 1) {
                return;
            }
            this.setVisible(false);
            this.count = 0;
            this.downloadStartTime = System.currentTimeMillis();
            this.progressMonitor = new ProgressMonitor(this.parent, "Saving packets", "0 packets saved", 0, (int)((this.stopInstant - this.startInstant) / 1000L));
            try {
                this.writer = new BufferedWriter(new FileWriter(this.outputFile));
                this.cmdhistFormatter = new CommandHistoryFormatter(this.writer);
                RestClient restClient = new RestClient(this.connectionParams);
                StringBuilder sb = new StringBuilder();
                sb.append("/archive/").append(this.archiveInstance).append("/downloads/commands").append("?start=").append(TimeEncoding.toString((long)this.startInstant)).append("&stop=").append(TimeEncoding.toString((long)this.stopInstant)).append("&name=");
                this.completableFuture = restClient.doBulkGetRequest(sb.toString(), data -> {
                    try {
                        Commanding.CommandHistoryEntry che = Commanding.CommandHistoryEntry.parseFrom((byte[])data);
                        this.receivedCommadHistory(che);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                this.completableFuture.whenComplete((v, t) -> {
                    if (t == null || t instanceof CancellationException) {
                        this.replayFinished();
                    } else {
                        this.exception((Throwable)t);
                    }
                });
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(this.parent, "Cannot open file: " + e1.getMessage(), "Cannot open file", 0);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.parent, "Exception when retrieving data: " + e, "Exception when retrieving data", 0);
            }
        }
    }

    private void receivedCommadHistory(Commanding.CommandHistoryEntry che) throws IOException {
        int progr = (int)((che.getCommandId().getGenerationTime() - this.startInstant) / 1000L);
        ++this.count;
        if (this.count % 100 == 0) {
            this.progressMonitor.setNote(this.count + " packets received");
        }
        this.progressMonitor.setProgress(progr);
        this.cmdhistFormatter.writeCommand(che);
    }

    private void replayFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    CommandHistoryRetrievalGui.this.cmdhistFormatter.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(CommandHistoryRetrievalGui.this.parent, "Error when closing the output file: " + e.getMessage(), "Error when closing the output file", 0);
                }
                if (CommandHistoryRetrievalGui.this.progressMonitor.isCanceled()) {
                    JOptionPane.showMessageDialog(CommandHistoryRetrievalGui.this.parent, "Retrieval canceled. " + CommandHistoryRetrievalGui.this.count + " packets retrieved");
                } else {
                    CommandHistoryRetrievalGui.this.progressMonitor.close();
                    float speed = (long)(CommandHistoryRetrievalGui.this.count * 1000) / (System.currentTimeMillis() - CommandHistoryRetrievalGui.this.downloadStartTime);
                    JOptionPane.showMessageDialog(CommandHistoryRetrievalGui.this.parent, "The command retrieval finished successfully. " + CommandHistoryRetrievalGui.this.count + " commands retrieved in " + CommandHistoryRetrievalGui.this.outputFile + ". Retrieval speed: " + speed + " cmd/sec");
                }
            }
        });
    }

    public void exception(Throwable e) {
        final String message = e.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(CommandHistoryRetrievalGui.this.parent, message, message, 0);
                CommandHistoryRetrievalGui.this.progressMonitor.close();
            }
        });
    }
}

