/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import io.netty.handler.codec.http.HttpMethod;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.yamcs.YamcsException;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.rest.RestClient;
import org.yamcs.api.ws.ConnectionListener;
import org.yamcs.api.ws.WebSocketClientCallback;
import org.yamcs.api.ws.WebSocketRequest;
import org.yamcs.api.ws.WebSocketResponseHandler;
import org.yamcs.protobuf.Commanding;
import org.yamcs.protobuf.Web;
import org.yamcs.ui.CommandQueueListener;

public class CommandQueueControlClient
implements ConnectionListener,
WebSocketClientCallback,
WebSocketResponseHandler {
    YamcsConnector yconnector;
    List<CommandQueueListener> listeners = new CopyOnWriteArrayList<CommandQueueListener>();

    public CommandQueueControlClient(YamcsConnector yconnector) {
        this.yconnector = yconnector;
        yconnector.addConnectionListener((ConnectionListener)this);
    }

    public void addCommandQueueListener(CommandQueueListener cmdQueueListener) {
        this.listeners.add(cmdQueueListener);
    }

    public void connected(String url) {
        WebSocketRequest wsr = new WebSocketRequest("cqueues", "subscribe");
        this.yconnector.performSubscription(wsr, (WebSocketClientCallback)this, (WebSocketResponseHandler)this);
    }

    private void sendLog(String message) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).log(message);
        }
    }

    public void setQueueState(Commanding.CommandQueueInfo cqi, boolean rebuild) {
        RestClient restClient = this.yconnector.getRestClient();
        String resource = "/processors/" + cqi.getInstance() + "/" + cqi.getProcessorName() + "/cqueues/" + cqi.getName() + "?state=" + cqi.getState().toString();
        CompletableFuture cf = restClient.doRequest(resource, HttpMethod.PATCH);
        cf.whenComplete((result, exception) -> {
            if (exception != null) {
                this.sendLog("Exception setting queue state: " + exception.getMessage());
            }
        });
    }

    public void releaseCommand(Commanding.CommandQueueEntry cqe, boolean rebuild) throws YamcsApiException, YamcsException {
        RestClient restClient = this.yconnector.getRestClient();
        String resource = "/processors/" + cqe.getInstance() + "/" + cqe.getProcessorName() + "/cqueues/" + cqe.getQueueName() + "/entries/" + cqe.getUuid() + "?state=released";
        CompletableFuture cf = restClient.doRequest(resource, HttpMethod.PATCH);
        cf.whenComplete((result, exception) -> {
            if (exception != null) {
                this.sendLog("Exception releasing command: " + exception.getMessage());
            }
        });
    }

    public void rejectCommand(Commanding.CommandQueueEntry cqe) {
        RestClient restClient = this.yconnector.getRestClient();
        String resource = "/processors/" + cqe.getInstance() + "/" + cqe.getProcessorName() + "/cqueues/" + cqe.getQueueName() + "/entries/" + cqe.getUuid() + "?state=rejected";
        CompletableFuture cf = restClient.doRequest(resource, HttpMethod.PATCH);
        cf.whenComplete((result, exception) -> {
            if (exception != null) {
                this.sendLog("Exception releasing command: " + exception.getMessage());
            }
        });
    }

    public void connecting(String url) {
    }

    public void connectionFailed(String url, YamcsException exception) {
    }

    public void disconnected() {
    }

    public void log(String message) {
    }

    public void onMessage(Web.WebSocketServerMessage.WebSocketSubscriptionData data) {
        if (data.hasCommandQueueInfo()) {
            Commanding.CommandQueueInfo cmdQueueInfo = data.getCommandQueueInfo();
            for (CommandQueueListener cql : this.listeners) {
                cql.updateQueue(cmdQueueInfo);
            }
        }
        if (data.hasCommandQueueEvent()) {
            Commanding.CommandQueueEvent cmdQueueEvent = data.getCommandQueueEvent();
            Commanding.CommandQueueEntry cqe = cmdQueueEvent.getData();
            Commanding.CommandQueueEvent.Type eventType = cmdQueueEvent.getType();
            for (CommandQueueListener cql : this.listeners) {
                switch (eventType) {
                    case COMMAND_ADDED: {
                        cql.commandAdded(cqe);
                        break;
                    }
                    case COMMAND_REJECTED: {
                        cql.commandRejected(cqe);
                        break;
                    }
                    case COMMAND_SENT: {
                        cql.commandSent(cqe);
                    }
                }
            }
        }
    }

    public void onException(Web.WebSocketServerMessage.WebSocketExceptionData e) {
    }
}

