/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import io.netty.handler.codec.http.HttpMethod;
import java.util.concurrent.CompletableFuture;
import org.yamcs.YamcsException;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.rest.RestClient;
import org.yamcs.api.ws.ConnectionListener;
import org.yamcs.api.ws.WebSocketClientCallback;
import org.yamcs.api.ws.WebSocketRequest;
import org.yamcs.api.ws.WebSocketResponseHandler;
import org.yamcs.protobuf.Web;
import org.yamcs.protobuf.YamcsManagement;
import org.yamcs.ui.LinkListener;

public class LinkControlClient
implements ConnectionListener,
WebSocketResponseHandler,
WebSocketClientCallback {
    final LinkListener linkListener;
    YamcsConnector yconnector;

    public LinkControlClient(YamcsConnector yconnector, LinkListener linkListener) {
        this.yconnector = yconnector;
        yconnector.addConnectionListener((ConnectionListener)this);
        this.linkListener = linkListener;
    }

    public void enable(YamcsManagement.LinkInfo li) throws YamcsApiException, YamcsException {
        RestClient restClient = this.yconnector.getRestClient();
        String resource = "/links/" + li.getInstance() + "/" + li.getName() + "?state=enabled";
        CompletableFuture cf = restClient.doRequest(resource, HttpMethod.PATCH);
        cf.whenComplete((result, exception) -> {
            if (exception != null) {
                this.linkListener.log("Exception enabling link: " + exception.getMessage());
            }
        });
    }

    public void disable(YamcsManagement.LinkInfo li) throws YamcsApiException, YamcsException {
        RestClient restClient = this.yconnector.getRestClient();
        String resource = "/links/" + li.getInstance() + "/" + li.getName() + "?state=disabled";
        CompletableFuture cf = restClient.doRequest(resource, HttpMethod.PATCH);
        cf.whenComplete((result, exception) -> {
            if (exception != null) {
                this.linkListener.log("Exception disabling link: " + exception.getMessage());
            }
        });
    }

    public void connected(String url) {
        this.receiveInitialConfig();
    }

    public void receiveInitialConfig() {
        WebSocketRequest wsr = new WebSocketRequest("links", "subscribe");
        this.yconnector.performSubscription(wsr, (WebSocketClientCallback)this, (WebSocketResponseHandler)this);
    }

    public void connectionFailed(String url, YamcsException exception) {
    }

    public void disconnected() {
    }

    public void connecting(String url) {
    }

    public void log(String message) {
    }

    public void onException(Web.WebSocketServerMessage.WebSocketExceptionData e) {
        System.out.println("LinkControlClient.onException " + e);
    }

    public void onMessage(Web.WebSocketServerMessage.WebSocketSubscriptionData data) {
        if (data.hasLinkEvent()) {
            YamcsManagement.LinkEvent linkEv = data.getLinkEvent();
            this.linkListener.updateLink(linkEv.getLinkInfo());
        }
    }
}

