/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListIndexBar
extends JComponent {
    private static final long serialVersionUID = 1L;
    private int itemCount;
    private double scaleFactor;
    private int markerHeight;
    private Set<Integer> markerSet = new HashSet<Integer>();
    private int highlightedIndex = -1;
    private List<ListSelectionListener> listeners = new ArrayList<ListSelectionListener>();

    public ListIndexBar(int itemCount) {
        this.itemCount = itemCount;
        this.recalc();
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                int pos = (int)((double)ListIndexBar.this.itemCount * (e.getPoint().getY() / (double)ListIndexBar.this.getHeight()));
                boolean found = false;
                if (ListIndexBar.this.scaleFactor < 1.0) {
                    for (int i = -ListIndexBar.this.markerHeight; i < ListIndexBar.this.markerHeight; ++i) {
                        if (!ListIndexBar.this.markerSet.contains(pos + i)) continue;
                        ListIndexBar.this.highlightedIndex = pos + i;
                        ListIndexBar.this.setCursor(Cursor.getPredefinedCursor(12));
                        found = true;
                        break;
                    }
                } else if (ListIndexBar.this.markerSet.contains(pos)) {
                    ListIndexBar.this.highlightedIndex = pos;
                    ListIndexBar.this.setCursor(Cursor.getPredefinedCursor(12));
                    found = true;
                }
                if (!found) {
                    ListIndexBar.this.highlightedIndex = -1;
                    ListIndexBar.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ListIndexBar.this.highlightedIndex != -1) {
                    ListSelectionEvent event = new ListSelectionEvent(ListIndexBar.this, ListIndexBar.this.highlightedIndex, ListIndexBar.this.highlightedIndex, false);
                    for (ListSelectionListener listener : ListIndexBar.this.listeners) {
                        listener.valueChanged(event);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ListIndexBar.this.highlightedIndex = -1;
            }
        });
        this.setMinimumSize(new Dimension(16, 60));
        this.setPreferredSize(new Dimension(16, 60));
    }

    public void addSelectionListener(ListSelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(ListSelectionListener listener) {
        this.listeners.remove(listener);
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setItemCount(int itemCount) {
        this.itemCount = itemCount;
        this.recalc();
        this.repaint();
    }

    private void recalc() {
        this.scaleFactor = (double)this.getHeight() / (double)this.itemCount;
        this.markerHeight = Math.max(2, (int)this.scaleFactor);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.recalc();
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.recalc();
    }

    public Set<Integer> getMarkerSet() {
        return this.markerSet;
    }

    public void addMarkers(Collection<Integer> markers) {
        this.markerSet.addAll(markers);
        this.repaint();
    }

    public void addMarker(int index) {
        this.markerSet.add(new Integer(index));
    }

    public void removeMarkers(Collection<Integer> markers) {
        this.markerSet.removeAll(markers);
        this.repaint();
    }

    public void clearMarkers() {
        this.markerSet.clear();
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Composite composite = g2.getComposite();
        g2.setColor(this.getBackground());
        if (!this.isOpaque()) {
            g2.setComposite(AlphaComposite.getInstance(9));
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setComposite(composite);
        g2.setColor(this.getForeground());
        for (Integer marker : this.markerSet) {
            int pos = (int)((double)marker.intValue() * this.scaleFactor);
            g2.fillRect(0, pos, this.getWidth(), this.markerHeight);
        }
    }
}

