/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.rest.RestClient;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.utils.CcsdsPacket;
import org.yamcs.utils.PacketFormatter;
import org.yamcs.utils.TimeEncoding;

public class PacketRetrievalGui
extends JFrame
implements ActionListener {
    JCheckBox withoutCcsds;
    JCheckBox pactsFakeHeaders;
    JCheckBox printHex;
    JButton startStop;
    JFileChooser fileChooser;
    List<String> packetNames;
    long startInstant;
    long stopInstant;
    String archiveInstance;
    Component parent;
    ProgressMonitor progressMonitor;
    private File outputFile;
    private OutputStream outputStream;
    YamcsConnectionProperties connectionParams;
    PacketFormatter packetFormatter;
    private CompletableFuture<Void> completableFuture;
    int count;
    long downloadSize;
    long downloadStartTime;

    public PacketRetrievalGui(YamcsConnectionProperties connectionParams, Component parent) {
        super("Dump Telemetry Packets");
        this.connectionParams = connectionParams;
        this.parent = parent;
        Container frameContentPane = this.getContentPane();
        frameContentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel("Dumping the selected telemetry packets into a file.");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        frameContentPane.add((Component)label, gbc);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 3));
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.withoutCcsds = new JCheckBox("Remove the CCSDS headers");
        optionsPanel.add(this.withoutCcsds);
        this.printHex = new JCheckBox("Print in hexadecimal rather than binary");
        optionsPanel.add(this.printHex);
        this.pactsFakeHeaders = new JCheckBox("Add a fake 32 bytes PaCTS header");
        optionsPanel.add(this.pactsFakeHeaders);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        frameContentPane.add((Component)optionsPanel, gbc);
        gbc.insets = new Insets(2, 2, 2, 2);
        this.fileChooser = new JFileChooser("Select Output Directory");
        this.fileChooser.setApproveButtonText("Save");
        this.fileChooser.addActionListener(this);
        gbc.gridy = 2;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        frameContentPane.add((Component)this.fileChooser, gbc);
        this.pack();
    }

    public void setValues(String archiveInstance, List<String> packetNames, long start, long stop) {
        this.packetNames = packetNames;
        this.startInstant = start;
        this.stopInstant = stop;
        this.archiveInstance = archiveInstance;
        if (packetNames.size() > 0) {
            String prefix = packetNames.get(0).split("_", 2)[0];
            String startWinCompatibleDateTime = TimeEncoding.toWinCompatibleDateTime((long)this.startInstant);
            String stopWinCompatibleDateTime = TimeEncoding.toWinCompatibleDateTime((long)this.stopInstant);
            String fileName = String.format("%s_packets_%s_%s.dump", prefix, startWinCompatibleDateTime, stopWinCompatibleDateTime);
            this.fileChooser.setSelectedFile(new File(this.fileChooser.getSelectedFile(), fileName));
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("CancelSelection")) {
            this.setVisible(false);
        } else {
            this.outputFile = this.fileChooser.getSelectedFile();
            if (this.outputFile.exists() && JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite " + this.outputFile, "Overwrite file?", 0, 2) == 1) {
                return;
            }
            this.setVisible(false);
            this.count = 0;
            this.downloadSize = 0L;
            this.downloadStartTime = System.currentTimeMillis();
            this.progressMonitor = new ProgressMonitor(this.parent, "Saving packets", "0 packets saved", 0, (int)((this.stopInstant - this.startInstant) / 1000L));
            try {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                this.packetFormatter = new PacketFormatter(this.outputStream);
                this.packetFormatter.setHex(this.printHex.isSelected());
                this.packetFormatter.setWithoutCcsds(this.withoutCcsds.isSelected());
                this.packetFormatter.setWithPacts(this.pactsFakeHeaders.isSelected());
                YamcsConnectionProperties ycd = this.connectionParams;
                ycd.setInstance(this.archiveInstance);
                RestClient restClient = new RestClient(ycd);
                StringBuilder sb = new StringBuilder();
                sb.append("/archive/").append(this.archiveInstance).append("/downloads/packets").append("?start=").append(TimeEncoding.toString((long)this.startInstant)).append("&stop=").append(TimeEncoding.toString((long)this.stopInstant)).append("&name=");
                boolean first = true;
                for (String pn : this.packetNames) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(",");
                    }
                    sb.append(pn);
                }
                this.completableFuture = restClient.doBulkGetRequest(sb.toString(), data -> {
                    try {
                        Yamcs.TmPacketData tmpacket = Yamcs.TmPacketData.parseFrom((byte[])data);
                        this.packetReceived(new CcsdsPacket(tmpacket.getPacket().asReadOnlyByteBuffer()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
                this.completableFuture.whenComplete((v, t) -> {
                    if (t == null || t instanceof CancellationException) {
                        this.replayFinished();
                    } else {
                        this.exception((Throwable)t);
                    }
                });
            }
            catch (FileNotFoundException e1) {
                JOptionPane.showMessageDialog(this.parent, "Cannot open file: " + e1.getMessage(), "Cannot open file", 0);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, "Exception when retrieving data: " + e.getMessage(), "Exception when retrieving data", 0);
            }
        }
    }

    public void packetReceived(CcsdsPacket c) {
        int progr = (int)((c.getInstant() - this.startInstant) / 1000L);
        ++this.count;
        this.downloadSize += (long)c.getLength();
        if (this.count % 100 == 0) {
            this.progressMonitor.setNote(this.count + " packets received");
        }
        this.progressMonitor.setProgress(progr);
        if (this.progressMonitor.isCanceled()) {
            this.completableFuture.cancel(true);
        }
        try {
            this.packetFormatter.writePacket(c);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void replayFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PacketRetrievalGui.this.packetFormatter.close();
                }
                catch (IOException e) {
                    JOptionPane.showMessageDialog(PacketRetrievalGui.this.parent, "Error when closing the output file: " + e.getMessage(), "Error when closing the output file", 0);
                }
                if (PacketRetrievalGui.this.progressMonitor.isCanceled()) {
                    JOptionPane.showMessageDialog(PacketRetrievalGui.this.parent, "Retrieval canceled. " + PacketRetrievalGui.this.count + " packets retrieved");
                } else {
                    PacketRetrievalGui.this.progressMonitor.close();
                    float speed = PacketRetrievalGui.this.downloadSize * 1000L / (1024L * (System.currentTimeMillis() - PacketRetrievalGui.this.downloadStartTime));
                    JOptionPane.showMessageDialog(PacketRetrievalGui.this.parent, "The packet retrieval finished successfully. " + PacketRetrievalGui.this.count + " packets retrieved in " + PacketRetrievalGui.this.outputFile + ". Retrieval speed: " + speed + " KiB/sec");
                }
            }
        });
    }

    public void exception(Throwable e) {
        final String message = e.toString();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(PacketRetrievalGui.this.parent, message, message, 0);
                PacketRetrievalGui.this.progressMonitor.close();
            }
        });
    }
}

