/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import com.google.protobuf.InvalidProtocolBufferException;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.rest.BulkRestDataReceiver;
import org.yamcs.api.rest.RestClient;
import org.yamcs.protobuf.Pvalue;
import org.yamcs.protobuf.Rest;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.ParameterSelectDialog;
import org.yamcs.ui.ParameterSelectDialogListener;
import org.yamcs.utils.ParameterFormatter;
import org.yamcs.utils.TimeEncoding;

public class ParameterRetrievalGui
extends JFrame
implements ParameterSelectDialogListener {
    JCheckBox printTime;
    JCheckBox printRaw;
    JCheckBox printUnique;
    JCheckBox keepValues;
    JCheckBox ignoreInvalidParameters;
    JCheckBox printFullLines;
    JCheckBox timeWindow;
    JTextField timeWindowSize;
    JButton startButton;
    JFileChooser loadfileChooser;
    JFileChooser outfileChooser;
    long start;
    long stop;
    String archiveInstance;
    Component parent;
    ProgressMonitor progressMonitor;
    JTextArea paramText;
    JTextField fileNameTextField;
    private BufferedWriter writer;
    private Preferences prefs;
    final int maxRecent = 10;
    ArrayList<String> recentFiles;
    JPopupMenu recentPopup;
    JButton recentButton;
    YamcsConnectionProperties connectionParams;
    private ParameterFormatter parameterFormatter;
    ParameterSelectDialog selectDialog;
    private CompletableFuture<Void> completableFuture;

    public ParameterRetrievalGui(YamcsConnectionProperties connectionParameters, Component parent) {
        super("Parameter Retrieval");
        String s;
        this.setDefaultCloseOperation(2);
        this.prefs = Preferences.userNodeForPackage(this.getClass());
        this.recentFiles = new ArrayList();
        int i = 1;
        while (!(s = this.prefs.get("recentFile" + i, "")).equalsIgnoreCase("")) {
            this.recentFiles.add(s);
            ++i;
        }
        this.connectionParams = connectionParameters;
        this.parent = parent;
        String home = System.getProperties().getProperty("user.home");
        this.loadfileChooser = new JFileChooser();
        this.loadfileChooser.setApproveButtonText("Load");
        this.loadfileChooser.setDialogTitle("Select a file containing parameter names");
        this.loadfileChooser.setCurrentDirectory(new File(this.prefs.get("loadPath", home)));
        this.outfileChooser = new JFileChooser();
        this.outfileChooser.setApproveButtonText("Choose");
        this.outfileChooser.setDialogTitle("Select output file");
        this.outfileChooser.setCurrentDirectory(new File(this.prefs.get("outputPath", home)));
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 11;
        JLabel label = new JLabel("Dump the selected telemetry parameters into a file.");
        gbc.gridwidth = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)label, gbc);
        Box optionsPanel = Box.createVerticalBox();
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Options"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.printTime = new JCheckBox("Print the generation time");
        this.printTime.setSelected(true);
        optionsPanel.add(this.printTime);
        this.printRaw = new JCheckBox("Print the raw value");
        optionsPanel.add(this.printRaw);
        this.printUnique = new JCheckBox("Print only the unique lines");
        optionsPanel.add(this.printUnique);
        this.printFullLines = new JCheckBox("Print only the full lines");
        optionsPanel.add(this.printFullLines);
        this.keepValues = new JCheckBox("Keep previous values");
        optionsPanel.add(this.keepValues);
        Box timeWindowPanel = Box.createHorizontalBox();
        this.timeWindow = new JCheckBox("Merging time window of");
        timeWindowPanel.add(this.timeWindow);
        this.timeWindowSize = new JTextField(5);
        this.timeWindowSize.setText("500");
        this.timeWindowSize.setMaximumSize(this.timeWindowSize.getPreferredSize());
        timeWindowPanel.add(this.timeWindowSize);
        JLabel l = new JLabel("ms");
        timeWindowPanel.add(l);
        timeWindowPanel.setAlignmentX(0.0f);
        optionsPanel.add(timeWindowPanel);
        this.ignoreInvalidParameters = new JCheckBox("Ignore Invalid Parameters");
        optionsPanel.add(this.ignoreInvalidParameters);
        gbc.gridwidth = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        this.getContentPane().add((Component)optionsPanel, gbc);
        Box paramPanel = Box.createVerticalBox();
        paramPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Parameters"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.paramText = new JTextArea(15, 30);
        TextAreaListener listener = new TextAreaListener(){

            @Override
            public void updated() {
                ParameterRetrievalGui.this.startButton.setEnabled(!ParameterRetrievalGui.this.paramText.getText().equalsIgnoreCase("") && !ParameterRetrievalGui.this.fileNameTextField.getText().equalsIgnoreCase(""));
            }
        };
        this.paramText.getDocument().addDocumentListener(listener);
        JScrollPane scrollPane = new JScrollPane(this.paramText);
        paramPanel.add(scrollPane);
        JPanel parambuttonPanel = new JPanel();
        paramPanel.add(parambuttonPanel);
        JButton button = new JButton("Open");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParameterRetrievalGui.this.loadParameters();
            }
        });
        parambuttonPanel.add(button);
        button = new JButton("Save");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParameterRetrievalGui.this.saveParameters();
            }
        });
        parambuttonPanel.add(button);
        this.recentPopup = new JPopupMenu();
        this.recentButton = new JButton("Recent");
        this.populateRecentMenu();
        this.recentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ParameterRetrievalGui.this.recentPopup.show(ParameterRetrievalGui.this.recentButton, 0, ParameterRetrievalGui.this.recentButton.getSize().height);
            }
        });
        parambuttonPanel.add(this.recentButton);
        JButton selectParamButton = new JButton("Select");
        selectParamButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterRetrievalGui.this.selectParameters();
            }
        });
        parambuttonPanel.add(selectParamButton);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        this.getContentPane().add((Component)paramPanel, gbc);
        Box outputPanel = Box.createHorizontalBox();
        outputPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Output File"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.fileNameTextField = new JTextField();
        outputPanel.add(this.fileNameTextField);
        button = new JButton("Choose");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParameterRetrievalGui.this.chooseOutputFile();
            }
        });
        outputPanel.add(button);
        gbc.gridwidth = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        this.getContentPane().add((Component)outputPanel, gbc);
        JPanel actionbuttonPanel = new JPanel();
        this.startButton = new JButton("Start Retrieval");
        this.startButton.setEnabled(false);
        actionbuttonPanel.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParameterRetrievalGui.this.startRetrieval();
            }
        });
        button = new JButton("Close");
        actionbuttonPanel.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParameterRetrievalGui.this.setVisible(false);
            }
        });
        gbc.gridwidth = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        this.getContentPane().add((Component)actionbuttonPanel, gbc);
        this.pack();
    }

    private void selectParameters() {
        List<String> params;
        YamcsConnectionProperties ycd = this.connectionParams.clone();
        ycd.setInstance(this.archiveInstance);
        if (this.selectDialog == null) {
            this.selectDialog = new ParameterSelectDialog(this, ycd);
            this.selectDialog.addListener(this);
        }
        if ((params = this.selectDialog.showDialog()) != null) {
            this.setParameters(params);
        }
    }

    @Override
    public void parametersAdded(List<String> opsnames) {
        this.addParameters(opsnames);
    }

    public void addParameters(List<String> opsnames) {
        List<String> currentOpsnames = Arrays.asList(this.paramText.getText().split("\n"));
        for (String opsname : opsnames) {
            if (currentOpsnames.contains(opsname)) continue;
            this.paramText.append(opsname);
            this.paramText.append("\n");
        }
    }

    public void setParameters(List<String> opsnames) {
        this.paramText.setText("");
        for (String opsname : opsnames) {
            this.paramText.append(opsname);
            this.paramText.append("\n");
        }
    }

    private void populateRecentMenu() {
        this.recentPopup.removeAll();
        for (int i = 0; i < this.recentFiles.size(); ++i) {
            final String s = this.recentFiles.get(i);
            this.recentPopup.add(new AbstractAction(s){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ParameterRetrievalGui.this.loadParameters(new File(s));
                }
            });
        }
        this.recentPopup.pack();
        this.recentButton.setEnabled(this.recentPopup.getComponentCount() > 0);
    }

    private void addRecentFile(File file) {
        String filename = file.getAbsolutePath();
        if (this.recentFiles.indexOf(filename) == -1) {
            while (this.recentFiles.size() > 10) {
                this.recentFiles.remove(0);
            }
            this.recentFiles.add(filename);
            for (int i = 0; i < this.recentFiles.size(); ++i) {
                this.prefs.put("recentFile" + (i + 1), this.recentFiles.get(i));
            }
            this.populateRecentMenu();
        }
    }

    public void setValues(String archiveInstance, long start, long stop) {
        this.start = start;
        this.stop = stop;
        this.archiveInstance = archiveInstance;
        String startWinCompatibleDateTime = TimeEncoding.toWinCompatibleDateTime((long)start);
        String stopWinCompatibleDateTime = TimeEncoding.toWinCompatibleDateTime((long)stop);
        this.fileNameTextField.setText(String.format("parameters_%s_%s.dump", startWinCompatibleDateTime, stopWinCompatibleDateTime));
    }

    private void showErrorMessage(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(ParameterRetrievalGui.this.getParent(), s, ParameterRetrievalGui.this.getTitle(), 0);
            }
        });
    }

    private void showMessage(String s) {
        JOptionPane.showMessageDialog(this.getParent(), s, this.getTitle(), 1);
    }

    private void loadParameters() {
        int returnVal = this.loadfileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File f = this.loadfileChooser.getSelectedFile();
            this.prefs.put("loadPath", this.loadfileChooser.getCurrentDirectory().getAbsolutePath());
            this.loadParameters(f);
        }
    }

    private void loadParameters(File f) {
        try {
            this.startButton.setEnabled(false);
            this.paramText.setText("");
            List<Yamcs.NamedObjectId> paraList = ParameterRetrievalGui.loadParameters(new BufferedReader(new FileReader(f)));
            for (Yamcs.NamedObjectId id : paraList) {
                if ("MDB:OPS Name".equals(id.getNamespace())) {
                    this.paramText.append(id.getName());
                } else {
                    this.paramText.append(id.getNamespace() + ":" + id.getName());
                }
                this.paramText.append("\n");
            }
            this.addRecentFile(f);
        }
        catch (IOException e) {
            this.showErrorMessage("Cannot load parameters: " + e.getMessage());
        }
    }

    public static List<Yamcs.NamedObjectId> loadParameters(BufferedReader reader) throws IOException {
        ArrayList<Yamcs.NamedObjectId> paramList;
        block6: {
            String line;
            block7: {
                paramList = new ArrayList<Yamcs.NamedObjectId>();
                line = reader.readLine();
                if (line == null) {
                    return paramList;
                }
                if (!line.contains("<")) break block7;
                Pattern p1 = Pattern.compile(".*\\<TelemetryName context=\"CGS_ALIAS\"\\>(\\w+)\\<\\/TelemetryName\\>.*");
                Pattern p2 = Pattern.compile(".*<string>Opsname</string>.*");
                Pattern p3 = Pattern.compile(".*\\<string\\>(\\w+)\\<\\/string\\>.*");
                do {
                    Matcher m1;
                    if ((m1 = p1.matcher(line)).matches()) {
                        paramList.add(Yamcs.NamedObjectId.newBuilder().setNamespace("MDB:OPS Name").setName(m1.group(1)).build());
                        continue;
                    }
                    Matcher m2 = p2.matcher(line);
                    if (!m2.matches()) continue;
                    line = reader.readLine();
                    if (line == null) break block6;
                    Matcher m3 = p3.matcher(line);
                    if (!m3.matches()) continue;
                    paramList.add(Yamcs.NamedObjectId.newBuilder().setNamespace("MDB:OPS Name").setName(m3.group(1)).build());
                } while ((line = reader.readLine()) != null);
                break block6;
                {
                }
            }
            do {
                String[] params;
                for (String p : params = line.split("[ \t]+")) {
                    if (p.length() <= 0) continue;
                    paramList.add(Yamcs.NamedObjectId.newBuilder().setNamespace("MDB:OPS Name").setName(line).build());
                }
            } while ((line = reader.readLine()) != null);
        }
        return paramList;
    }

    private void saveParameters() {
        int returnVal = this.loadfileChooser.showSaveDialog(this);
        if (returnVal == 0) {
            File f = this.loadfileChooser.getSelectedFile();
            try {
                PrintWriter w = new PrintWriter(f);
                w.print(this.paramText.getText());
                w.close();
                this.addRecentFile(f);
            }
            catch (IOException e) {
                this.showErrorMessage("Cannot save parameters file: " + e.getMessage());
            }
        }
    }

    private void chooseOutputFile() {
        this.outfileChooser.setSelectedFile(new File(this.outfileChooser.getCurrentDirectory(), this.fileNameTextField.getText()));
        int returnVal = this.outfileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File outputFile = this.outfileChooser.getSelectedFile();
            if (outputFile.exists() && JOptionPane.showConfirmDialog(this, "Are you sure you want to overwrite " + outputFile, this.getTitle(), 0, 2) == 1) {
                return;
            }
            this.fileNameTextField.setText(outputFile.getAbsolutePath());
            this.prefs.put("outputPath", this.outfileChooser.getCurrentDirectory().getAbsolutePath());
            if (!this.paramText.getText().equalsIgnoreCase("") && !this.fileNameTextField.getText().equalsIgnoreCase("")) {
                this.startButton.setEnabled(true);
            }
        }
    }

    private void startRetrieval() {
        List<Yamcs.NamedObjectId> paramList;
        try {
            paramList = ParameterRetrievalGui.loadParameters(new BufferedReader(new CharArrayReader(this.paramText.getText().toCharArray())));
        }
        catch (IOException e) {
            this.showErrorMessage("Cannot apply parameters: " + e.getMessage());
            return;
        }
        this.setVisible(false);
        this.progressMonitor = new ProgressMonitor(this.parent, "Saving parameters", "0 lines saved", 0, (int)((this.stop - this.start) / 1000L));
        try {
            this.writer = new BufferedWriter(new FileWriter(this.fileNameTextField.getText()));
            this.parameterFormatter = new ParameterFormatter(this.writer, paramList);
            this.parameterFormatter.setPrintTime(this.printTime.isSelected());
            this.parameterFormatter.setPrintRaw(this.printRaw.isSelected());
            this.parameterFormatter.setPrintUnique(this.printUnique.isSelected());
            if (this.timeWindow.isSelected()) {
                try {
                    this.parameterFormatter.setTimeWindow(Integer.parseInt(this.timeWindowSize.getText()));
                }
                catch (NumberFormatException e) {
                    this.showErrorMessage("Cannot parse number: " + e.getMessage() + ". Please make sure that the number is integer");
                }
            } else {
                this.parameterFormatter.resetTimeWindow();
            }
            this.parameterFormatter.setAllParametersPresent(this.printFullLines.isSelected());
            this.parameterFormatter.setKeepValues(this.keepValues.isSelected());
            YamcsConnectionProperties ycd = this.connectionParams.clone();
            ycd.setInstance(this.archiveInstance);
            RestClient restClient = new RestClient(ycd);
            Rest.BulkDownloadParameterValueRequest prr = Rest.BulkDownloadParameterValueRequest.newBuilder().addAllId(paramList).setStart(TimeEncoding.toString((long)this.start)).setStop(TimeEncoding.toString((long)this.stop)).build();
            this.completableFuture = restClient.doBulkGetRequest("/archive/" + this.archiveInstance + "/downloads/parameters", prr.toByteArray(), new BulkRestDataReceiver(){

                public void receiveData(byte[] data) throws YamcsApiException {
                    try {
                        Pvalue.ParameterData pd = Pvalue.ParameterData.parseFrom((byte[])data);
                        ParameterRetrievalGui.this.updateParameters(pd.getParameterList());
                    }
                    catch (InvalidProtocolBufferException e) {
                        ParameterRetrievalGui.this.gotException(new Exception("Exception decoding data: " + e.getMessage()));
                    }
                }
            });
            this.completableFuture.whenComplete((v, t) -> {
                if (t == null || t instanceof CancellationException) {
                    this.replayFinished();
                } else {
                    this.gotException((Throwable)t);
                }
            });
        }
        catch (Exception e) {
            this.gotException(e);
        }
    }

    private void updateParameters(List<Pvalue.ParameterValue> paramList) {
        if (this.completableFuture.isCancelled()) {
            return;
        }
        try {
            this.parameterFormatter.writeParameters(paramList);
            int linesReceived = this.parameterFormatter.getLinesReceived();
            long time = paramList.get(0).getGenerationTime();
            int progr = (int)((time - this.start) / 1000L);
            if (linesReceived % 100 == 0) {
                this.progressMonitor.setNote(this.getNote());
            }
            this.progressMonitor.setProgress(progr);
            if (this.progressMonitor.isCanceled()) {
                this.completableFuture.cancel(true);
            }
        }
        catch (IOException e) {
            this.gotException(e);
        }
    }

    private void replayFinished() {
        try {
            this.parameterFormatter.close();
        }
        catch (Exception e) {
            this.gotException(e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ParameterRetrievalGui.this.progressMonitor.isCanceled()) {
                    ParameterRetrievalGui.this.showMessage("Retrieval cancelled. " + ParameterRetrievalGui.this.getNote());
                } else {
                    ParameterRetrievalGui.this.progressMonitor.close();
                    ParameterRetrievalGui.this.showMessage("The parameter retrieval finished successfully. " + ParameterRetrievalGui.this.getNote() + " in " + ParameterRetrievalGui.this.fileNameTextField.getText());
                }
            }
        });
    }

    private String getNote() {
        int linesSaved = this.parameterFormatter.getLinesSaved();
        int linesReceived = this.parameterFormatter.getLinesReceived();
        if (linesReceived != linesSaved) {
            return linesReceived + " lines received, " + linesSaved + " lines saved";
        }
        return linesReceived + " lines received";
    }

    public void gotException(Throwable e) {
        e.printStackTrace();
        String message = "Error when retrieving parameters: " + e;
        this.showErrorMessage(message);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ParameterRetrievalGui(null, null);
            }
        });
    }

    abstract class TextAreaListener
    implements DocumentListener {
        TextAreaListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.updated();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.updated();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.updated();
        }

        public abstract void updated();
    }
}

