/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import io.netty.handler.codec.http.HttpMethod;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.yamcs.api.MediaType;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.rest.RestClient;
import org.yamcs.ui.ListIndexBar;
import org.yamcs.ui.ParameterSelectDialogListener;
import org.yamcs.ui.XtceDbCellRenderer;
import org.yamcs.ui.XtceDbTreeModel;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.XtceDb;

public class ParameterSelectDialog
extends JDialog
implements ActionListener,
KeyListener,
TreeSelectionListener {
    private static final long serialVersionUID = 201212121400L;
    private YamcsConnectionProperties connectData;
    private XtceDb xtcedb;
    private final JTree treeView;
    private JLabel errorLabel;
    private XtceDbTreeModel tm;
    private JTextField searchField;
    private List<ParameterSelectDialogListener> listeners;
    ListIndexBar bar;

    public ParameterSelectDialog(JFrame parent, YamcsConnectionProperties ycd) {
        this(parent, ycd, null);
    }

    public ParameterSelectDialog(JFrame parent, YamcsConnectionProperties ycd, XtceDb db) {
        super(parent, "Parameter Selection", true);
        this.xtcedb = db;
        this.connectData = ycd;
        this.listeners = new ArrayList<ParameterSelectDialogListener>();
        JPanel searchButtonPanel = new JPanel();
        searchButtonPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)searchButtonPanel, "North");
        searchButtonPanel.add((Component)new JLabel("Search"), "West");
        this.searchField = new JTextField("");
        this.searchField.addKeyListener(this);
        searchButtonPanel.add((Component)this.searchField, "Center");
        this.errorLabel = new JLabel("Loading...");
        this.getContentPane().add((Component)new JScrollPane(this.errorLabel), "Center");
        this.loadXtcedb();
        this.tm = new XtceDbTreeModel(this.xtcedb);
        this.treeView = new JTree(this.tm);
        this.treeView.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.treeView);
        this.treeView.setCellRenderer(new XtceDbCellRenderer());
        this.treeView.setExpandsSelectedPaths(true);
        if (this.xtcedb != null) {
            JScrollPane scrollPane = new JScrollPane(this.treeView);
            scrollPane.setVerticalScrollBarPolicy(22);
            this.getContentPane().add((Component)scrollPane, "Center");
        }
        this.bar = new ListIndexBar(this.treeView.getRowCount());
        this.bar.setBackground(Color.white);
        this.bar.setForeground(Color.BLUE);
        this.bar.setOpaque(false);
        this.getContentPane().add((Component)this.bar, "East");
        this.bar.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedIndex = e.getFirstIndex();
                ParameterSelectDialog.this.treeView.scrollRowToVisible(selectedIndex);
            }
        });
        JPanel buttonPanel = new JPanel();
        this.getContentPane().add((Component)buttonPanel, "South");
        JButton button = new JButton("Add");
        button.setActionCommand("add");
        button.addActionListener(this);
        this.getRootPane().setDefaultButton(button);
        buttonPanel.add(button);
        button = new JButton("Close");
        button.setActionCommand("close");
        button.addActionListener(this);
        buttonPanel.add(button);
        this.setMinimumSize(new Dimension(350, 100));
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.searchField.requestFocusInWindow();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("add".equals(cmd)) {
            for (ParameterSelectDialogListener l : this.listeners) {
                l.parametersAdded(this.getSelectedParameterOpsNames());
            }
        } else {
            this.setVisible(false);
        }
    }

    public void updateBar() {
        this.bar.setItemCount(this.treeView.getRowCount());
        this.bar.clearMarkers();
        int[] selectedRows = this.treeView.getSelectionRows();
        if (selectedRows != null) {
            for (int row : selectedRows) {
                this.bar.addMarker(row);
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.updateBar();
    }

    public void loadXtcedb() {
        if (this.xtcedb != null) {
            return;
        }
        RestClient restClient = new RestClient(this.connectData);
        try {
            restClient.setAcceptMediaType(MediaType.JAVA_SERIALIZED_OBJECT);
            restClient.setMaxResponseLength(0xA00000);
            byte[] serializedMdb = (byte[])restClient.doRequest("/mdb/" + this.connectData.getInstance(), HttpMethod.GET).get();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serializedMdb));
            Object o = ois.readObject();
            this.xtcedb = (XtceDb)o;
            ois.close();
            this.setLoadSuccess();
        }
        catch (Exception e) {
            System.out.println("Exception whilst getting mission database: " + e.getMessage());
            this.setLoadFail(e.getMessage());
        }
    }

    private void setLoadFail(String message) {
        if (this.treeView != null) {
            this.treeView.setVisible(false);
        }
        if (this.searchField != null) {
            this.searchField.setVisible(false);
        }
        this.errorLabel.setVisible(true);
        this.errorLabel.setText(message);
    }

    private void setLoadSuccess() {
        this.errorLabel.setVisible(false);
        if (this.treeView != null) {
            this.treeView.setVisible(true);
        }
        if (this.searchField != null) {
            this.searchField.setVisible(true);
        }
    }

    public List<String> getSelectedParameterOpsNames() {
        ArrayList<String> params = new ArrayList<String>();
        for (Parameter p : this.getSelectedParameters()) {
            params.add(p.getOpsName());
        }
        return params;
    }

    public List<Parameter> getSelectedParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        TreePath[] selectedPaths = this.treeView.getSelectionPaths();
        if (selectedPaths != null) {
            for (TreePath tp : selectedPaths) {
                Object node = tp.getLastPathComponent();
                if (!(node instanceof Parameter)) continue;
                params.add((Parameter)node);
            }
        }
        return params;
    }

    public List<Object> getSelected() {
        ArrayList<Object> selected = new ArrayList<Object>();
        TreePath[] selectedPaths = this.treeView.getSelectionPaths();
        if (selectedPaths != null) {
            for (TreePath tp : selectedPaths) {
                selected.add(tp.getLastPathComponent());
            }
        }
        return selected;
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
        TreePath[] selected = this.treeView.getSelectionPaths();
        this.tm.setAlwaysShown(this.getSelected());
        this.tm.setFilterText(this.searchField.getText());
        this.treeView.setSelectionPaths(selected);
        this.updateBar();
    }

    public void addListener(ParameterSelectDialogListener l) {
        this.listeners.add(l);
    }

    public void removeListener(ParameterSelectDialogListener l) {
        this.listeners.remove(l);
    }

    public List<String> showDialog() {
        this.setVisible(true);
        return null;
    }
}

