/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.yamcs.xtce.ContainerEntry;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.SequenceContainer;
import org.yamcs.xtce.SpaceSystem;

class XtceDbCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 201211201034L;

    XtceDbCellRenderer() {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String tooltipBody = null;
        if (value instanceof SpaceSystem) {
            super.getTreeCellRendererComponent(tree, ((SpaceSystem)value).getOpsName(), selected, expanded, leaf, row, hasFocus);
            tooltipBody = ((SpaceSystem)value).getQualifiedName() + "<br />" + ((SpaceSystem)value).getHeader();
        } else if (value instanceof SequenceContainer) {
            super.getTreeCellRendererComponent(tree, ((SequenceContainer)value).getOpsName(), selected, expanded, leaf, row, hasFocus);
            tooltipBody = ((SequenceContainer)value).getName();
            if (((SequenceContainer)value).getAliasSet() != null) {
                tooltipBody = tooltipBody + "<br />" + ((SequenceContainer)value).getAliasSet().toString();
            }
        } else if (value instanceof Parameter) {
            super.getTreeCellRendererComponent(tree, ((Parameter)value).getOpsName(), selected, expanded, leaf, row, hasFocus);
            Parameter p = (Parameter)value;
            ParameterType type = p.getParameterType();
            if (type != null) {
                tooltipBody = "Type: " + type.toString().replaceFirst(" encoding:", "<br />Encoding:");
            }
        } else if (value instanceof ContainerEntry) {
            super.getTreeCellRendererComponent(tree, "(" + ((ContainerEntry)value).getLocationInContainerInBits() + ") " + ((ContainerEntry)value).getRefContainer().getOpsName(), selected, expanded, leaf, row, hasFocus);
            tooltipBody = ((ContainerEntry)value).getRefContainer().getOpsName();
        } else {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
        if (tooltipBody != null) {
            this.setToolTipText("<html>" + tooltipBody + "</html>");
        }
        return this;
    }
}

