/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.yamcs.ui.OpsNameComparator;
import org.yamcs.xtce.ContainerEntry;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterEntry;
import org.yamcs.xtce.SequenceContainer;
import org.yamcs.xtce.SequenceEntry;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.XtceDb;

public class XtceDbTreeModel
implements TreeModel {
    protected XtceDb xtcedb;
    protected SpaceSystem root;
    protected List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
    protected List<SequenceContainer> visibleContainers = new ArrayList<SequenceContainer>();
    protected Map<SequenceContainer, List<Parameter>> visibleEntries = new HashMap<SequenceContainer, List<Parameter>>();
    private List<String> filterTerms;
    private List<Object> alwaysShown;
    private List<Object> neverShown;
    public boolean allParamsVisibleIfParentVisible = true;
    SequenceContainer others;

    public XtceDbTreeModel(XtceDb db) {
        this.xtcedb = db;
        this.filterTerms = new ArrayList<String>();
        this.alwaysShown = new ArrayList<Object>();
        this.neverShown = new ArrayList<Object>();
        this.others = new SequenceContainer("OTHERS");
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.visibleContainers.get(index);
        }
        if (parent instanceof SequenceContainer) {
            return this.visibleEntries.get(parent).get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.visibleContainers.size();
        }
        if (parent instanceof SequenceContainer) {
            return this.visibleEntries.get(parent).size();
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.root) {
            return this.visibleContainers.indexOf(child);
        }
        if (parent instanceof SequenceContainer) {
            return this.visibleEntries.get(parent).indexOf(child);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        if (this.root == null) {
            if (this.xtcedb != null) {
                this.root = this.xtcedb.getRootSpaceSystem();
            }
            this.createCache();
        }
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        return node instanceof Parameter;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected List<ParameterEntry> getParameterEntries(Object container) {
        ArrayList<ParameterEntry> entryList = new ArrayList<ParameterEntry>();
        if (container instanceof SequenceContainer) {
            for (SequenceEntry se : ((SequenceContainer)container).getEntryList()) {
                if (se instanceof ParameterEntry) {
                    entryList.add((ParameterEntry)se);
                    continue;
                }
                if (!(se instanceof ContainerEntry)) continue;
                entryList.addAll(this.getParameterEntries(((ContainerEntry)se).getRefContainer()));
            }
        }
        return entryList;
    }

    protected void createCache() {
        this.visibleContainers.clear();
        this.visibleEntries.clear();
        if (this.xtcedb == null) {
            return;
        }
        HashSet orphanedParameters = new HashSet();
        orphanedParameters.addAll(this.xtcedb.getParameters());
        for (SequenceContainer sc : this.xtcedb.getSequenceContainers()) {
            this.visibleEntries.put(sc, new ArrayList());
            boolean addContainer = this.isVisible(sc);
            for (ParameterEntry pe : this.getParameterEntries(sc)) {
                orphanedParameters.remove(pe.getParameter());
                if ((!this.allParamsVisibleIfParentVisible || !addContainer) && !this.isVisible(pe)) continue;
                addContainer = true;
                this.visibleEntries.get(sc).add(pe.getParameter());
            }
            if (!addContainer) continue;
            this.visibleContainers.add(sc);
        }
        if (!orphanedParameters.isEmpty()) {
            this.visibleEntries.put(this.others, new ArrayList());
            boolean addContainer = this.isVisible(this.others);
            for (Parameter param : orphanedParameters) {
                if (!this.isVisible(param)) continue;
                this.visibleEntries.get(this.others).add(param);
                addContainer = true;
            }
            if (addContainer) {
                this.visibleContainers.add(this.others);
            }
        }
        Collections.sort(this.visibleContainers, new OpsNameComparator());
    }

    public void setFilterText(String filter) {
        this.filterTerms.clear();
        for (String term : filter.toLowerCase().split("\\*")) {
            this.filterTerms.add(term);
        }
        this.createCache();
        this.signalTreeStructureChanged();
    }

    private String getFilterableText(Object o) {
        String name = null;
        name = o instanceof SequenceContainer ? ((SequenceContainer)o).getOpsName().toLowerCase() : (o instanceof Parameter ? ((Parameter)o).getOpsName().toLowerCase() : o.toString().toLowerCase());
        return name;
    }

    protected boolean isVisible(Object o) {
        if (o == this.root) {
            return true;
        }
        if (this.alwaysShown.contains(o)) {
            return true;
        }
        if (this.neverShown.contains(o)) {
            return false;
        }
        String haystack = this.getFilterableText(o);
        for (String needle : this.filterTerms) {
            if (haystack.contains(needle)) continue;
            return false;
        }
        return true;
    }

    public List<Object> getAlwaysShown() {
        return this.alwaysShown;
    }

    public void setAlwaysShown(List<Object> alwaysShown) {
        this.alwaysShown = alwaysShown;
        this.createCache();
    }

    public List<Object> getNeverShown() {
        return this.neverShown;
    }

    public void setNeverShown(List<Object> neverShown) {
        this.neverShown = neverShown;
        this.createCache();
    }

    private void signalTreeStructureChanged() {
        for (TreeModelListener l : this.listeners) {
            l.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.root}));
        }
    }
}

