/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui;

import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.handler.codec.http.HttpMethod;
import java.util.concurrent.CompletableFuture;
import org.yamcs.api.YamcsApiException;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.rest.BulkRestDataReceiver;
import org.yamcs.api.rest.RestClient;
import org.yamcs.protobuf.Rest;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.archivebrowser.ArchiveIndexListener;
import org.yamcs.ui.archivebrowser.ArchiveIndexReceiver;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.utils.TimeInterval;

public class YamcsArchiveIndexReceiver
implements ArchiveIndexReceiver {
    ArchiveIndexListener indexListener;
    private volatile boolean receiving = false;
    YamcsConnector yconnector;

    public YamcsArchiveIndexReceiver(YamcsConnector yconnector) {
        this.yconnector = yconnector;
    }

    @Override
    public void setIndexListener(ArchiveIndexListener ail) {
        this.indexListener = ail;
    }

    @Override
    public void getIndex(String instance, TimeInterval interval) {
        if (this.receiving) {
            this.indexListener.log("already receiving data");
            return;
        }
        if (instance == null) {
            this.indexListener.receiveArchiveRecordsError("No yamcs instance to get data from");
            return;
        }
        this.yconnector.getExecutor().submit(() -> {
            try {
                RestClient restClient = this.yconnector.getRestClient();
                StringBuilder resource = new StringBuilder().append("/archive/" + instance + "/indexes?");
                if (interval.hasStart()) {
                    resource.append("start=" + TimeEncoding.toString((long)interval.getStart()));
                }
                if (interval.hasEnd()) {
                    resource.append("&stop=" + TimeEncoding.toString((long)interval.getEnd()));
                }
                CompletableFuture f = restClient.doBulkGetRequest(resource.toString(), new BulkRestDataReceiver(){

                    public void receiveData(byte[] data) throws YamcsApiException {
                        try {
                            YamcsArchiveIndexReceiver.this.indexListener.receiveArchiveRecords(Yamcs.IndexResult.parseFrom((byte[])data));
                        }
                        catch (InvalidProtocolBufferException e) {
                            throw new YamcsApiException("Error parsing index result: " + e.getMessage());
                        }
                    }

                    public void receiveException(Throwable t) {
                        YamcsArchiveIndexReceiver.this.indexListener.receiveArchiveRecordsError(t.getMessage());
                    }
                });
                f.get();
                this.indexListener.receiveArchiveRecordsFinished();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.indexListener.receiveArchiveRecordsError(e.toString());
            }
            finally {
                this.receiving = false;
            }
        });
    }

    @Override
    public void getTag(String instance, TimeInterval interval) {
        if (this.receiving) {
            this.indexListener.log("already receiving data");
            return;
        }
        this.yconnector.getExecutor().submit(() -> {
            try {
                RestClient restClient = this.yconnector.getRestClient();
                StringBuilder resource = new StringBuilder().append("/archive/" + instance + "/tags?");
                if (interval.hasStart()) {
                    resource.append("start=" + TimeEncoding.toString((long)interval.getStart()));
                }
                if (interval.hasEnd()) {
                    resource.append("&stop=" + TimeEncoding.toString((long)interval.getEnd()));
                }
                CompletableFuture f = restClient.doRequest(resource.toString(), HttpMethod.GET);
                byte[] data = (byte[])f.get();
                Rest.ListTagsResponse ltr = Rest.ListTagsResponse.parseFrom((byte[])data);
                this.indexListener.receiveTags(ltr.getTagList());
                this.indexListener.receiveTagsFinished();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.indexListener.receiveArchiveRecordsError(e.getMessage());
            }
            finally {
                this.receiving = false;
            }
        });
    }

    @Override
    public void insertTag(String instance, Yamcs.ArchiveTag tag) {
        Rest.CreateTagRequest ctr = Rest.CreateTagRequest.newBuilder().setColor(tag.getColor()).setDescription(tag.getDescription()).setName(tag.getName()).setStart(TimeEncoding.toString((long)tag.getStart())).setStop(TimeEncoding.toString((long)tag.getStop())).build();
        try {
            RestClient restClient = this.yconnector.getRestClient();
            StringBuilder resource = new StringBuilder().append("/archive/" + instance + "/tags");
            byte[] data = (byte[])restClient.doRequest(resource.toString(), HttpMethod.POST, ctr.toByteArray()).get();
            this.indexListener.tagAdded(Yamcs.ArchiveTag.parseFrom((byte[])data));
        }
        catch (Exception e) {
            this.indexListener.log("Failed to insert tag: " + e.getMessage());
        }
    }

    @Override
    public void updateTag(String instance, Yamcs.ArchiveTag oldTag, Yamcs.ArchiveTag newTag) {
        Rest.EditTagRequest etr = Rest.EditTagRequest.newBuilder().setColor(newTag.getColor()).setDescription(newTag.getDescription()).setName(newTag.getName()).setStart(TimeEncoding.toString((long)newTag.getStart())).setStop(TimeEncoding.toString((long)newTag.getStop())).build();
        try {
            RestClient restClient = this.yconnector.getRestClient();
            StringBuilder resource = new StringBuilder().append("/archive/").append(instance).append("/tags/").append(TimeEncoding.toString((long)oldTag.getStart())).append("/").append(oldTag.getId());
            byte[] data = (byte[])restClient.doRequest(resource.toString(), HttpMethod.PATCH, etr.toByteArray()).get();
            this.indexListener.tagChanged(oldTag, Yamcs.ArchiveTag.parseFrom((byte[])data));
        }
        catch (Exception e) {
            this.indexListener.log("Failed to insert tag: " + e.getMessage());
        }
    }

    @Override
    public void deleteTag(String instance, Yamcs.ArchiveTag tag) {
        RestClient restClient = this.yconnector.getRestClient();
        StringBuilder resource = new StringBuilder().append("/archive/").append(instance).append("/tags/").append(TimeEncoding.toString((long)tag.getStart())).append("/").append(tag.getId());
        try {
            byte[] data = (byte[])restClient.doRequest(resource.toString(), HttpMethod.DELETE).get();
            this.indexListener.tagRemoved(Yamcs.ArchiveTag.parseFrom((byte[])data));
        }
        catch (Exception e) {
            this.indexListener.log("Failed to remove tag: " + e.getMessage());
        }
    }

    @Override
    public boolean supportsTags() {
        return true;
    }
}

