/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.yamcs.ConfigurationException;
import org.yamcs.YConfiguration;
import org.yamcs.YamcsException;
import org.yamcs.api.YamcsConnectDialog;
import org.yamcs.api.YamcsConnectionProperties;
import org.yamcs.api.YamcsConnector;
import org.yamcs.api.ws.ConnectionListener;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.YamcsArchiveIndexReceiver;
import org.yamcs.ui.archivebrowser.ArchiveIndexListener;
import org.yamcs.ui.archivebrowser.ArchiveIndexReceiver;
import org.yamcs.ui.archivebrowser.ArchivePanel;
import org.yamcs.utils.TimeEncoding;
import org.yamcs.utils.TimeInterval;
import org.yamcs.utils.YObjectLoader;

public class ArchiveBrowser
extends JFrame
implements ArchiveIndexListener,
ConnectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    ArchiveIndexReceiver indexReceiver;
    public ArchivePanel archivePanel;
    public JMenuBar menuBar;
    JMenuItem connectMenuItem;
    YamcsConnector yconnector;
    private String instance;
    private long lastErrorDialogTime = 0L;

    public ArchiveBrowser(YamcsConnector yconnector, ArchiveIndexReceiver ir, boolean replayEnabled) throws IOException, ConfigurationException {
        super("Archive Browser");
        this.yconnector = yconnector;
        this.indexReceiver = ir;
        this.setIconImage(ArchivePanel.getIcon("yamcs-32x32.png").getImage());
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        JMenu fileMenu = new JMenu("File");
        this.menuBar.add(fileMenu);
        this.connectMenuItem = new JMenuItem();
        this.connectMenuItem.setText("Connect to Yamcs...");
        this.connectMenuItem.setMnemonic(67);
        this.connectMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        fileMenu.add(this.connectMenuItem);
        fileMenu.addSeparator();
        JMenuItem closeMenuItem = new JMenuItem();
        closeMenuItem.setMnemonic(81);
        closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        closeMenuItem.setText("Quit");
        closeMenuItem.setActionCommand("exit");
        closeMenuItem.addActionListener(this);
        fileMenu.add(closeMenuItem);
        JMenu toolsMenu = this.getToolsMenu();
        if (toolsMenu != null) {
            this.menuBar.add(toolsMenu);
        }
        this.archivePanel = new ArchivePanel(this, replayEnabled);
        this.archivePanel.prefs.reloadButton.addActionListener(this);
        this.getRootPane().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ArchiveBrowser.this.archivePanel.onWindowResizing();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ArchiveBrowser.this.archivePanel.onWindowResized();
            }
        });
        this.setContentPane(this.archivePanel);
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    protected JMenu getToolsMenu() throws ConfigurationException, IOException {
        YConfiguration config = YConfiguration.getConfiguration((String)"yamcs-ui");
        if (!config.containsKey("archiveBrowserTools")) {
            return null;
        }
        List tools = config.getList("archiveBrowserTools");
        JMenu toolsMenu = new JMenu("Tools");
        for (Map m : tools) {
            JMenuItem menuItem = new JMenuItem((String)m.get("name"));
            toolsMenu.add(menuItem);
            String className = (String)m.get("class");
            YObjectLoader objLoader = new YObjectLoader();
            JFrame f = (JFrame)YObjectLoader.loadObject((String)className, (Object[])new Object[]{this.yconnector});
            menuItem.addActionListener(e -> f.setVisible(true));
        }
        return toolsMenu;
    }

    protected void showMessage(String msg) {
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), -1);
    }

    protected void showInfo(String msg) {
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 1);
    }

    protected void showError(String msg) {
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
    }

    public void connecting(String url) {
        this.log("Connecting to " + url);
    }

    public void connected(String url) {
        try {
            List instances = this.yconnector.getYamcsInstances();
            if (instances != null) {
                this.archivePanel.setInstances(instances);
                this.archivePanel.connected();
                this.requestData();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void connectionFailed(String url, YamcsException exception) {
        this.archivePanel.disconnected();
        if (this.lastErrorDialogTime < System.currentTimeMillis() - 5000L) {
            JOptionPane.showMessageDialog(this, exception.toString(), this.getClass().getName(), 0);
            this.lastErrorDialogTime = System.currentTimeMillis();
        }
    }

    public void disconnected() {
        this.archivePanel.disconnected();
    }

    public void log(String text) {
        System.out.println(text);
    }

    public void popup(String text) {
        this.showMessage(text);
    }

    @Override
    public void receiveArchiveRecords(Yamcs.IndexResult ir) {
        this.archivePanel.receiveArchiveRecords(ir);
    }

    @Override
    public void receiveArchiveRecordsError(String errorMessage) {
        this.archivePanel.receiveArchiveRecordsError(errorMessage);
    }

    @Override
    public void receiveArchiveRecordsFinished() {
        if (this.indexReceiver.supportsTags()) {
            TimeInterval interval = this.archivePanel.getRequestedDataInterval();
            this.indexReceiver.getTag(this.instance, interval);
        } else {
            this.archivePanel.archiveLoadFinished();
        }
    }

    @Override
    public void receiveTagsFinished() {
        this.archivePanel.archiveLoadFinished();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equalsIgnoreCase("reload")) {
            this.requestData();
        } else if (cmd.equalsIgnoreCase("exit")) {
            System.exit(0);
        }
    }

    private void requestData() {
        this.archivePanel.startReloading();
        TimeInterval interval = this.archivePanel.getRequestedDataInterval();
        this.indexReceiver.getIndex(this.instance, interval);
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: archive-browser.sh [-h] [url]");
        System.err.println("-h:\tShow this help text");
        System.err.println("url:\tConnect at startup to the given url");
        System.err.println("Example to yamcs archive:\n\t archive-browser.sh http://localhost:8090/");
        System.exit(1);
    }

    @Override
    public void receiveTags(List<Yamcs.ArchiveTag> tagList) {
        SwingUtilities.invokeLater(() -> this.archivePanel.tagsAdded(tagList));
    }

    @Override
    public void tagAdded(Yamcs.ArchiveTag ntag) {
        SwingUtilities.invokeLater(() -> this.archivePanel.tagAdded(ntag));
    }

    @Override
    public void tagRemoved(Yamcs.ArchiveTag rtag) {
        SwingUtilities.invokeLater(() -> this.archivePanel.tagRemoved(rtag));
    }

    @Override
    public void tagChanged(Yamcs.ArchiveTag oldTag, Yamcs.ArchiveTag newTag) {
        SwingUtilities.invokeLater(() -> this.archivePanel.tagChanged(oldTag, newTag));
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public static void main(String[] args) throws URISyntaxException, ConfigurationException, IOException {
        YamcsConnectionProperties params = null;
        for (int i = 0; i < args.length; ++i) {
            String initialUrl;
            if (args[i].equals("-h")) {
                ArchiveBrowser.printUsageAndExit();
                continue;
            }
            if (args.length != i + 1) {
                ArchiveBrowser.printUsageAndExit();
            }
            if ((initialUrl = args[i]).startsWith("http://")) {
                params = YamcsConnectionProperties.parse((String)initialUrl);
                continue;
            }
            ArchiveBrowser.printUsageAndExit();
        }
        TimeEncoding.setUp();
        final YamcsConnector yconnector = new YamcsConnector("ArchiveBrowser");
        YamcsArchiveIndexReceiver ir = new YamcsArchiveIndexReceiver(yconnector);
        ArchiveBrowser archiveBrowser = new ArchiveBrowser(yconnector, ir, false);
        YConfiguration config = YConfiguration.getConfiguration((String)"yamcs-ui");
        boolean aetmp = false;
        if (config.containsKey("authenticationEnabled")) {
            aetmp = config.getBoolean("authenticationEnabled");
        }
        boolean enableAuth = aetmp;
        archiveBrowser.connectMenuItem.addActionListener(e -> {
            YamcsConnectDialog.YamcsConnectDialogResult r = YamcsConnectDialog.showDialog((JFrame)archiveBrowser, (boolean)false, (boolean)enableAuth);
            if (r.isOk()) {
                yconnector.connect(r.getConnectionProperties());
            }
        });
        ir.setIndexListener(archiveBrowser);
        yconnector.addConnectionListener((ConnectionListener)archiveBrowser);
        if (params != null) {
            yconnector.connect(params);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("shutting down");
                yconnector.disconnect();
            }
        });
        archiveBrowser.setVisible(true);
    }
}

