/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolBar;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.ui.UiColors;
import org.yamcs.ui.archivebrowser.ArchiveBrowser;
import org.yamcs.ui.archivebrowser.DataView;
import org.yamcs.ui.archivebrowser.DataViewer;
import org.yamcs.ui.archivebrowser.NavigatorItem;
import org.yamcs.ui.archivebrowser.PrefsToolbar;
import org.yamcs.ui.archivebrowser.ReplayPanel;
import org.yamcs.ui.archivebrowser.Selection;
import org.yamcs.ui.archivebrowser.SideNavigator;
import org.yamcs.ui.archivebrowser.TagTimeline;
import org.yamcs.utils.TimeInterval;

public class ArchivePanel
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    ProgressMonitor progressMonitor;
    ArchiveBrowser archiveBrowser;
    JLabel totalRangeLabel;
    JLabel statusInfoLabel;
    JLabel instanceLabel;
    private LinkedHashMap<String, NavigatorItem> itemsByName = new LinkedHashMap();
    SideNavigator sideNavigator;
    JToolBar archiveToolbar;
    protected PrefsToolbar prefs;
    private JPanel insetPanel;
    private JPanel navigatorItemPanel;
    private NavigatorItem activeItem;
    public ReplayPanel replayPanel;
    int loadCount;
    int recCount;
    boolean passiveUpdate = false;
    private TimeInterval receivedDataInterval = new TimeInterval();
    volatile boolean lowOnMemoryReported = false;
    MemoryPoolMXBean heapMemoryPoolBean = null;

    public ArchivePanel(ArchiveBrowser archiveBrowser, boolean replayEnabled) {
        super(new BorderLayout());
        this.archiveBrowser = archiveBrowser;
        Box fixedTop = Box.createVerticalBox();
        fixedTop.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, UiColors.BORDER_COLOR));
        this.prefs = new PrefsToolbar();
        this.prefs.setAlignmentX(0.0f);
        fixedTop.add(this.prefs);
        this.archiveToolbar = new JToolBar();
        this.archiveToolbar.setFloatable(false);
        this.archiveToolbar.setAlignmentX(0.0f);
        fixedTop.add(this.archiveToolbar);
        if (replayEnabled) {
            this.replayPanel = new ReplayPanel();
            this.replayPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Replay Control"));
            this.replayPanel.setToolTipText("Doubleclick between the start/stop locators to reposition the replay.");
            this.replayPanel.setAlignmentX(0.0f);
            fixedTop.add(this.replayPanel);
        }
        DataViewer allViewer = new DataViewer(archiveBrowser.yconnector, archiveBrowser.indexReceiver, this, replayEnabled){

            @Override
            public String getLabelName() {
                return "Archive";
            }

            @Override
            public JComponent createContentPanel() {
                JComponent component = super.createContentPanel();
                this.addIndex("completeness", "completeness index");
                this.addIndex("tm", "tm histogram", 1000);
                this.addIndex("pp", "pp histogram", 1000);
                this.addIndex("cmdhist", "cmdhist histogram", 1000);
                this.addVerticalGlue();
                return component;
            }
        };
        this.itemsByName.put(allViewer.getLabelName(), allViewer);
        DataViewer completenessViewer = new DataViewer(archiveBrowser.yconnector, archiveBrowser.indexReceiver, this, false){

            @Override
            public String getLabelName() {
                return "Telemetry Completeness";
            }

            @Override
            public int getIndent() {
                return 1;
            }

            @Override
            public JComponent createContentPanel() {
                JComponent component = super.createContentPanel();
                this.addIndex("completeness", "completeness index");
                this.addVerticalGlue();
                return component;
            }
        };
        this.itemsByName.put(completenessViewer.getLabelName(), completenessViewer);
        DataViewer tmViewer = new DataViewer(archiveBrowser.yconnector, archiveBrowser.indexReceiver, this, replayEnabled){

            @Override
            public String getLabelName() {
                return "Telemetry";
            }

            @Override
            public int getIndent() {
                return 1;
            }

            @Override
            public JComponent createContentPanel() {
                JComponent component = super.createContentPanel();
                this.addIndex("tm", "tm histogram", 1000);
                this.addVerticalGlue();
                return component;
            }
        };
        this.itemsByName.put(tmViewer.getLabelName(), tmViewer);
        DataViewer ppViewer = new DataViewer(archiveBrowser.yconnector, archiveBrowser.indexReceiver, this, replayEnabled){

            @Override
            public String getLabelName() {
                return "Processed Parameters";
            }

            @Override
            public int getIndent() {
                return 1;
            }

            @Override
            public JComponent createContentPanel() {
                JComponent component = super.createContentPanel();
                this.addIndex("pp", "pp histogram", 1000);
                this.addVerticalGlue();
                return component;
            }
        };
        this.itemsByName.put(ppViewer.getLabelName(), ppViewer);
        DataViewer cmdViewer = new DataViewer(archiveBrowser.yconnector, archiveBrowser.indexReceiver, this, false){

            @Override
            public String getLabelName() {
                return "Command History";
            }

            @Override
            public int getIndent() {
                return 1;
            }

            @Override
            public JComponent createContentPanel() {
                JComponent component = super.createContentPanel();
                this.addIndex("cmdhist", "cmdhist histogram", 1000);
                this.addVerticalGlue();
                return component;
            }
        };
        this.itemsByName.put(cmdViewer.getLabelName(), cmdViewer);
        this.add((Component)fixedTop, "North");
        this.add((Component)this.createStatusBar(), "South");
        this.sideNavigator = new SideNavigator(this);
        this.add((Component)this.sideNavigator, "West");
        this.navigatorItemPanel = new JPanel(new CardLayout());
        this.add((Component)this.navigatorItemPanel, "Center");
        this.insetPanel = new JPanel(new CardLayout());
        this.insetPanel.setVisible(false);
        this.sideNavigator.add((Component)this.insetPanel, "South");
        for (Map.Entry<String, NavigatorItem> entry : this.itemsByName.entrySet()) {
            String name = entry.getKey();
            NavigatorItem navigatorItem = entry.getValue();
            this.navigatorItemPanel.add((Component)navigatorItem.getContentPanel(), name);
            this.sideNavigator.addItem(name, navigatorItem.getIndent(), navigatorItem);
            JComponent navInset = navigatorItem.getNavigatorInset();
            if (navInset == null) continue;
            this.insetPanel.add((Component)navInset, name);
        }
        this.openItem("Archive");
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isCollectionUsageThresholdSupported()) continue;
            this.heapMemoryPoolBean = pool;
            this.heapMemoryPoolBean.setCollectionUsageThreshold((int)Math.floor((double)this.heapMemoryPoolBean.getUsage().getMax() * 0.95));
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(event -> {
            if (this.activeItem instanceof DataViewer) {
                DataView dataView = ((DataViewer)this.activeItem).getDataView();
                if (!(event.getSource() instanceof JScrollBar) && !(event.getSource() instanceof TagTimeline) && SwingUtilities.isDescendingFrom((Component)event.getSource(), dataView)) {
                    MouseEvent me = SwingUtilities.convertMouseEvent((Component)event.getSource(), (MouseEvent)event, dataView.indexPanel);
                    if (event.getID() == 506) {
                        dataView.doMouseDragged(me);
                    } else if (event.getID() == 501) {
                        dataView.doMousePressed(me);
                    } else if (event.getID() == 502) {
                        dataView.doMouseReleased(me);
                    } else if (event.getID() == 503) {
                        dataView.doMouseMoved(me);
                    } else if (event.getID() == 505) {
                        dataView.doMouseExited(me);
                    }
                }
            }
        }, 48L);
    }

    public void openItem(String name) {
        NavigatorItem item = this.getItemByName(name);
        this.fireIntentionToSwitchActiveItem(item);
    }

    public NavigatorItem getItemByName(String name) {
        return this.itemsByName.get(name);
    }

    void fireIntentionToSwitchActiveItem(NavigatorItem sourceItem) {
        if (this.activeItem == sourceItem) {
            return;
        }
        this.sideNavigator.updateActiveItem(sourceItem);
        CardLayout ncl = (CardLayout)this.navigatorItemPanel.getLayout();
        ncl.show(this.navigatorItemPanel, sourceItem.getLabelName());
        if (sourceItem.getNavigatorInset() != null) {
            CardLayout icl = (CardLayout)this.insetPanel.getLayout();
            icl.show(this.insetPanel, sourceItem.getLabelName());
            this.insetPanel.setVisible(true);
        } else {
            this.insetPanel.setVisible(false);
        }
        if (this.activeItem != null) {
            this.activeItem.onClose();
        }
        sourceItem.onOpen();
        this.activeItem = sourceItem;
    }

    private Box createStatusBar() {
        Box bar = Box.createHorizontalBox();
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(2, 0, 0, 0, UiColors.BORDER_COLOR);
        Border insideBorder = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        bar.setBorder(BorderFactory.createCompoundBorder(outsideBorder, insideBorder));
        bar.add(Box.createHorizontalGlue());
        bar.add(this.createLabelForStatusBar(" Instance: "));
        this.instanceLabel = this.createLabelForStatusBar(null);
        bar.add(this.instanceLabel);
        bar.add(this.createLabelForStatusBar(", Data Range: "));
        this.totalRangeLabel = this.createLabelForStatusBar(null);
        bar.add(this.totalRangeLabel);
        bar.add(Box.createHorizontalGlue());
        this.statusInfoLabel = this.createLabelForStatusBar(null);
        bar.add(this.statusInfoLabel);
        return bar;
    }

    private JLabel createLabelForStatusBar(String text) {
        JLabel lbl = new JLabel();
        if (text != null) {
            lbl.setText(text);
        }
        lbl.setFont(lbl.getFont().deriveFont(0, lbl.getFont().getSize2D() - 2.0f));
        return lbl;
    }

    void updateStatusBar() {
        this.passiveUpdate = true;
        if (this.loadCount == 0) {
            this.statusInfoLabel.setText("(no data loaded) ");
        } else {
            this.statusInfoLabel.setText("Loading Data ... " + this.loadCount + " ");
            this.statusInfoLabel.repaint();
        }
        this.totalRangeLabel.setText(this.receivedDataInterval.toStringEncoded());
        this.totalRangeLabel.repaint();
        this.passiveUpdate = false;
    }

    public synchronized void startReloading() {
        this.recCount = 0;
        this.archiveBrowser.setInstance(this.prefs.getInstance());
        this.setBusyPointer();
        SwingUtilities.invokeLater(() -> {
            this.prefs.reloadButton.setEnabled(false);
            this.instanceLabel.setText(this.archiveBrowser.getInstance());
        });
        for (NavigatorItem item : this.itemsByName.values()) {
            item.startReloading();
        }
        if (this.lowOnMemoryReported) {
            System.gc();
            this.lowOnMemoryReported = false;
        }
        this.receivedDataInterval = new TimeInterval();
    }

    public static ImageIcon getIcon(String imagename) {
        return new ImageIcon(ArchivePanel.class.getResource("/org/yamcs/images/" + imagename));
    }

    protected static void debugLog(String s) {
        System.out.println(s);
    }

    protected static void debugLogComponent(String name, JComponent c) {
        Insets in = c.getInsets();
        ArchivePanel.debugLog("component " + name + ": min(" + c.getMinimumSize().width + "," + c.getMinimumSize().height + ") pref(" + c.getPreferredSize().width + "," + c.getPreferredSize().height + ") max(" + c.getMaximumSize().width + "," + c.getMaximumSize().height + ") size(" + c.getSize().width + "," + c.getSize().height + ") insets(" + in.top + "," + in.left + "," + in.bottom + "," + in.right + ")");
    }

    void playOrStopPressed() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        ArchivePanel.debugLog(e.getPropertyName() + "/" + e.getOldValue() + "/" + e.getNewValue());
    }

    public void setInstances(List<String> archiveInstances) {
        this.prefs.setInstances(archiveInstances);
    }

    public void connected() {
        this.prefs.reloadButton.setEnabled(true);
    }

    public void disconnected() {
        this.prefs.reloadButton.setEnabled(false);
    }

    public void setBusyPointer() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setNormalPointer() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public synchronized TimeInterval getRequestedDataInterval() {
        return this.prefs.getInterval();
    }

    public synchronized void receiveArchiveRecords(Yamcs.IndexResult ir) {
        if (this.heapMemoryPoolBean != null && this.heapMemoryPoolBean.isCollectionUsageThresholdExceeded()) {
            if (!this.lowOnMemoryReported) {
                this.lowOnMemoryReported = true;
                this.receiveArchiveRecordsError("The memory is almost exhausted, ignoring received Archive Records. Consider increasing the maximum heap size -Xmx parameter");
            }
            return;
        }
        for (NavigatorItem navigatorItem : this.itemsByName.values()) {
            navigatorItem.receiveArchiveRecords(ir);
        }
        for (Yamcs.ArchiveRecord r : ir.getRecordsList()) {
            long start = r.getFirst();
            long stop = r.getLast();
            if (!this.receivedDataInterval.hasStart() || start < this.receivedDataInterval.getStart()) {
                this.receivedDataInterval.setStart(start);
            }
            if (!this.receivedDataInterval.hasEnd() || stop > this.receivedDataInterval.getEnd()) {
                this.receivedDataInterval.setEnd(stop);
            }
            ++this.recCount;
            ++this.loadCount;
            this.updateStatusBar();
        }
    }

    public synchronized void receiveArchiveRecordsError(String errorMessage) {
        SwingUtilities.invokeLater(() -> {
            for (NavigatorItem navigatorItem : this.itemsByName.values()) {
                navigatorItem.receiveArchiveRecordsError(errorMessage);
            }
            JOptionPane.showMessageDialog(this, "Error when receiving archive records: " + errorMessage, "error receiving archive records", 0);
            this.prefs.reloadButton.setEnabled(true);
            this.setNormalPointer();
        });
    }

    void seekReplay(long newPosition) {
        this.replayPanel.seekReplay(newPosition);
    }

    public synchronized void archiveLoadFinished() {
        this.loadCount = 0;
        if (this.receivedDataInterval.hasStart() && this.receivedDataInterval.hasEnd()) {
            for (NavigatorItem item : this.itemsByName.values()) {
                item.archiveLoadFinished();
            }
            this.prefs.savePreferences();
        }
        SwingUtilities.invokeLater(() -> {
            this.statusInfoLabel.setText("");
            this.prefs.reloadButton.setEnabled(true);
            this.setNormalPointer();
        });
    }

    public void tagAdded(Yamcs.ArchiveTag ntag) {
        for (NavigatorItem navigatorItem : this.itemsByName.values()) {
            navigatorItem.tagAdded(ntag);
        }
    }

    public void tagRemoved(Yamcs.ArchiveTag rtag) {
        for (NavigatorItem navigatorItem : this.itemsByName.values()) {
            navigatorItem.tagRemoved(rtag);
        }
    }

    public void tagChanged(Yamcs.ArchiveTag oldTag, Yamcs.ArchiveTag newTag) {
        for (NavigatorItem navigatorItem : this.itemsByName.values()) {
            navigatorItem.tagChanged(oldTag, newTag);
        }
    }

    public void tagsAdded(List<Yamcs.ArchiveTag> tagList) {
        for (NavigatorItem navigatorItem : this.itemsByName.values()) {
            navigatorItem.receiveTags(tagList);
        }
    }

    public Selection getSelection() {
        DataViewer dataViewer = (DataViewer)this.activeItem;
        return dataViewer.getDataView().getSelection();
    }

    public List<String> getSelectedPackets(String tableName) {
        DataViewer dataViewer = (DataViewer)this.activeItem;
        if (dataViewer.getDataView().indexBoxes.containsKey(tableName)) {
            return dataViewer.getDataView().getSelectedPackets(tableName);
        }
        return Collections.emptyList();
    }

    public void onWindowResizing() {
        this.activeItem.windowResized();
    }

    public void onWindowResized() {
        for (NavigatorItem navigatorItem : this.itemsByName.values()) {
            navigatorItem.windowResized();
        }
    }

    public synchronized TimeInterval getReceivedDataInterval() {
        return this.receivedDataInterval;
    }

    static class IndexChunkSpec
    implements Comparable<IndexChunkSpec> {
        long startInstant;
        long stopInstant;
        int tmcount;
        String info;

        IndexChunkSpec(long start, long stop, int tmcount, String info) {
            this.startInstant = start;
            this.stopInstant = stop;
            this.tmcount = tmcount;
            this.info = info;
        }

        float getFrequency() {
            float freq = (float)(this.tmcount - 1) / ((float)(this.stopInstant - this.startInstant) / 1000.0f);
            freq = (float)Math.round(freq * 1000.0f) / 1000.0f;
            return freq;
        }

        @Override
        public int compareTo(IndexChunkSpec a) {
            return Long.signum(this.startInstant - a.startInstant);
        }

        public boolean merge(IndexChunkSpec t, long mergeTime) {
            boolean merge = false;
            if (this.tmcount == 1) {
                if (t.startInstant - this.stopInstant < mergeTime) {
                    merge = true;
                }
            } else {
                float dist = (float)(this.stopInstant - this.startInstant) / (float)(this.tmcount - 1);
                if ((float)(t.startInstant - this.stopInstant) < dist + (float)mergeTime) {
                    merge = true;
                }
            }
            if (merge) {
                this.stopInstant = t.stopInstant;
                this.tmcount += t.tmcount;
            }
            return merge;
        }

        public String toString() {
            return "start: " + this.startInstant + " stop: " + this.stopInstant + " count:" + this.tmcount;
        }
    }
}

