/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.yamcs.ui.archivebrowser.ColorUtils;

class ColorIcon
implements Icon {
    private Color color;
    static int size;
    static Map<String, ColorIcon> icons;

    private ColorIcon(Color color) {
        this.color = color;
    }

    @Override
    public int getIconHeight() {
        return size;
    }

    @Override
    public int getIconWidth() {
        return size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.color);
        g.fillRect(x, y, size - 1, size - 1);
        g.setColor(Color.black);
        g.drawRect(x, y, size - 1, size - 1);
    }

    public static ColorIcon getIcon(String colorName) {
        ColorIcon icon = icons.get(colorName);
        if (icon == null) {
            icon = new ColorIcon(ColorUtils.getColor(colorName));
            icons.put(colorName, icon);
        }
        return icon;
    }

    public String toString() {
        return "ColorIcon(color: " + this.color + ", size:" + size + ")";
    }

    static {
        icons = new HashMap<String, ColorIcon>();
    }
}

