/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.ui.archivebrowser;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class ColorUtils {
    static final Map<String, Color> colors = new HashMap<String, Color>();
    private static final Map<String, Color> hexColors = new HashMap<String, Color>();
    private static final Map<String, Color> opposingColors = new HashMap<String, Color>();

    public static Color getColor(String colorName) {
        Color color = colors.get(colorName);
        if (color == null) {
            color = hexColors.get(colorName);
        }
        if (color == null && colorName.startsWith("#")) {
            int r = Integer.valueOf(colorName.substring(1, 3), 16);
            int g = Integer.valueOf(colorName.substring(3, 5), 16);
            int b = Integer.valueOf(colorName.substring(5, 7), 16);
            color = new Color(r, g, b);
            hexColors.put(colorName, color);
            int brightness = (int)Math.sqrt(0.241 * (double)r * (double)r + 0.691 * (double)g * (double)g + 0.068 * (double)b * (double)b);
            opposingColors.put(colorName, brightness < 130 ? Color.WHITE : Color.BLACK);
        }
        return color;
    }

    public static Color getOpposite(String colorName) {
        return opposingColors.get(colorName);
    }

    static {
        colors.put("black", Color.BLACK);
        opposingColors.put("black", Color.WHITE);
        colors.put("blue", Color.BLUE);
        opposingColors.put("blue", Color.WHITE);
        colors.put("cyan", Color.CYAN);
        opposingColors.put("cyan", Color.BLACK);
        colors.put("gray", Color.GRAY);
        opposingColors.put("gray", Color.WHITE);
        colors.put("green", Color.GREEN);
        opposingColors.put("green", Color.BLACK);
        colors.put("magenta", Color.MAGENTA);
        opposingColors.put("magenta", Color.BLACK);
        colors.put("orange", Color.ORANGE);
        opposingColors.put("orange", Color.BLACK);
        colors.put("pink", Color.PINK);
        opposingColors.put("pink", Color.BLACK);
        colors.put("red", Color.RED);
        opposingColors.put("red", Color.WHITE);
        colors.put("yellow", Color.YELLOW);
        opposingColors.put("yellow", Color.BLACK);
    }
}

